"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _moneyn = _interopRequireDefault(require("./moneyn"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SHIFT_LEFT_32 = (1 << 16) * (1 << 16);
const SHIFT_RIGHT_32 = 1 / SHIFT_LEFT_32;
const NULL_LENGTH = Buffer.from([0x00]);
const DATA_LENGTH = Buffer.from([0x08]);
const Money = {
  id: 0x3C,
  type: 'MONEY',
  name: 'Money',
  declaration: function () {
    return 'money';
  },
  generateTypeInfo: function () {
    return Buffer.from([_moneyn.default.id, 0x08]);
  },
  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }
    return DATA_LENGTH;
  },
  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }
    const value = parameter.value * 10000;
    const buffer = Buffer.alloc(8);
    buffer.writeInt32LE(Math.floor(value * SHIFT_RIGHT_32), 0);
    buffer.writeInt32LE(value & -1, 4);
    yield buffer;
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }
    value = parseFloat(value);
    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }
    // money： -922337203685477.5808 to 922337203685477.5807
    // in javascript -922337203685477.5808 === -922337203685477.6
    //                922337203685477.5807 === 922337203685477.6
    // javascript number doesn't have enough precision.
    if (value < -922337203685477.6 || value > 922337203685477.6) {
      throw new TypeError('Value must be between -922337203685477.5808 and 922337203685477.5807, inclusive.');
    }
    return value;
  }
};
var _default = exports.default = Money;
module.exports = Money;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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