"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _datetimen = _interopRequireDefault(require("./datetimen"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const EPOCH_DATE = new Date(1900, 0, 1);
const UTC_EPOCH_DATE = new Date(Date.UTC(1900, 0, 1));
const DATA_LENGTH = Buffer.from([0x04]);
const NULL_LENGTH = Buffer.from([0x00]);
const SmallDateTime = {
  id: 0x3A,
  type: 'DATETIM4',
  name: 'SmallDateTime',
  declaration: function () {
    return 'smalldatetime';
  },
  generateTypeInfo() {
    return Buffer.from([_datetimen.default.id, 0x04]);
  },
  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }
    return DATA_LENGTH;
  },
  generateParameterData: function* (parameter, options) {
    if (parameter.value == null) {
      return;
    }
    const buffer = Buffer.alloc(4);
    let days, dstDiff, minutes;
    if (options.useUTC) {
      days = Math.floor((parameter.value.getTime() - UTC_EPOCH_DATE.getTime()) / (1000 * 60 * 60 * 24));
      minutes = parameter.value.getUTCHours() * 60 + parameter.value.getUTCMinutes();
    } else {
      dstDiff = -(parameter.value.getTimezoneOffset() - EPOCH_DATE.getTimezoneOffset()) * 60 * 1000;
      days = Math.floor((parameter.value.getTime() - EPOCH_DATE.getTime() + dstDiff) / (1000 * 60 * 60 * 24));
      minutes = parameter.value.getHours() * 60 + parameter.value.getMinutes();
    }
    buffer.writeUInt16LE(days, 0);
    buffer.writeUInt16LE(minutes, 2);
    yield buffer;
  },
  validate: function (value, collation, options) {
    if (value == null) {
      return null;
    }
    if (!(value instanceof Date)) {
      value = new Date(Date.parse(value));
    }
    value = value;
    let year, month, date;
    if (options && options.useUTC) {
      year = value.getUTCFullYear();
      month = value.getUTCMonth();
      date = value.getUTCDate();
    } else {
      year = value.getFullYear();
      month = value.getMonth();
      date = value.getDate();
    }
    if (year < 1900 || year > 2079) {
      throw new TypeError('Out of range.');
    }
    if (year === 2079) {
      // Month is 0-indexed, i.e. Jan = 0, Dec = 11
      // See: https://learn.microsoft.com/en-us/sql/t-sql/data-types/smalldatetime-transact-sql?view=sql-server-ver16
      if (month > 5 || month === 5 && date > 6) {
        throw new TypeError('Out of range.');
      }
    }
    if (isNaN(value)) {
      throw new TypeError('Invalid date.');
    }
    return value;
  }
};
var _default = exports.default = SmallDateTime;
module.exports = SmallDateTime;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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