"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _events = require("events");
var util = _interopRequireWildcard(require("util"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function (e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != typeof e && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (const t in e) "default" !== t && {}.hasOwnProperty.call(e, t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, t)) && (i.get || i.set) ? o(f, t, i) : f[t] = e[t]); return f; })(e, t); }
class Debug extends _events.EventEmitter {
  /*
    @options    Which debug details should be sent.
                data    - dump of packet data
                payload - details of decoded payload
  */
  constructor({
    data = false,
    payload = false,
    packet = false,
    token = false
  } = {}) {
    super();
    this.options = {
      data,
      payload,
      packet,
      token
    };
    this.indent = '  ';
  }
  packet(direction, packet) {
    if (this.haveListeners() && this.options.packet) {
      this.log('');
      this.log(direction);
      this.log(packet.headerToString(this.indent));
    }
  }
  data(packet) {
    if (this.haveListeners() && this.options.data) {
      this.log(packet.dataToString(this.indent));
    }
  }
  payload(generatePayloadText) {
    if (this.haveListeners() && this.options.payload) {
      this.log(generatePayloadText());
    }
  }
  token(token) {
    if (this.haveListeners() && this.options.token) {
      this.log(util.inspect(token, {
        showHidden: false,
        depth: 5,
        colors: true
      }));
    }
  }
  haveListeners() {
    return this.listeners('debug').length > 0;
  }
  log(text) {
    this.emit('debug', text);
  }
}
var _default = exports.default = Debug;
module.exports = Debug;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfZXZlbnRzIiwicmVxdWlyZSIsInV0aWwiLCJfaW50ZXJvcFJlcXVpcmVXaWxkY2FyZCIsImUiLCJ0IiwiV2Vha01hcCIsInIiLCJuIiwiX19lc01vZHVsZSIsIm8iLCJpIiwiZiIsIl9fcHJvdG9fXyIsImRlZmF1bHQiLCJoYXMiLCJnZXQiLCJzZXQiLCJoYXNPd25Qcm9wZXJ0eSIsImNhbGwiLCJPYmplY3QiLCJkZWZpbmVQcm9wZXJ0eSIsImdldE93blByb3BlcnR5RGVzY3JpcHRvciIsIkRlYnVnIiwiRXZlbnRFbWl0dGVyIiwiY29uc3RydWN0b3IiLCJkYXRhIiwicGF5bG9hZCIsInBhY2tldCIsInRva2VuIiwib3B0aW9ucyIsImluZGVudCIsImRpcmVjdGlvbiIsImhhdmVMaXN0ZW5lcnMiLCJsb2ciLCJoZWFkZXJUb1N0cmluZyIsImRhdGFUb1N0cmluZyIsImdlbmVyYXRlUGF5bG9hZFRleHQiLCJpbnNwZWN0Iiwic2hvd0hpZGRlbiIsImRlcHRoIiwiY29sb3JzIiwibGlzdGVuZXJzIiwibGVuZ3RoIiwidGV4dCIsImVtaXQiLCJfZGVmYXVsdCIsImV4cG9ydHMiLCJtb2R1bGUiXSwic291cmNlcyI6WyIuLi9zcmMvZGVidWcudHMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRXZlbnRFbWl0dGVyIH0gZnJvbSAnZXZlbnRzJztcbmltcG9ydCAqIGFzIHV0aWwgZnJvbSAndXRpbCc7XG5pbXBvcnQgeyBQYWNrZXQgfSBmcm9tICcuL3BhY2tldCc7XG5pbXBvcnQgdHlwZSB7IFRva2VuIH0gZnJvbSAnLi90b2tlbi90b2tlbic7XG5cbmNsYXNzIERlYnVnIGV4dGVuZHMgRXZlbnRFbWl0dGVyIHtcbiAgZGVjbGFyZSBvcHRpb25zOiB7XG4gICAgZGF0YTogYm9vbGVhbjtcbiAgICBwYXlsb2FkOiBib29sZWFuO1xuICAgIHBhY2tldDogYm9vbGVhbjtcbiAgICB0b2tlbjogYm9vbGVhbjtcbiAgfTtcblxuICBkZWNsYXJlIGluZGVudDogc3RyaW5nO1xuXG4gIC8qXG4gICAgQG9wdGlvbnMgICAgV2hpY2ggZGVidWcgZGV0YWlscyBzaG91bGQgYmUgc2VudC5cbiAgICAgICAgICAgICAgICBkYXRhICAgIC0gZHVtcCBvZiBwYWNrZXQgZGF0YVxuICAgICAgICAgICAgICAgIHBheWxvYWQgLSBkZXRhaWxzIG9mIGRlY29kZWQgcGF5bG9hZFxuICAqL1xuICBjb25zdHJ1Y3Rvcih7IGRhdGEgPSBmYWxzZSwgcGF5bG9hZCA9IGZhbHNlLCBwYWNrZXQgPSBmYWxzZSwgdG9rZW4gPSBmYWxzZSB9ID0ge30pIHtcbiAgICBzdXBlcigpO1xuXG4gICAgdGhpcy5vcHRpb25zID0geyBkYXRhLCBwYXlsb2FkLCBwYWNrZXQsIHRva2VuIH07XG4gICAgdGhpcy5pbmRlbnQgPSAnICAnO1xuICB9XG5cbiAgcGFja2V0KGRpcmVjdGlvbjogJ1JlY2VpdmVkJyB8ICdTZW50JywgcGFja2V0OiBQYWNrZXQpIHtcbiAgICBpZiAodGhpcy5oYXZlTGlzdGVuZXJzKCkgJiYgdGhpcy5vcHRpb25zLnBhY2tldCkge1xuICAgICAgdGhpcy5sb2coJycpO1xuICAgICAgdGhpcy5sb2coZGlyZWN0aW9uKTtcbiAgICAgIHRoaXMubG9nKHBhY2tldC5oZWFkZXJUb1N0cmluZyh0aGlzLmluZGVudCkpO1xuICAgIH1cbiAgfVxuXG4gIGRhdGEocGFja2V0OiBQYWNrZXQpIHtcbiAgICBpZiAodGhpcy5oYXZlTGlzdGVuZXJzKCkgJiYgdGhpcy5vcHRpb25zLmRhdGEpIHtcbiAgICAgIHRoaXMubG9nKHBhY2tldC5kYXRhVG9TdHJpbmcodGhpcy5pbmRlbnQpKTtcbiAgICB9XG4gIH1cblxuICBwYXlsb2FkKGdlbmVyYXRlUGF5bG9hZFRleHQ6ICgpID0+IHN0cmluZykge1xuICAgIGlmICh0aGlzLmhhdmVMaXN0ZW5lcnMoKSAmJiB0aGlzLm9wdGlvbnMucGF5bG9hZCkge1xuICAgICAgdGhpcy5sb2coZ2VuZXJhdGVQYXlsb2FkVGV4dCgpKTtcbiAgICB9XG4gIH1cblxuICB0b2tlbih0b2tlbjogVG9rZW4pIHtcbiAgICBpZiAodGhpcy5oYXZlTGlzdGVuZXJzKCkgJiYgdGhpcy5vcHRpb25zLnRva2VuKSB7XG4gICAgICB0aGlzLmxvZyh1dGlsLmluc3BlY3QodG9rZW4sIHsgc2hvd0hpZGRlbjogZmFsc2UsIGRlcHRoOiA1LCBjb2xvcnM6IHRydWUgfSkpO1xuICAgIH1cbiAgfVxuXG4gIGhhdmVMaXN0ZW5lcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMubGlzdGVuZXJzKCdkZWJ1ZycpLmxlbmd0aCA+IDA7XG4gIH1cblxuICBsb2codGV4dDogc3RyaW5nKSB7XG4gICAgdGhpcy5lbWl0KCdkZWJ1ZycsIHRleHQpO1xuICB9XG59XG5cbmV4cG9ydCBkZWZhdWx0IERlYnVnO1xubW9kdWxlLmV4cG9ydHMgPSBEZWJ1ZztcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsSUFBQUEsT0FBQSxHQUFBQyxPQUFBO0FBQ0EsSUFBQUMsSUFBQSxHQUFBQyx1QkFBQSxDQUFBRixPQUFBO0FBQTZCLFNBQUFFLHdCQUFBQyxDQUFBLEVBQUFDLENBQUEsNkJBQUFDLE9BQUEsTUFBQUMsQ0FBQSxPQUFBRCxPQUFBLElBQUFFLENBQUEsT0FBQUYsT0FBQSxZQUFBSCx1QkFBQSxZQUFBQSxDQUFBQyxDQUFBLEVBQUFDLENBQUEsU0FBQUEsQ0FBQSxJQUFBRCxDQUFBLElBQUFBLENBQUEsQ0FBQUssVUFBQSxTQUFBTCxDQUFBLE1BQUFNLENBQUEsRUFBQUMsQ0FBQSxFQUFBQyxDQUFBLEtBQUFDLFNBQUEsUUFBQUMsT0FBQSxFQUFBVixDQUFBLGlCQUFBQSxDQUFBLHVCQUFBQSxDQUFBLHlCQUFBQSxDQUFBLFNBQUFRLENBQUEsTUFBQUYsQ0FBQSxHQUFBTCxDQUFBLEdBQUFHLENBQUEsR0FBQUQsQ0FBQSxRQUFBRyxDQUFBLENBQUFLLEdBQUEsQ0FBQVgsQ0FBQSxVQUFBTSxDQUFBLENBQUFNLEdBQUEsQ0FBQVosQ0FBQSxHQUFBTSxDQUFBLENBQUFPLEdBQUEsQ0FBQWIsQ0FBQSxFQUFBUSxDQUFBLGdCQUFBUCxDQUFBLElBQUFELENBQUEsZ0JBQUFDLENBQUEsT0FBQWEsY0FBQSxDQUFBQyxJQUFBLENBQUFmLENBQUEsRUFBQUMsQ0FBQSxPQUFBTSxDQUFBLElBQUFELENBQUEsR0FBQVUsTUFBQSxDQUFBQyxjQUFBLEtBQUFELE1BQUEsQ0FBQUUsd0JBQUEsQ0FBQWxCLENBQUEsRUFBQUMsQ0FBQSxPQUFBTSxDQUFBLENBQUFLLEdBQUEsSUFBQUwsQ0FBQSxDQUFBTSxHQUFBLElBQUFQLENBQUEsQ0FBQUUsQ0FBQSxFQUFBUCxDQUFBLEVBQUFNLENBQUEsSUFBQUMsQ0FBQSxDQUFBUCxDQUFBLElBQUFELENBQUEsQ0FBQUMsQ0FBQSxXQUFBTyxDQUFBLEtBQUFSLENBQUEsRUFBQUMsQ0FBQTtBQUk3QixNQUFNa0IsS0FBSyxTQUFTQyxvQkFBWSxDQUFDO0VBVS9CO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7RUFDRUMsV0FBV0EsQ0FBQztJQUFFQyxJQUFJLEdBQUcsS0FBSztJQUFFQyxPQUFPLEdBQUcsS0FBSztJQUFFQyxNQUFNLEdBQUcsS0FBSztJQUFFQyxLQUFLLEdBQUc7RUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDLEVBQUU7SUFDakYsS0FBSyxDQUFDLENBQUM7SUFFUCxJQUFJLENBQUNDLE9BQU8sR0FBRztNQUFFSixJQUFJO01BQUVDLE9BQU87TUFBRUMsTUFBTTtNQUFFQztJQUFNLENBQUM7SUFDL0MsSUFBSSxDQUFDRSxNQUFNLEdBQUcsSUFBSTtFQUNwQjtFQUVBSCxNQUFNQSxDQUFDSSxTQUE4QixFQUFFSixNQUFjLEVBQUU7SUFDckQsSUFBSSxJQUFJLENBQUNLLGFBQWEsQ0FBQyxDQUFDLElBQUksSUFBSSxDQUFDSCxPQUFPLENBQUNGLE1BQU0sRUFBRTtNQUMvQyxJQUFJLENBQUNNLEdBQUcsQ0FBQyxFQUFFLENBQUM7TUFDWixJQUFJLENBQUNBLEdBQUcsQ0FBQ0YsU0FBUyxDQUFDO01BQ25CLElBQUksQ0FBQ0UsR0FBRyxDQUFDTixNQUFNLENBQUNPLGNBQWMsQ0FBQyxJQUFJLENBQUNKLE1BQU0sQ0FBQyxDQUFDO0lBQzlDO0VBQ0Y7RUFFQUwsSUFBSUEsQ0FBQ0UsTUFBYyxFQUFFO0lBQ25CLElBQUksSUFBSSxDQUFDSyxhQUFhLENBQUMsQ0FBQyxJQUFJLElBQUksQ0FBQ0gsT0FBTyxDQUFDSixJQUFJLEVBQUU7TUFDN0MsSUFBSSxDQUFDUSxHQUFHLENBQUNOLE1BQU0sQ0FBQ1EsWUFBWSxDQUFDLElBQUksQ0FBQ0wsTUFBTSxDQUFDLENBQUM7SUFDNUM7RUFDRjtFQUVBSixPQUFPQSxDQUFDVSxtQkFBaUMsRUFBRTtJQUN6QyxJQUFJLElBQUksQ0FBQ0osYUFBYSxDQUFDLENBQUMsSUFBSSxJQUFJLENBQUNILE9BQU8sQ0FBQ0gsT0FBTyxFQUFFO01BQ2hELElBQUksQ0FBQ08sR0FBRyxDQUFDRyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDakM7RUFDRjtFQUVBUixLQUFLQSxDQUFDQSxLQUFZLEVBQUU7SUFDbEIsSUFBSSxJQUFJLENBQUNJLGFBQWEsQ0FBQyxDQUFDLElBQUksSUFBSSxDQUFDSCxPQUFPLENBQUNELEtBQUssRUFBRTtNQUM5QyxJQUFJLENBQUNLLEdBQUcsQ0FBQ2hDLElBQUksQ0FBQ29DLE9BQU8sQ0FBQ1QsS0FBSyxFQUFFO1FBQUVVLFVBQVUsRUFBRSxLQUFLO1FBQUVDLEtBQUssRUFBRSxDQUFDO1FBQUVDLE1BQU0sRUFBRTtNQUFLLENBQUMsQ0FBQyxDQUFDO0lBQzlFO0VBQ0Y7RUFFQVIsYUFBYUEsQ0FBQSxFQUFHO0lBQ2QsT0FBTyxJQUFJLENBQUNTLFNBQVMsQ0FBQyxPQUFPLENBQUMsQ0FBQ0MsTUFBTSxHQUFHLENBQUM7RUFDM0M7RUFFQVQsR0FBR0EsQ0FBQ1UsSUFBWSxFQUFFO0lBQ2hCLElBQUksQ0FBQ0MsSUFBSSxDQUFDLE9BQU8sRUFBRUQsSUFBSSxDQUFDO0VBQzFCO0FBQ0Y7QUFBQyxJQUFBRSxRQUFBLEdBQUFDLE9BQUEsQ0FBQWpDLE9BQUEsR0FFY1MsS0FBSztBQUNwQnlCLE1BQU0sQ0FBQ0QsT0FBTyxHQUFHeEIsS0FBSyIsImlnbm9yZUxpc3QiOltdfQ==