"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _token = require("./token");
var iconv = _interopRequireWildcard(require("iconv-lite"));
var _valueParser = require("../value-parser");
var _helpers = require("./helpers");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function (e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != typeof e && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (const t in e) "default" !== t && {}.hasOwnProperty.call(e, t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, t)) && (i.get || i.set) ? o(f, t, i) : f[t] = e[t]); return f; })(e, t); }
// s2.2.7.17

async function rowParser(parser) {
  const columns = [];
  for (const metadata of parser.colMetadata) {
    while (true) {
      if ((0, _valueParser.isPLPStream)(metadata)) {
        const chunks = await (0, _valueParser.readPLPStream)(parser);
        if (chunks === null) {
          columns.push({
            value: chunks,
            metadata
          });
        } else if (metadata.type.name === 'NVarChar' || metadata.type.name === 'Xml') {
          columns.push({
            value: Buffer.concat(chunks).toString('ucs2'),
            metadata
          });
        } else if (metadata.type.name === 'VarChar') {
          columns.push({
            value: iconv.decode(Buffer.concat(chunks), metadata.collation?.codepage ?? 'utf8'),
            metadata
          });
        } else if (metadata.type.name === 'VarBinary' || metadata.type.name === 'UDT') {
          columns.push({
            value: Buffer.concat(chunks),
            metadata
          });
        }
      } else {
        let result;
        try {
          result = (0, _valueParser.readValue)(parser.buffer, parser.position, metadata, parser.options);
        } catch (err) {
          if (err instanceof _helpers.NotEnoughDataError) {
            await parser.waitForChunk();
            continue;
          }
          throw err;
        }
        parser.position = result.offset;
        columns.push({
          value: result.value,
          metadata
        });
      }
      break;
    }
  }
  if (parser.options.useColumnNames) {
    const columnsMap = Object.create(null);
    columns.forEach(column => {
      const colName = column.metadata.colName;
      if (columnsMap[colName] == null) {
        columnsMap[colName] = column;
      }
    });
    return new _token.RowToken(columnsMap);
  } else {
    return new _token.RowToken(columns);
  }
}
var _default = exports.default = rowParser;
module.exports = rowParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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