if(NOT EMSCRIPTEN)
  vcpkg_check_linkage(ONLY_DYNAMIC_LIBRARY)
else()
  vcpkg_check_linkage(ONLY_STATIC_LIBRARY)
endif()
vcpkg_from_github(
  OUT_SOURCE_PATH SOURCE_PATH
  REPO ethindp/prism
  REF v0.7.0
  SHA512 4ba9e71f5e27df9dc9d242b78e80155ecf3734b1027abe750bd8ed3385b4a5b202f35583ff0e6a711a22601a1136f866337337ba4b0037098f0e2a45786806fd
  HEAD_REF master
)
vcpkg_check_features(
  OUT_FEATURE_OPTIONS FEATURE_OPTIONS
  FEATURES
    orca PRISM_VCPKG_WANTS_ORCA_BACKEND
    speech-dispatcher PRISM_VCPKG_WANTS_SPEECH_DISPATCHER_BACKEND
)
vcpkg_cmake_configure(
  SOURCE_PATH "${SOURCE_PATH}"
  OPTIONS
    -DPRISM_ENABLE_TESTS=OFF
    -DPRISM_ENABLE_DEMOS=OFF
    -DPRISM_ENABLE_CLANG_TIDY=OFF
    -DPRISM_ENABLE_VCPKG_SPECIFIC_OPTIONS=ON
    ${FEATURE_OPTIONS}
)
vcpkg_cmake_install()
vcpkg_cmake_config_fixup(PACKAGE_NAME prism CONFIG_PATH share/prism)
file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/share")
file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/include")
vcpkg_copy_pdbs()
vcpkg_install_copyright(FILE_LIST "${SOURCE_PATH}/LICENSE")
