# Contributing to SwiftNet

Thank you for your interest in contributing to SwiftNet! This guide explains the recommended workflow so your contributions can be reviewed and merged smoothly.

## How to Contribute

1. **Fork the repository.**

2. **Clone your fork:**
   ```bash
   git clone https://github.com/<your-username>/SwiftNet.git
   cd SwiftNet
   ```

3. **Create a feature branch:**
   ```bash
   git checkout -b feature/your-feature-name
   ```

4. **Make your changes and commit them:**
   ```bash
   git add .
   git commit -m "Describe your change clearly"
   ```

5. **Open a Pull Request as a *draft*.**  
   Draft PRs allow CI to run and give you time to refine your work before requesting a formal review.

6. **Mark the Pull Request as “Ready for Review” when:**
   - all tests pass  
   - the code builds successfully  
   - the changes are complete  
   - documentation is updated if needed  

## Guidelines

- Keep PRs focused on a single feature or fix.
- Write clear commit messages.
- Follow the coding style already present in the project.
- Add or update tests when relevant.

## Questions?

If you’re unsure about anything, feel free to message me on telegram, open an issue or start a discussion before working on a feature.

## 🌟 Contributor Hall of Fame

Everyone who has contributed code, documentation, or fixes to SwiftNet 
is listed here as a thank-you.
- sandy191020
- gab-dev-7
