/* Generated by wayland-scanner 1.24.0 */

#ifndef WAYFIRE_SHELL_UNSTABLE_V2_SERVER_PROTOCOL_H
#define WAYFIRE_SHELL_UNSTABLE_V2_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_wayfire_shell_unstable_v2 The wayfire_shell_unstable_v2 protocol
 * @section page_ifaces_wayfire_shell_unstable_v2 Interfaces
 * - @subpage page_iface_zwf_shell_manager_v2 - DE integration
 * - @subpage page_iface_zwf_output_v2 - A wrapper for wl_output
 * - @subpage page_iface_zwf_hotspot_v2 - An edge of the output defined by 1 or 2 edges
 * - @subpage page_iface_zwf_surface_v2 - A special surface
 */
struct wl_output;
struct wl_surface;
struct zwf_hotspot_v2;
struct zwf_output_v2;
struct zwf_shell_manager_v2;
struct zwf_surface_v2;

#ifndef ZWF_SHELL_MANAGER_V2_INTERFACE
#define ZWF_SHELL_MANAGER_V2_INTERFACE
/**
 * @page page_iface_zwf_shell_manager_v2 zwf_shell_manager_v2
 * @section page_iface_zwf_shell_manager_v2_desc Description
 *
 * This protocol provides additional events and requests for special DE
 * clients like panels, docks, etc.
 *
 * It is meant as an addition for protocols like wlr-layer-shell.
 * @section page_iface_zwf_shell_manager_v2_api API
 * See @ref iface_zwf_shell_manager_v2.
 */
/**
 * @defgroup iface_zwf_shell_manager_v2 The zwf_shell_manager_v2 interface
 *
 * This protocol provides additional events and requests for special DE
 * clients like panels, docks, etc.
 *
 * It is meant as an addition for protocols like wlr-layer-shell.
 */
extern const struct wl_interface zwf_shell_manager_v2_interface;
#endif
#ifndef ZWF_OUTPUT_V2_INTERFACE
#define ZWF_OUTPUT_V2_INTERFACE
/**
 * @page page_iface_zwf_output_v2 zwf_output_v2
 * @section page_iface_zwf_output_v2_desc Description
 *
 * Represents a single output.
 * Each output is managed independently from the others.
 * @section page_iface_zwf_output_v2_api API
 * See @ref iface_zwf_output_v2.
 */
/**
 * @defgroup iface_zwf_output_v2 The zwf_output_v2 interface
 *
 * Represents a single output.
 * Each output is managed independently from the others.
 */
extern const struct wl_interface zwf_output_v2_interface;
#endif
#ifndef ZWF_HOTSPOT_V2_INTERFACE
#define ZWF_HOTSPOT_V2_INTERFACE
/**
 * @page page_iface_zwf_hotspot_v2 zwf_hotspot_v2
 * @section page_iface_zwf_hotspot_v2_desc Description
 * @section page_iface_zwf_hotspot_v2_api API
 * See @ref iface_zwf_hotspot_v2.
 */
/**
 * @defgroup iface_zwf_hotspot_v2 The zwf_hotspot_v2 interface
 */
extern const struct wl_interface zwf_hotspot_v2_interface;
#endif
#ifndef ZWF_SURFACE_V2_INTERFACE
#define ZWF_SURFACE_V2_INTERFACE
/**
 * @page page_iface_zwf_surface_v2 zwf_surface_v2
 * @section page_iface_zwf_surface_v2_desc Description
 * @section page_iface_zwf_surface_v2_api API
 * See @ref iface_zwf_surface_v2.
 */
/**
 * @defgroup iface_zwf_surface_v2 The zwf_surface_v2 interface
 */
extern const struct wl_interface zwf_surface_v2_interface;
#endif

/**
 * @ingroup iface_zwf_shell_manager_v2
 * @struct zwf_shell_manager_v2_interface
 */
struct zwf_shell_manager_v2_interface {
	/**
	 * Create a zwf_output_v2 for the given wl_output
	 *
	 * 
	 */
	void (*get_wf_output)(struct wl_client *client,
			      struct wl_resource *resource,
			      struct wl_resource *output,
			      uint32_t id);
	/**
	 * Create a zwf_surface_v2 for the given wl_surface
	 *
	 * 
	 */
	void (*get_wf_surface)(struct wl_client *client,
			       struct wl_resource *resource,
			       struct wl_resource *surface,
			       uint32_t id);
};


/**
 * @ingroup iface_zwf_shell_manager_v2
 */
#define ZWF_SHELL_MANAGER_V2_GET_WF_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_zwf_shell_manager_v2
 */
#define ZWF_SHELL_MANAGER_V2_GET_WF_SURFACE_SINCE_VERSION 1

#ifndef ZWF_OUTPUT_V2_HOTSPOT_EDGE_ENUM
#define ZWF_OUTPUT_V2_HOTSPOT_EDGE_ENUM
enum zwf_output_v2_hotspot_edge {
	ZWF_OUTPUT_V2_HOTSPOT_EDGE_TOP = 1,
	ZWF_OUTPUT_V2_HOTSPOT_EDGE_BOTTOM = 2,
	ZWF_OUTPUT_V2_HOTSPOT_EDGE_LEFT = 4,
	ZWF_OUTPUT_V2_HOTSPOT_EDGE_RIGHT = 8,
};
#endif /* ZWF_OUTPUT_V2_HOTSPOT_EDGE_ENUM */

#ifndef ZWF_OUTPUT_V2_HOTSPOT_EDGE_ENUM_IS_VALID
#define ZWF_OUTPUT_V2_HOTSPOT_EDGE_ENUM_IS_VALID
/**
 * @ingroup iface_zwf_output_v2
 * Validate a zwf_output_v2 hotspot_edge value.
 *
 * @return true on success, false on error.
 * @ref zwf_output_v2_hotspot_edge
 */
static inline bool
zwf_output_v2_hotspot_edge_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWF_OUTPUT_V2_HOTSPOT_EDGE_TOP:
		return version >= 1;
	case ZWF_OUTPUT_V2_HOTSPOT_EDGE_BOTTOM:
		return version >= 1;
	case ZWF_OUTPUT_V2_HOTSPOT_EDGE_LEFT:
		return version >= 1;
	case ZWF_OUTPUT_V2_HOTSPOT_EDGE_RIGHT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZWF_OUTPUT_V2_HOTSPOT_EDGE_ENUM_IS_VALID */

/**
 * @ingroup iface_zwf_output_v2
 * @struct zwf_output_v2_interface
 */
struct zwf_output_v2_interface {
	/**
	 * Don't render the output
	 *
	 * Request the compositor to not render the output, so the output
	 * usually is cleared to black color. To enable output rendering
	 * again, call inhibit_output_done.
	 */
	void (*inhibit_output)(struct wl_client *client,
			       struct wl_resource *resource);
	/**
	 * Render the output
	 *
	 * Stop inhibiting the output. This must be called as many times
	 * as inhibit_output was called to actually uninhibit rendering.
	 *
	 * The inhibit/inhibit_done requests can be called multiple times,
	 * even from different apps, so don't assume that a call to
	 * inhibit_done would always mean actually starting the rendering
	 * process.
	 */
	void (*inhibit_output_done)(struct wl_client *client,
				    struct wl_resource *resource);
	/**
	 * Create a hotspot on the output
	 *
	 * A hotspot on the output is an edge or a corner region of the
	 * output where the mouse or touch point has been residing for a
	 * given amount of time.
	 *
	 * The hotspot can be used for example for autohiding panels, where
	 * the panel is shown when the input hovers on the edge of the
	 * output for a specific amount of time.
	 * @param hotspot bitwise or of the edges the output
	 * @param threshold distance from the edge of the output
	 * @param timeout minimum time for the mouse to be in the hotspot
	 */
	void (*create_hotspot)(struct wl_client *client,
			       struct wl_resource *resource,
			       uint32_t hotspot,
			       uint32_t threshold,
			       uint32_t timeout,
			       uint32_t id);
};

#define ZWF_OUTPUT_V2_ENTER_FULLSCREEN 0
#define ZWF_OUTPUT_V2_LEAVE_FULLSCREEN 1
#define ZWF_OUTPUT_V2_TOGGLE_MENU 2

/**
 * @ingroup iface_zwf_output_v2
 */
#define ZWF_OUTPUT_V2_ENTER_FULLSCREEN_SINCE_VERSION 1
/**
 * @ingroup iface_zwf_output_v2
 */
#define ZWF_OUTPUT_V2_LEAVE_FULLSCREEN_SINCE_VERSION 1
/**
 * @ingroup iface_zwf_output_v2
 */
#define ZWF_OUTPUT_V2_TOGGLE_MENU_SINCE_VERSION 2

/**
 * @ingroup iface_zwf_output_v2
 */
#define ZWF_OUTPUT_V2_INHIBIT_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_zwf_output_v2
 */
#define ZWF_OUTPUT_V2_INHIBIT_OUTPUT_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwf_output_v2
 */
#define ZWF_OUTPUT_V2_CREATE_HOTSPOT_SINCE_VERSION 1

/**
 * @ingroup iface_zwf_output_v2
 * Sends an enter_fullscreen event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwf_output_v2_send_enter_fullscreen(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWF_OUTPUT_V2_ENTER_FULLSCREEN);
}

/**
 * @ingroup iface_zwf_output_v2
 * Sends an leave_fullscreen event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwf_output_v2_send_leave_fullscreen(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWF_OUTPUT_V2_LEAVE_FULLSCREEN);
}

/**
 * @ingroup iface_zwf_output_v2
 * Sends an toggle_menu event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwf_output_v2_send_toggle_menu(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWF_OUTPUT_V2_TOGGLE_MENU);
}

#define ZWF_HOTSPOT_V2_ENTER 0
#define ZWF_HOTSPOT_V2_LEAVE 1

/**
 * @ingroup iface_zwf_hotspot_v2
 */
#define ZWF_HOTSPOT_V2_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_zwf_hotspot_v2
 */
#define ZWF_HOTSPOT_V2_LEAVE_SINCE_VERSION 1


/**
 * @ingroup iface_zwf_hotspot_v2
 * Sends an enter event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwf_hotspot_v2_send_enter(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWF_HOTSPOT_V2_ENTER);
}

/**
 * @ingroup iface_zwf_hotspot_v2
 * Sends an leave event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwf_hotspot_v2_send_leave(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWF_HOTSPOT_V2_LEAVE);
}

/**
 * @ingroup iface_zwf_surface_v2
 * @struct zwf_surface_v2_interface
 */
struct zwf_surface_v2_interface {
	/**
	 * Start an interactive move of the surface
	 *
	 * 
	 */
	void (*interactive_move)(struct wl_client *client,
				 struct wl_resource *resource);
};


/**
 * @ingroup iface_zwf_surface_v2
 */
#define ZWF_SURFACE_V2_INTERACTIVE_MOVE_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
