#ifndef VERILOG_LEXER_H
#define VERILOG_LEXER_H

#include "kernel/yosys.h"
#include "frontends/ast/ast.h"
#include "frontends/verilog/verilog_parser.tab.hh"
#include <string>
#include <memory>

#if ! defined(yyFlexLexerOnce)
#define yyFlexLexer frontend_verilog_yyFlexLexer
#include <FlexLexer.h>
#endif

YOSYS_NAMESPACE_BEGIN

namespace VERILOG_FRONTEND {
	using parser = frontend_verilog_yy::parser;
	class VerilogLexer : public frontend_verilog_yyFlexLexer {
		ParseState* extra;
		ParseMode* mode;
		parser::location_type out_loc;
	public:
		VerilogLexer(ParseState* e, ParseMode* m, std::shared_ptr<string> filename) : frontend_verilog_yyFlexLexer(e->lexin), extra(e), mode(m) {
			out_loc.begin.filename = filename;
		}
		~VerilogLexer() override {}
		// autogenerated body due to YY_DECL
		parser::symbol_type nextToken();
		// get rid of override virtual function warning
		using FlexLexer::yylex;
		parser::symbol_type terminate() {
			return parser::make_FRONTEND_VERILOG_YYEOF(out_loc);
		}
	private:
		std::shared_ptr<std::string> current_filename;
		std::vector<std::shared_ptr<std::string>> fn_stack;
		std::vector<int> ln_stack;
		int LexerInput(char* buf, int max_size) override {
			return readsome(*extra->lexin, buf, max_size);
		}
	};

};

YOSYS_NAMESPACE_END

#endif
