/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.expression.ConstantValue;
import java.util.Map;
import java.util.Set;

public class ConstantValueSolver
extends AbstractExpressionSolver<ConstantValue> {
    public ConstantValueSolver() {
        super(ConstantValue.class);
    }

    @Override
    public AssemblyResolution solve(AbstractAssemblyResolutionFactory<?, ?> factory, ConstantValue cv, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) {
        MaskedLong value = this.getValue(cv, vals, cur);
        return ConstantValueSolver.checkConstAgrees(factory, value, goal, description);
    }

    @Override
    public MaskedLong getValue(ConstantValue cv, Map<String, Long> vals, AssemblyResolvedPatterns cur) {
        return MaskedLong.fromLong(cv.getValue());
    }

    @Override
    public int getInstructionLength(ConstantValue cv) {
        return 0;
    }

    @Override
    public MaskedLong valueForResolution(ConstantValue cv, Map<String, Long> vals, AssemblyResolvedPatterns rc) {
        return MaskedLong.fromLong(cv.getValue());
    }

    static AssemblyResolution checkConstAgrees(AbstractAssemblyResolutionFactory<?, ?> factory, MaskedLong value, MaskedLong goal, String description) {
        if (!value.agrees(goal)) {
            return ((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)factory.newErrorBuilder().error("Constant value " + String.valueOf(value) + " does not agree with child requirements").description(description)).build();
        }
        return factory.nop(description);
    }
}

