/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

abstract class VariableImpl
implements Variable {
    private String name;
    private DataType dataType;
    private String comment;
    private SourceType sourceType;
    private VariableStorage variableStorage;
    private Program program;

    protected VariableImpl(String name, DataType dataType, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, dataType, null, null, null, null, false, program, sourceType);
    }

    public VariableImpl(String name, DataType dataType, int stackOffset, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, dataType, null, null, stackOffset, null, false, program, sourceType);
    }

    protected VariableImpl(String name, DataType dataType, Address storageAddr, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, dataType, null, storageAddr, null, null, false, program, sourceType);
    }

    protected VariableImpl(String name, DataType dataType, Register register, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, dataType, null, null, null, register, false, program, sourceType);
    }

    protected VariableImpl(String name, DataType dataType, VariableStorage storage, boolean force, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, dataType, storage, null, null, null, force, program, sourceType);
    }

    VariableImpl(String name, DataType dataType, VariableStorage storage, Address storageAddr, Integer stackOffset, Register register, boolean force, Program program, SourceType sourceType) throws InvalidInputException {
        VariableImpl.checkUsage(storage, storageAddr, stackOffset, register);
        VariableImpl.checkProgram(program);
        this.program = program;
        this.name = name;
        if (storage == null) {
            if (register != null) {
                this.dataType = VariableUtilities.checkDataType(dataType, false, register.getMinimumByteSize(), program);
                int size = this.dataType.getLength();
                storageAddr = register.getAddress();
                int regSize = register.getMinimumByteSize();
                if (regSize < size) {
                    if (!force) {
                        throw new InvalidInputException("Register '" + register.getName() + "' size too small for specified data type size: " + dataType.getLength());
                    }
                    this.variableStorage = new VariableStorage((ProgramArchitecture)program, register);
                    return;
                }
                if (register.isBigEndian() && regSize > size) {
                    storageAddr = storageAddr.add(regSize - size);
                }
            } else {
                if (stackOffset != null) {
                    storageAddr = program.getAddressFactory().getStackSpace().getAddress(stackOffset.intValue());
                }
                this.dataType = VariableUtilities.checkDataType(dataType, storageAddr == null && this.isVoidAllowed(), 1, program);
            }
            this.variableStorage = this.computeStorage(storageAddr);
        } else {
            this.dataType = VariableUtilities.checkDataType(dataType, (storage.isVoidStorage() || storage.isUnassignedStorage()) && this.isVoidAllowed(), storage.size(), program);
            VariableUtilities.checkStorage(storage, this.dataType, force);
            this.variableStorage = storage;
        }
        this.sourceType = this.hasDefaultName() ? SourceType.DEFAULT : sourceType;
    }

    protected boolean hasDefaultName() {
        return false;
    }

    private static void checkUsage(VariableStorage storage, Address storageAddr, Integer stackOffset, Register register) {
        boolean invalidUsage = false;
        if (storage != null) {
            invalidUsage = storageAddr != null || stackOffset != null || register != null;
        } else if (register != null) {
            invalidUsage = storageAddr != null || stackOffset != null;
        } else if (stackOffset != null) {
            boolean bl = invalidUsage = storageAddr != null;
        }
        if (invalidUsage) {
            throw new IllegalArgumentException("only one storage location may be specified");
        }
    }

    private static void checkProgram(Program program) {
        if (program == null || program.isClosed()) {
            throw new IllegalArgumentException("An open program object which corresponds to the specified storage is required");
        }
    }

    private VariableStorage computeStorage(Address storageAddr) throws InvalidInputException {
        if (storageAddr == null) {
            return VariableStorage.UNASSIGNED_STORAGE;
        }
        if (!(storageAddr.isMemoryAddress() || storageAddr.isRegisterAddress() || storageAddr.isStackAddress() || storageAddr.isHashAddress())) {
            throw new InvalidInputException("Invalid storage address specified: space=" + storageAddr.getAddressSpace().getName());
        }
        int dtLength = this.dataType.getLength();
        if (!storageAddr.isStackAddress()) {
            return new VariableStorage((ProgramArchitecture)this.program, storageAddr, dtLength);
        }
        long stackOffset = storageAddr.getOffset();
        if (stackOffset < 0L && -stackOffset < (long)dtLength) {
            throw new InvalidInputException("Data type does not fit within stack frame constraints (stack offset=" + stackOffset + ", size=" + dtLength);
        }
        return new VariableStorage((ProgramArchitecture)this.program, new Varnode(storageAddr, dtLength));
    }

    protected boolean isVoidAllowed() {
        return false;
    }

    @Override
    public final boolean isValid() {
        if (VoidDataType.isVoidDataType(this.dataType)) {
            return this.isVoidAllowed() && this.variableStorage.isVoidStorage();
        }
        if (this.dataType.getLength() <= 0 || !this.variableStorage.isValid()) {
            return false;
        }
        return this.variableStorage.size() >= this.dataType.getLength();
    }

    @Override
    public final String getComment() {
        return this.comment;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(DataType type, VariableStorage storage, boolean force, SourceType source) throws InvalidInputException {
        type = VariableUtilities.checkDataType(type, (storage.isVoidStorage() || storage.isUnassignedStorage()) && this.isVoidAllowed(), storage.size(), this.program);
        VariableUtilities.checkStorage(storage, type, force);
        this.dataType = type;
        this.variableStorage = storage;
    }

    @Override
    public final void setDataType(DataType type, boolean align, boolean force, SourceType source) throws InvalidInputException {
        this.setDataType(type, SourceType.ANALYSIS);
    }

    @Override
    public void setDataType(DataType type, SourceType source) throws InvalidInputException {
        this.variableStorage = VoidDataType.isVoidDataType(type = VariableUtilities.checkDataType(type, this.isVoidAllowed(), this.dataType.getLength(), this.program)) ? VariableStorage.VOID_STORAGE : this.resizeStorage(this.variableStorage, type);
        this.dataType = type;
    }

    @Override
    public Function getFunction() {
        return null;
    }

    @Override
    public final Program getProgram() {
        return this.program;
    }

    @Override
    public final int getLength() {
        return this.dataType.getLength();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final SourceType getSource() {
        return this.sourceType != null ? this.sourceType : SourceType.USER_DEFINED;
    }

    @Override
    public final Symbol getSymbol() {
        return null;
    }

    @Override
    public void setComment(String comment) {
        if (comment != null && comment.endsWith("\n")) {
            comment = comment.substring(0, comment.length() - 1);
        }
        this.comment = comment;
    }

    @Override
    public void setName(String name, SourceType source) throws InvalidInputException {
        this.name = name;
        this.sourceType = this.hasDefaultName() ? SourceType.DEFAULT : source;
    }

    @Override
    public final boolean hasAssignedStorage() {
        return this.variableStorage != null;
    }

    @Override
    public final VariableStorage getVariableStorage() {
        return this.variableStorage;
    }

    @Override
    public final Varnode getFirstStorageVarnode() {
        if (this.variableStorage != null) {
            return this.variableStorage.getFirstVarnode();
        }
        return null;
    }

    @Override
    public final Varnode getLastStorageVarnode() {
        if (this.variableStorage != null) {
            return this.variableStorage.getLastVarnode();
        }
        return null;
    }

    @Override
    public final boolean isStackVariable() {
        if (this.variableStorage != null) {
            return this.variableStorage.isStackStorage();
        }
        return false;
    }

    @Override
    public final boolean hasStackStorage() {
        if (this.variableStorage != null) {
            return this.variableStorage.hasStackStorage();
        }
        return false;
    }

    @Override
    public final boolean isRegisterVariable() {
        if (this.variableStorage != null) {
            return this.variableStorage.isRegisterStorage();
        }
        return false;
    }

    @Override
    public final Register getRegister() {
        if (this.variableStorage != null) {
            return this.variableStorage.getRegister();
        }
        return null;
    }

    @Override
    public final List<Register> getRegisters() {
        if (this.variableStorage != null) {
            return this.variableStorage.getRegisters();
        }
        return null;
    }

    @Override
    public final Address getMinAddress() {
        if (this.variableStorage != null) {
            return this.variableStorage.getMinAddress();
        }
        return null;
    }

    @Override
    public final int getStackOffset() {
        if (this.variableStorage != null) {
            return this.variableStorage.getStackOffset();
        }
        throw new UnsupportedOperationException("Variable is not a stack variable");
    }

    @Override
    public final boolean isMemoryVariable() {
        if (this.variableStorage != null) {
            return this.variableStorage.isMemoryStorage();
        }
        return false;
    }

    @Override
    public final boolean isUniqueVariable() {
        if (this.variableStorage != null) {
            return this.variableStorage.isHashStorage();
        }
        return false;
    }

    @Override
    public final boolean isCompoundVariable() {
        return this.variableStorage != null && this.variableStorage.isCompoundStorage();
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[");
        strBuilder.append(this.dataType.getName());
        strBuilder.append(" ");
        strBuilder.append(this.getName());
        strBuilder.append("@");
        strBuilder.append(this.variableStorage.toString());
        strBuilder.append("]");
        return strBuilder.toString();
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable otherVar = (Variable)obj;
        if (!this.isEquivalent(otherVar)) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.name, (CharSequence)otherVar.getName())) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.comment, (CharSequence)otherVar.getComment());
    }

    public int hashCode() {
        int hashcode = this.getFirstUseOffset();
        return hashcode ^= this.variableStorage.hashCode();
    }

    @Override
    public final int compareTo(Variable otherVar) {
        return VariableUtilities.compare(this, otherVar);
    }

    @Override
    public final boolean isEquivalent(Variable otherVar) {
        if (otherVar == null) {
            return false;
        }
        if (otherVar == this) {
            return true;
        }
        if (otherVar instanceof Parameter != this instanceof Parameter) {
            return false;
        }
        if (this instanceof Parameter && ((Parameter)((Object)this)).getOrdinal() != ((Parameter)otherVar).getOrdinal()) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.variableStorage, (Object)otherVar.getVariableStorage())) {
            return false;
        }
        if (this.getFirstUseOffset() != otherVar.getFirstUseOffset()) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(this.getDataType(), otherVar.getDataType());
    }

    private VariableStorage resizeStorage(VariableStorage curStorage, DataType type) throws InvalidInputException {
        int newSize = type.getLength();
        int curSize = curStorage.size();
        if (curSize == newSize) {
            return curStorage;
        }
        if (curSize == 0 || curStorage.isUniqueStorage() || curStorage.isHashStorage()) {
            throw new InvalidInputException("Current storage can't be resized: " + curStorage.toString());
        }
        if (newSize > curSize) {
            return this.expandStorage(curStorage, newSize, type);
        }
        return this.shrinkStorage(curStorage, newSize, type);
    }

    private VariableStorage shrinkStorage(VariableStorage curStorage, int newSize, DataType type) throws InvalidInputException {
        ArrayList<Varnode> newList = new ArrayList<Varnode>();
        int size = 0;
        for (Varnode vn : curStorage.getVarnodes()) {
            if ((size += vn.getSize()) >= newSize) {
                newList.add(this.shrinkVarnode(vn, size - newSize, curStorage, newSize, type));
                break;
            }
            newList.add(vn);
        }
        return new VariableStorage((ProgramArchitecture)this.program, newList);
    }

    private VariableStorage expandStorage(VariableStorage curStorage, int newSize, DataType type) throws InvalidInputException {
        ArrayList<Varnode> newList = new ArrayList<Varnode>();
        Varnode[] varnodes = curStorage.getVarnodes();
        int lastIndex = varnodes.length - 1;
        varnodes[lastIndex] = this.expandVarnode(varnodes[lastIndex], newSize - curStorage.size(), curStorage, newSize, type);
        return new VariableStorage((ProgramArchitecture)this.program, newList);
    }

    private Varnode shrinkVarnode(Varnode varnode, int sizeReduction, VariableStorage curStorage, int newSize, DataType type) throws InvalidInputException {
        boolean complexDt;
        Address addr = varnode.getAddress();
        if (addr.isStackAddress()) {
            return this.resizeStackVarnode(varnode, varnode.getSize() - sizeReduction, curStorage, newSize, type);
        }
        boolean isRegister = this.program.getRegister(varnode) != null;
        boolean bigEndian = this.program.getMemory().isBigEndian();
        boolean bl = complexDt = type instanceof Composite || type instanceof Array;
        if (bigEndian && (isRegister || !complexDt)) {
            return new Varnode(varnode.getAddress().add(sizeReduction), varnode.getSize() - sizeReduction);
        }
        return new Varnode(varnode.getAddress(), varnode.getSize() - sizeReduction);
    }

    private Varnode expandVarnode(Varnode varnode, int sizeIncrease, VariableStorage curStorage, int newSize, DataType type) throws InvalidInputException {
        boolean complexDt;
        Address addr = varnode.getAddress();
        if (addr.isStackAddress()) {
            return this.resizeStackVarnode(varnode, varnode.getSize() + sizeIncrease, curStorage, newSize, type);
        }
        int size = varnode.getSize() + sizeIncrease;
        boolean bigEndian = this.program.getMemory().isBigEndian();
        Register reg = this.program.getRegister(varnode);
        Address vnAddr = varnode.getAddress();
        if (reg != null) {
            Register newReg = reg;
            while (newReg.getMinimumByteSize() < size) {
                if ((newReg = newReg.getParentRegister()) != null) continue;
                throw new InvalidInputException("Current storage can't be expanded to " + newSize + " bytes: " + curStorage.toString());
            }
            if (bigEndian) {
                vnAddr = vnAddr.add(newReg.getMinimumByteSize() - size);
                return new Varnode(vnAddr, size);
            }
        }
        boolean bl = complexDt = type instanceof Composite || type instanceof Array;
        if (bigEndian && !complexDt) {
            return new Varnode(vnAddr.subtract(sizeIncrease), size);
        }
        return new Varnode(vnAddr, size);
    }

    private Varnode resizeStackVarnode(Varnode varnode, int newVarnodeSize, VariableStorage curStorage, int newSize, DataType type) throws InvalidInputException {
        int stackOffset;
        Address curAddr = varnode.getAddress();
        int newStackOffset = stackOffset = (int)curAddr.getOffset();
        int newEndStackOffset = newStackOffset + newVarnodeSize - 1;
        if (newStackOffset < 0 && newEndStackOffset >= 0) {
            throw new InvalidInputException("Data type does not fit within variable stack constraints");
        }
        return new Varnode(curAddr.getNewAddress(newStackOffset), newVarnodeSize);
    }
}

