/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumulatorTree<V, E> {
    private static final Logger log = LoggerFactory.getLogger(AccumulatorTree.class);
    List<LE<V, E>> edges;
    int firstIndex = 1;
    int treeSize;
    int[] tree;
    int base;
    int last;

    public AccumulatorTree(int size) {
        while (this.firstIndex < size) {
            this.firstIndex *= 2;
        }
        this.treeSize = 2 * this.firstIndex - 1;
        --this.firstIndex;
        this.base = size - 1;
        this.last = size - 1;
        this.tree = new int[this.treeSize];
    }

    public int countEdges(int n, int last) {
        if (n > last) {
            log.error("position exceeds array size");
        }
        if (n == last) {
            return 0;
        }
        int pos = n + this.base;
        int sum = 0;
        while (pos > 0) {
            if (this.isEven(pos)) {
                sum += this.tree[pos - 1];
            }
            pos = this.parentIndex(pos);
        }
        return this.tree[0] - sum;
    }

    public int crossCount(int[] southSequence) {
        int r = southSequence.length;
        int crossCount = 0;
        for (int k = 0; k < r; ++k) {
            int index;
            int n = index = southSequence[k] + this.firstIndex;
            this.tree[n] = this.tree[n] + 1;
            while (index > 0) {
                if (index % 2 != 0) {
                    crossCount += this.tree[index + 1];
                }
                int n2 = index = (index - 1) / 2;
                this.tree[n2] = this.tree[n2] + 1;
                if (!log.isTraceEnabled()) continue;
                log.trace("incremented {} in  tree:{}", (Object)index, (Object)this.toString());
            }
        }
        return crossCount;
    }

    public int crossWeight(int[] southSequence, Function<Integer, Integer> weight) {
        int r = southSequence.length;
        int crossWeight = 0;
        for (int k = 0; k < r; ++k) {
            int index = southSequence[k] + this.firstIndex;
            if (log.isTraceEnabled()) {
                log.trace("got a weight value of {}", (Object)weight.apply(k));
            }
            int n = index;
            this.tree[n] = this.tree[n] + weight.apply(k);
            int weightSum = 0;
            while (index > 0) {
                if (index % 2 != 0) {
                    weightSum += this.tree[index + 1];
                }
                int n2 = index = (index - 1) / 2;
                this.tree[n2] = this.tree[n2] + weight.apply(k);
            }
            crossWeight += weight.apply(k) * weightSum;
        }
        return crossWeight;
    }

    public int crossWeight(LE<V, E>[] edgeArray, Function<Integer, Integer> weight) {
        int r = edgeArray.length;
        int crossWeight = 0;
        for (int k = 0; k < r; ++k) {
            LE<V, E> edge = edgeArray[k];
            int index = edge.getTarget().getIndex() + this.firstIndex;
            if (log.isTraceEnabled()) {
                log.trace("got a weight value of {}", (Object)weight.apply(k));
            }
            int n = index;
            this.tree[n] = this.tree[n] + weight.apply(k);
            int weightSum = 0;
            while (index > 0) {
                if (index % 2 != 0) {
                    weightSum += this.tree[index + 1];
                }
                int n2 = index = (index - 1) / 2;
                this.tree[n2] = this.tree[n2] + weight.apply(k);
            }
            crossWeight += weight.apply(k) * weightSum;
        }
        return crossWeight;
    }

    public int getBase() {
        return this.base;
    }

    private boolean isEven(int n) {
        return n % 2 == 0;
    }

    private boolean isOdd(int n) {
        return !this.isEven(n);
    }

    int parentIndex(int childIndex) {
        return (childIndex - 1) / 2;
    }

    public void addEdge(int pos) {
        pos += this.base;
        while (pos > 0) {
            int n = pos;
            this.tree[n] = this.tree[n] + 1;
            pos = this.parentIndex(pos);
        }
        this.tree[0] = this.tree[0] + 1;
    }

    public void subtractEdge(int pos) {
        pos += this.base;
        while (pos > 0) {
            int n = pos;
            this.tree[n] = this.tree[n] - 1;
            pos = this.parentIndex(pos);
        }
        this.tree[0] = this.tree[0] - 1;
    }

    public String toString() {
        return "First:" + this.firstIndex + ",last:" + this.last + ",treeSize:" + this.treeSize + "," + Arrays.toString(this.tree);
    }
}

