/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.bookmark;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;

public class BookmarkEditCmd
implements Command<Program> {
    private String category;
    private String comment;
    private Bookmark bookmark;
    private AddressSetView set;
    private Address addr;
    private String type;
    private String presentationName;

    public BookmarkEditCmd(AddressSetView set, String type, String category, String comment) {
        this.type = type;
        this.category = category;
        this.comment = comment;
        this.set = set;
        if (set == null || set.isEmpty() || type == null || type.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.presentationName = "Add " + type + " Bookmark(s)";
    }

    public BookmarkEditCmd(Address addr, String type, String category, String comment) {
        this.type = type;
        this.category = category;
        this.comment = comment;
        this.addr = addr;
        if (addr == null || type == null || type.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.presentationName = "Add " + type + " Bookmark";
    }

    public BookmarkEditCmd(Bookmark bookmark, String category, String comment) {
        this.bookmark = bookmark;
        this.category = category;
        this.comment = comment;
        if (bookmark == null) {
            throw new IllegalArgumentException();
        }
        this.presentationName = "Edit " + bookmark.getTypeString() + " Bookmark";
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public boolean applyTo(Program program) {
        BookmarkManager mgr = program.getBookmarkManager();
        if (this.bookmark != null) {
            this.bookmark.set(this.category, this.comment);
        } else if (this.addr != null) {
            mgr.setBookmark(this.addr, this.type, this.category, this.comment);
        } else {
            AddressRangeIterator rangeIter = this.set.getAddressRanges();
            while (rangeIter.hasNext()) {
                Address minAddr = ((AddressRange)rangeIter.next()).getMinAddress();
                mgr.setBookmark(minAddr, this.type, this.category, this.comment);
            }
        }
        return true;
    }

    public String getStatusMsg() {
        return null;
    }

    public String getName() {
        return this.presentationName;
    }
}

