/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.checksums;

import ghidra.app.plugin.core.checksums.ChecksumAlgorithm;
import ghidra.app.plugin.core.checksums.ComputeChecksumsProvider;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class ComputeChecksumTask
extends Task {
    private ComputeChecksumsProvider provider;
    private Memory memory;
    private AddressSetView set;
    private String errorMessage;

    public ComputeChecksumTask(ComputeChecksumsProvider provider, Memory memory, AddressSetView set) {
        super("Generating Checksums", true, true, true);
        this.provider = provider;
        this.memory = memory;
        this.set = set;
        if (set == null) {
            return;
        }
        for (MemoryBlock block : memory.getBlocks()) {
            if (block.isInitialized() || !set.intersects(block.getStart(), block.getEnd())) continue;
            this.errorMessage = "The current selection contains uninitialized memory. This memory is excluded from the checksum.";
            break;
        }
    }

    public void run(TaskMonitor monitor) {
        AddressSet addrs = new AddressSet((AddressSetView)(this.set != null ? this.set : this.memory));
        for (MemoryBlock block : this.memory.getBlocks()) {
            if (block.isInitialized()) continue;
            addrs.deleteRange(block.getStart(), block.getEnd());
        }
        List<ChecksumAlgorithm> checksumAlgorithms = this.provider.getChecksums();
        monitor.initialize((long)checksumAlgorithms.size());
        for (ChecksumAlgorithm check : checksumAlgorithms) {
            monitor.setMessage("Generating " + check.getName() + " checksum...");
            try {
                check.updateChecksum(this.memory, (AddressSetView)addrs, monitor, this.provider);
            }
            catch (MemoryAccessException | CancelledException e) {
                check.reset();
            }
            monitor.incrementProgress(1L);
        }
        SystemUtilities.runSwingLater(() -> this.provider.generateChecksumCompleted());
    }

    boolean hasError() {
        return this.errorMessage != null;
    }

    String getErrorMessage() {
        return this.errorMessage;
    }
}

