/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datawindow;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressMapImpl;

class DataRowObject
implements Comparable<DataRowObject> {
    private final long key;
    private final AddressMapImpl addressMap;

    DataRowObject(long key, AddressMapImpl addressMap) {
        this.key = key;
        this.addressMap = addressMap;
    }

    long getKey() {
        return this.key;
    }

    Address getAddress() {
        return this.addressMap.decodeAddress(this.key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.key ^ this.key >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataRowObject other = (DataRowObject)obj;
        return this.key == other.key;
    }

    @Override
    public int compareTo(DataRowObject o) {
        return Long.valueOf(this.key).compareTo(o.key);
    }
}

