/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.exporter;

import docking.DialogComponentProvider;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.plugin.core.exporter.ExporterDialog;
import ghidra.app.services.CodeViewerService;
import ghidra.framework.main.ApplicationLevelPlugin;
import ghidra.framework.main.FrontEndService;
import ghidra.framework.main.datatable.FrontendProjectTreeAction;
import ghidra.framework.main.datatable.ProjectDataContext;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Export Program/Datatype Archives", description="This plugin exports a program or datatype archive to an external file.")
public class ExporterPlugin
extends Plugin
implements ApplicationLevelPlugin {
    private FrontEndService frontEndService;

    public ExporterPlugin(PluginTool tool) {
        super(tool);
        this.frontEndService = (FrontEndService)tool.getService(FrontEndService.class);
        this.createFrontEndAction();
        this.createToolAction();
    }

    private void createToolAction() {
        if (this.frontEndService != null) {
            return;
        }
        NavigatableContextAction action = new NavigatableContextAction("Export Program", this.getName()){

            @Override
            protected void actionPerformed(NavigatableActionContext context) {
                Program program = context.getProgram();
                DomainFile domainFile = program.getDomainFile();
                ExporterDialog dialog = new ExporterDialog(ExporterPlugin.this.tool, domainFile, (DomainObject)program, context.getSelection());
                ExporterPlugin.this.tool.showDialog((DialogComponentProvider)dialog);
            }
        };
        MenuData menuData = new MenuData(new String[]{"&File", "Export Program..."}, "Import Export");
        menuData.setMenuSubGroup("z");
        action.setMenuBarData(menuData);
        action.setKeyBindingData(new KeyBindingData(79, 0));
        action.setHelpLocation(new HelpLocation("ExporterPlugin", "Export"));
        action.setDescription(this.getPluginDescription().getDescription());
        this.tool.addAction((DockingActionIf)action);
    }

    protected ProgramSelection getSelection() {
        CodeViewerService service = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        if (service != null) {
            return service.getCurrentSelection();
        }
        return null;
    }

    private void createFrontEndAction() {
        if (this.frontEndService == null) {
            return;
        }
        FrontendProjectTreeAction action = new FrontendProjectTreeAction("Export", this.getName()){

            protected void actionPerformed(ProjectDataContext context) {
                DomainFile domainFile = (DomainFile)context.getSelectedFiles().get(0);
                ExporterDialog dialog = new ExporterDialog(ExporterPlugin.this.tool, domainFile);
                ExporterPlugin.this.tool.showDialog((DialogComponentProvider)dialog);
            }

            protected boolean isEnabledForContext(ProjectDataContext context) {
                List selectedFolders = context.getSelectedFolders();
                if (!selectedFolders.isEmpty()) {
                    return false;
                }
                List selectedFiles = context.getSelectedFiles();
                return selectedFiles.size() == 1;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{"Export..."}, "Export"));
        action.setDescription(this.getPluginDescription().getDescription());
        action.setHelpLocation(new HelpLocation("ExporterPlugin", "Export"));
        this.tool.addAction((DockingActionIf)action);
    }
}

