/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import docking.action.DockingActionIf;
import ghidra.app.plugin.core.navigation.NavigationOptions;
import ghidra.app.plugin.core.navigation.NextSelectedRangeAction;
import ghidra.app.plugin.core.navigation.PreviousSelectedRangeAction;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Navigation", shortDescription="Navigates selection ranges", description="Provides actions for navigating from one selection range to the next or previous selection range.")
public class NextPrevSelectedRangePlugin
extends Plugin {
    static final String ACTION_SUB_GROUP = "1";
    private NavigationOptions navOptions;
    private NextSelectedRangeAction nextAction;
    private PreviousSelectedRangeAction previousAction;

    public NextPrevSelectedRangePlugin(PluginTool tool) {
        super(tool);
        this.navOptions = new NavigationOptions(tool);
        this.createActions();
    }

    protected void dispose() {
        this.navOptions.dispose();
        super.dispose();
    }

    private void createActions() {
        this.nextAction = new NextSelectedRangeAction(this.tool, this.getName(), this.navOptions);
        this.tool.addAction((DockingActionIf)this.nextAction);
        this.previousAction = new PreviousSelectedRangeAction(this.tool, this.getName(), this.navOptions);
        this.tool.addAction((DockingActionIf)this.previousAction);
    }
}

