/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GLabel;
import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.plugin.core.references.EditReferencePanel;
import ghidra.app.plugin.core.references.EditReferencesProvider;
import ghidra.app.plugin.core.references.ReferencesPlugin;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.StackReference;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class EditStackReferencePanel
extends EditReferencePanel {
    private static final RefType[] STACK_REF_TYPES = RefTypeFactory.getStackRefTypes();
    private ReferencesPlugin plugin;
    private CodeUnit fromCodeUnit;
    private int opIndex;
    private StackReference editRef;
    private JTextField stackOffset;
    private GhidraComboBox<RefType> refTypes;
    private boolean isValidStackRef;
    private boolean isValidState;

    EditStackReferencePanel(ReferencesPlugin plugin) {
        super("STACK");
        this.plugin = plugin;
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout((LayoutManager)new PairLayout(10, 10, 160));
        this.setBorder(new EmptyBorder(0, 5, 5, 5));
        this.stackOffset = new JTextField();
        this.stackOffset.getAccessibleContext().setAccessibleName("Stack Offset");
        this.refTypes = new GhidraComboBox((Object[])STACK_REF_TYPES);
        this.refTypes.getAccessibleContext().setAccessibleName("Ref Types");
        this.add((Component)new GLabel("Stack Offset:", 4));
        this.add(this.stackOffset);
        this.add((Component)new GLabel("Ref-Type:", 4));
        this.add((Component)this.refTypes);
    }

    private void populateRefTypes(RefType adhocType) {
        this.refTypes.clearModel();
        for (RefType element : STACK_REF_TYPES) {
            if (adhocType == element) {
                adhocType = null;
            }
            this.refTypes.addItem((Object)element);
        }
        if (adhocType != null) {
            this.refTypes.addItem((Object)adhocType);
        }
    }

    boolean isValidStackRef() {
        return this.isValidStackRef;
    }

    @Override
    public void initialize(CodeUnit fromCu, Reference editReference) {
        this.isValidState = false;
        if (!(fromCu instanceof Instruction) || !(editReference instanceof StackReference)) {
            throw new IllegalArgumentException("Valid instruction and stack reference required");
        }
        this.fromCodeUnit = fromCu;
        this.editRef = (StackReference)editReference;
        if (!this.editRef.isStackReference()) {
            throw new IllegalArgumentException("Valid stack reference required");
        }
        this.stackOffset.setText(this.toHexString(this.editRef.getStackOffset()));
        RefType rt = this.editRef.getReferenceType();
        this.populateRefTypes(rt);
        this.refTypes.setSelectedItem((Object)rt);
        this.isValidState = true;
    }

    @Override
    public boolean initialize(CodeUnit fromCu, int fromOpIndex, int fromSubIndex) {
        this.isValidState = false;
        this.editRef = null;
        this.fromCodeUnit = fromCu;
        return this.setOpIndex(fromOpIndex);
    }

    @Override
    public boolean setOpIndex(int opIndex) {
        if (this.editRef != null) {
            throw new IllegalStateException("setOpIndex only permitted for ADD case");
        }
        this.isValidState = false;
        this.opIndex = opIndex;
        if (opIndex == EditReferencesProvider.MNEMONIC_OPINDEX || !(this.fromCodeUnit instanceof Instruction)) {
            return false;
        }
        Function f = this.fromCodeUnit.getProgram().getFunctionManager().getFunctionContaining(this.fromCodeUnit.getMinAddress());
        if (f == null) {
            return false;
        }
        RefType rt = RefTypeFactory.getDefaultStackRefType((CodeUnit)this.fromCodeUnit, (int)opIndex);
        CallDepthChangeInfo depth = new CallDepthChangeInfo(f);
        int offset = depth.getStackOffset((Instruction)this.fromCodeUnit, opIndex);
        boolean bl = this.isValidStackRef = offset != 0x7FFFFFFE;
        if (!this.isValidStackRef) {
            Object[] opObjs;
            Scalar s = null;
            for (Object obj : opObjs = ((Instruction)this.fromCodeUnit).getOpObjects(opIndex)) {
                if (!(obj instanceof Scalar)) continue;
                if (s != null) {
                    s = null;
                    break;
                }
                s = (Scalar)obj;
            }
            offset = s != null ? (int)s.getValue() : 0;
        }
        this.stackOffset.setText(this.toHexString(offset));
        this.populateRefTypes(rt);
        this.refTypes.setSelectedItem((Object)rt);
        this.isValidState = true;
        return true;
    }

    private String toHexString(long val) {
        boolean neg = val < 0L;
        return (neg ? "-" : "+") + "0x" + Long.toHexString(neg ? -val : val);
    }

    @Override
    public boolean applyReference() {
        long offset;
        if (!this.isValidState) {
            throw new IllegalStateException();
        }
        Program program = this.fromCodeUnit.getProgram();
        Function f = program.getFunctionManager().getFunctionContaining(this.fromCodeUnit.getMinAddress());
        if (f == null) {
            this.showInputErr("Stack reference not permitted!\nAddress " + String.valueOf(this.fromCodeUnit.getMinAddress()) + " is no longer contained within a function.");
            return false;
        }
        String str = this.stackOffset.getText();
        try {
            offset = this.parseLongInput(str);
        }
        catch (NumberFormatException e) {
            this.showInputErr("Valid 'Stack Offset' is required.");
            return false;
        }
        AddressSpace stackSpace = program.getAddressFactory().getStackSpace();
        long minOffset = stackSpace.getMinAddress().getOffset();
        long maxOffset = stackSpace.getMaxAddress().getOffset();
        if (offset < minOffset || offset > maxOffset) {
            this.showInputErr("'Stack Offset' value too " + (offset > 0L ? "large" : "small") + "\nMust be between " + this.toHexString(minOffset) + " and " + this.toHexString(maxOffset));
            return false;
        }
        RefType refType = (RefType)this.refTypes.getSelectedItem();
        if (refType == null) {
            this.showInputErr("A 'Ref-Type' must be selected.");
            return false;
        }
        if (this.editRef != null) {
            return this.plugin.updateReference(this.editRef, this.fromCodeUnit, (int)offset, refType);
        }
        return this.plugin.addReference(this.fromCodeUnit, this.opIndex, (int)offset, refType);
    }

    @Override
    public void cleanup() {
        this.isValidState = false;
        this.fromCodeUnit = null;
        this.editRef = null;
    }

    @Override
    public boolean isValidContext() {
        return this.isValidState;
    }
}

