/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string.translate.libretranslate;

import docking.options.OptionsService;
import ghidra.app.plugin.core.string.translate.libretranslate.LibreTranslateStringTranslationService;
import ghidra.app.services.StringTranslationService;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Miscellaneous", category="Common", shortDescription="String translations using LibreTranslate", description="Uses an external LibreTranslate server to translate strings.\nSee LibreTranslate's website for links to their docs about\nAPI keys or instructions for self-hosting your own instance.", servicesProvided={StringTranslationService.class})
public class LibreTranslatePlugin
extends Plugin
implements OptionsChangeListener {
    public static final String LIBRE_TRANSLATE_SERVICE_NAME = "LibreTranslate";
    private static final String STRINGS_OPTION = "Strings";
    private static final String LT_OPTION = "LibreTranslate";
    private static final String SOURCE_LANG_OPTION = "Source Language";
    private static final String API_KEY_OPTION = "API Key";
    private static final String URL_OPTION = "URL";
    private static final String TARGET_LANG_OPTION = "Target Language";
    private static final String BATCHSIZE_OPTION = "Batch Size";
    private static final String HTTP_TIMEOUT_OPTION = "HTTP Timeout";
    private static final String HTTP_TIMEOUT_PER_ELEMENT_OPTION = "HTTP Timeout [per string]";
    private static final int BATCHSIZE_DEFAULT = 50;
    private static final int BATCHSIZE_MAX = 1000;
    private static final int TIMEOUT_DEFAULT = 20000;
    private static final int TIMEOUT_PERSTRING_DEFAULT = 1000;
    private ToolOptions stringOptions;
    private StringTranslationService serviceInstance;

    public LibreTranslatePlugin(PluginTool tool) {
        super(tool);
        this.initOptions();
        this.updateServiceInstance();
    }

    private void initOptions() {
        HelpLocation helpLoc = new HelpLocation("LibreTranslatePlugin", "Configuration");
        this.stringOptions = this.tool.getOptions(STRINGS_OPTION);
        this.stringOptions.registerOption(this.subOpt(URL_OPTION), OptionType.STRING_TYPE, (Object)"", helpLoc, "LibreTranslate server URL.  Required.  Example: http://localhost:5000/");
        this.stringOptions.registerOption(this.subOpt(API_KEY_OPTION), OptionType.STRING_TYPE, (Object)"", helpLoc, "LibreTranslate API Key.  Optional, but possibly required by the server.");
        this.stringOptions.registerOption(this.subOpt(SOURCE_LANG_OPTION), OptionType.ENUM_TYPE, (Object)SOURCE_LANGUAGE_OPTION.AUTO, helpLoc, "Source language code option, either 'auto' or prompted each time.");
        this.stringOptions.registerOption(this.subOpt(TARGET_LANG_OPTION), OptionType.STRING_TYPE, (Object)"en", helpLoc, "Target language code.  Defaults to 'en'.  See LibreTranslate's docs for list.");
        this.stringOptions.registerOption(this.subOpt(BATCHSIZE_OPTION), OptionType.INT_TYPE, (Object)50, helpLoc, "Maximum number of requests to batch together.");
        this.stringOptions.registerOption(this.subOpt(HTTP_TIMEOUT_OPTION), OptionType.INT_TYPE, (Object)20000, helpLoc, "Time to wait for HTTP requests to the LibreTranslate server to finish. (milliseconds)");
        this.stringOptions.registerOption(this.subOpt(HTTP_TIMEOUT_PER_ELEMENT_OPTION), OptionType.INT_TYPE, (Object)1000, helpLoc, "Additional time (per translated string) to wait for HTTP requests to finish. (milliseconds)");
        this.stringOptions.addOptionsChangeListener((OptionsChangeListener)this);
    }

    protected void dispose() {
        if (this.stringOptions != null) {
            this.stringOptions.removeOptionsChangeListener((OptionsChangeListener)this);
            this.stringOptions = null;
        }
        super.dispose();
    }

    public void optionsChanged(ToolOptions newOptions, String optionName, Object oldValue, Object newValue) {
        if (optionName.startsWith(this.subOpt(""))) {
            this.updateServiceInstance();
        }
    }

    private void updateServiceInstance() {
        if (this.serviceInstance != null) {
            this.deregisterService(StringTranslationService.class, this.serviceInstance);
            this.serviceInstance = null;
        }
        String urlStr = this.stringOptions.getString(this.subOpt(URL_OPTION), "");
        String apiKey = this.stringOptions.getString(this.subOpt(API_KEY_OPTION), "");
        SOURCE_LANGUAGE_OPTION srcLangOption = (SOURCE_LANGUAGE_OPTION)this.stringOptions.getEnum(this.subOpt(SOURCE_LANG_OPTION), (Enum)SOURCE_LANGUAGE_OPTION.AUTO);
        String targetLangCode = this.stringOptions.getString(this.subOpt(TARGET_LANG_OPTION), "en");
        int batchSize = this.stringOptions.getInt(this.subOpt(BATCHSIZE_OPTION), 50);
        batchSize = Math.clamp((long)batchSize, 1, 1000);
        int timeout = this.stringOptions.getInt(this.subOpt(HTTP_TIMEOUT_OPTION), 20000);
        int timeoutPerString = this.stringOptions.getInt(this.subOpt(HTTP_TIMEOUT_PER_ELEMENT_OPTION), 1000);
        timeout = Math.clamp((long)timeout, 1000, 3600000);
        timeoutPerString = Math.clamp((long)timeoutPerString, 1, 60000);
        if (urlStr != null && !urlStr.isBlank()) {
            try {
                URI serverURI = URI.create(urlStr).toURL().toURI();
                this.serviceInstance = new LibreTranslateStringTranslationService(serverURI, apiKey, srcLangOption, targetLangCode, batchSize, timeout, timeoutPerString);
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                Msg.warn((Object)((Object)this), (Object)("Invalid URL for LibreTranslate option: " + urlStr));
                this.tool.setStatusInfo("Invalid URL for LibreTranslate option: " + urlStr);
            }
        }
        if (this.serviceInstance == null) {
            this.serviceInstance = new StringTranslationService(){

                @Override
                public void translate(Program program, List<ProgramLocation> stringLocations, StringTranslationService.TranslateOptions options) {
                    OptionsService optionService = (OptionsService)LibreTranslatePlugin.this.tool.getService(OptionsService.class);
                    if (optionService != null) {
                        optionService.showOptionsDialog("Strings.LibreTranslate", null);
                        Swing.runLater(() -> {
                            if (LibreTranslatePlugin.this.serviceInstance instanceof LibreTranslateStringTranslationService) {
                                LibreTranslatePlugin.this.serviceInstance.translate(program, stringLocations, options);
                            }
                        });
                    }
                }

                @Override
                public String getTranslationServiceName() {
                    return "LibreTranslate";
                }
            };
        }
        this.registerDynamicServiceProvided(StringTranslationService.class, this.serviceInstance);
    }

    private String subOpt(String optName) {
        return "LibreTranslate." + optName;
    }

    public static enum SOURCE_LANGUAGE_OPTION {
        AUTO,
        PROMPT;

    }
}

