/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.coff.AoutHeader;
import java.io.IOException;

public class AoutHeaderMIPS
extends AoutHeader {
    public static final int SIZEOF = 56;
    private int bss_start;
    private int gprmask;
    private int[] cprmask;
    private int gp_value;

    AoutHeaderMIPS(BinaryReader reader) throws IOException {
        super(reader);
        this.bss_start = reader.readNextInt();
        this.gprmask = reader.readNextInt();
        this.cprmask = reader.readNextIntArray(4);
        this.gp_value = reader.readNextInt();
    }

    public int getUninitializedDataStart() {
        return this.bss_start;
    }

    public int getGprMask() {
        return this.gprmask;
    }

    public int[] getCprMask() {
        return this.cprmask;
    }

    public int getGpValue() {
        return this.gp_value;
    }
}

