/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.ImageRuntimeFunctionEntries;
import ghidra.app.util.bin.format.pe.ImageRuntimeFunctionEntries_ARM;
import ghidra.app.util.bin.format.pe.ImageRuntimeFunctionEntries_X86;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class ExceptionDataDirectory
extends DataDirectory {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_EXCEPTION";
    private ImageRuntimeFunctionEntries functionEntries;

    ExceptionDataDirectory(NTHeader ntHeader, BinaryReader reader) throws IOException {
        this.processDataDirectory(ntHeader, reader);
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parse() throws IOException {
        int ptr = this.getPointer();
        if (ptr < 0) {
            return false;
        }
        long oldIndex = this.reader.getPointerIndex();
        this.reader.setPointerIndex(ptr);
        try {
            this.functionEntries = switch (this.ntHeader.getFileHeader().getMachine() & 0xFFFF) {
                case 332, 512, 34404 -> new ImageRuntimeFunctionEntries_X86(this.reader, this.size, this.ntHeader);
                case 448, 452, 43620 -> new ImageRuntimeFunctionEntries_ARM(this.reader, this.size, this.ntHeader);
                default -> {
                    Msg.error((Object)this, (Object)String.format("Exception Data unsupported architecture: 0x%02x", this.ntHeader.getFileHeader().getMachine()));
                    yield null;
                }
            };
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Failed to parse " + ExceptionDataDirectory.class.getSimpleName()), (Throwable)e);
        }
        finally {
            this.reader.setPointerIndex(oldIndex);
        }
        return false;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader nt) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        Address addr = PeUtils.getMarkupAddress(program, isBinary, nt, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        if (this.functionEntries != null) {
            this.functionEntries.markup(program, addr);
        }
    }
}

