/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.dyld.DyldArchitecture;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramWrapperLoader;
import ghidra.app.util.opinion.DyldCacheOptions;
import ghidra.app.util.opinion.DyldCacheProgramBuilder;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DyldCacheLoader
extends AbstractProgramWrapperLoader {
    public static final String DYLD_CACHE_NAME = "DYLD Cache";
    static final String FIXUP_SLIDE_POINTERS_OPTION_NAME = "Fixup slide pointers";
    static final boolean FIXUP_SLIDE_POINTERS_OPTION_DEFAULT = true;
    static final String MARKUP_SLIDE_POINTERS_OPTION_NAME = "Markup slide pointers";
    static final boolean MARKUP_SLIDE_POINTERS_OPTION_DEFAULT = true;
    static final String ADD_SLIDE_POINTER_RELOCATIONS_OPTION_NAME = "Add slide pointers to relocation table";
    static final boolean ADD_SLIDE_POINTERS_RELOCATIONS_OPTION_DEFAULT = false;
    static final String PROCESS_LOCAL_SYMBOLS_OPTION_NAME = "Process local symbols";
    static final boolean PROCESS_LOCAL_SYMBOLS_OPTION_DEFAULT = true;
    static final String MARKUP_LOCAL_SYMBOLS_OPTION_NAME = "Markup local symbol nlists";
    static final boolean MARKUP_LOCAL_SYMBOLS_OPTION_DEFAULT = false;
    static final String PROCESS_DYLIB_MEMORY_OPTION_NAME = "Process dylib memory";
    static final boolean PROCESS_DYLIB_MEMORY_OPTION_DEFAULT = true;
    static final String PROCESS_DYLIB_SYMBOLS_OPTION_NAME = "Process dylib symbols";
    static final boolean PROCESS_DYLIB_SYMBOLS_OPTION_DEFAULT = true;
    static final String PROCESS_DYLIB_EXPORTS_OPTION_NAME = "Process dylib exports";
    static final boolean PROCESS_DYLIB_EXPORTS_OPTION_DEFAULT = true;
    static final String MARKUP_DYLIB_LC_DATA_OPTION_NAME = "Markup dylib load command data";
    static final boolean MARKUP_DYLIB_LC_DATA_OPTION_DEFAULT = false;
    static final String PROCESS_DYLIB_LIBOBJC_OPTION_NAME = "Process libobjc";
    static final boolean PROCESS_DYLIB_LIBOBJC_OPTION_DEFAULT = true;

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (!DyldCacheUtils.isDyldCache(provider)) {
            return loadSpecs;
        }
        try {
            DyldCacheHeader header = new DyldCacheHeader(new BinaryReader(provider, true));
            if (header.isSubcache()) {
                return loadSpecs;
            }
            DyldArchitecture architecture = header.getArchitecture();
            if (architecture != null) {
                List<QueryResult> results = QueryOpinionService.query(this.getName(), architecture.getProcessor(), null);
                for (QueryResult result : results) {
                    loadSpecs.add(new LoadSpec((Loader)this, header.getBaseAddress(), result));
                }
                if (loadSpecs.isEmpty()) {
                    loadSpecs.add(new LoadSpec((Loader)this, header.getBaseAddress(), true));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return loadSpecs;
    }

    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException {
        try {
            DyldCacheProgramBuilder.buildProgram(program, provider, MemoryBlockUtils.createFileBytes(program, provider, monitor), this.getDyldCacheOptions(options), log, monitor);
        }
        catch (CancelledException e) {
            return;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram);
        if (!loadIntoProgram) {
            list.add(new Option(FIXUP_SLIDE_POINTERS_OPTION_NAME, true, Boolean.class, "-loader-fixupSlidePointers"));
            list.add(new Option(MARKUP_SLIDE_POINTERS_OPTION_NAME, true, Boolean.class, "-loader-markupSlidePointers"));
            list.add(new Option(ADD_SLIDE_POINTER_RELOCATIONS_OPTION_NAME, false, Boolean.class, "-loader-addSlidePointerRelocations"));
            list.add(new Option(PROCESS_LOCAL_SYMBOLS_OPTION_NAME, true, Boolean.class, "-loader-processLocalSymbols"));
            list.add(new Option(MARKUP_LOCAL_SYMBOLS_OPTION_NAME, false, Boolean.class, "-loader-markupLocalSymbols"));
            list.add(new Option(PROCESS_DYLIB_MEMORY_OPTION_NAME, true, Boolean.class, "-loader-processDylibMemory"));
            list.add(new Option(PROCESS_DYLIB_SYMBOLS_OPTION_NAME, true, Boolean.class, "-loader-processDylibSymbols"));
            list.add(new Option(PROCESS_DYLIB_EXPORTS_OPTION_NAME, true, Boolean.class, "-loader-processDylibExports"));
            list.add(new Option(MARKUP_DYLIB_LC_DATA_OPTION_NAME, false, Boolean.class, "-loader-markupDylibLoadCommandData"));
            list.add(new Option(PROCESS_DYLIB_LIBOBJC_OPTION_NAME, true, Boolean.class, "-loader-processLibobjc"));
        }
        return list;
    }

    private DyldCacheOptions getDyldCacheOptions(List<Option> options) {
        boolean fixupSlidePointers = OptionUtils.getOption(FIXUP_SLIDE_POINTERS_OPTION_NAME, options, true);
        boolean markupSlidePointers = OptionUtils.getOption(MARKUP_SLIDE_POINTERS_OPTION_NAME, options, true);
        boolean addSlidePointerRelocations = OptionUtils.getOption(ADD_SLIDE_POINTER_RELOCATIONS_OPTION_NAME, options, false);
        boolean processLocalSymbols = OptionUtils.getOption(PROCESS_LOCAL_SYMBOLS_OPTION_NAME, options, true);
        boolean markupLocalSymbols = OptionUtils.getOption(MARKUP_LOCAL_SYMBOLS_OPTION_NAME, options, false);
        boolean processDylibMemory = OptionUtils.getOption(PROCESS_DYLIB_MEMORY_OPTION_NAME, options, true);
        boolean processDylibSymbols = OptionUtils.getOption(PROCESS_DYLIB_SYMBOLS_OPTION_NAME, options, true);
        boolean processDylibExports = OptionUtils.getOption(PROCESS_DYLIB_EXPORTS_OPTION_NAME, options, true);
        boolean markupDylibLoadCommandData = OptionUtils.getOption(MARKUP_DYLIB_LC_DATA_OPTION_NAME, options, false);
        boolean processLibobjc = OptionUtils.getOption(PROCESS_DYLIB_LIBOBJC_OPTION_NAME, options, true);
        return new DyldCacheOptions(fixupSlidePointers, markupSlidePointers, addSlidePointerRelocations, processLocalSymbols, markupLocalSymbols, processDylibMemory, processDylibSymbols, processDylibExports, markupDylibLoadCommandData, processLibobjc);
    }

    @Override
    public String getName() {
        return DYLD_CACHE_NAME;
    }
}

