/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.app.util.importer.LibrarySearchPathManager;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.LocalFileSystem;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;

public class LibrarySearchPathFSBFileHandler
implements FSBFileHandler {
    private FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder("FSB Add Library Search Path", this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getFSRL(true) != null).popupMenuPath(new String[]{"Add Library Search Path"}).popupMenuGroup("F", "D").popupMenuIcon(FSBIcons.LIBRARY).description("Add file/folder to library search paths").onAction(ac -> {
            JComponent parentComp = this.context.fsbComponent().getComponent();
            try {
                String path;
                FSRL fsrl = ac.getFSRL(true);
                FileSystemService fsService = this.context.fsService();
                LocalFileSystem localFs = fsService.getLocalFS();
                String string = path = fsService.isLocal(fsrl) ? localFs.getLocalFile(fsrl).getPath() : fsrl.toString();
                if (LibrarySearchPathManager.addPath(path)) {
                    Msg.showInfo((Object)this, (Component)parentComp, (String)"Add Library Search Path", (Object)"Added '%s' to library search paths.".formatted(fsrl));
                } else {
                    Msg.showInfo((Object)this, (Component)parentComp, (String)"Add Library Search Path", (Object)"Library search path '%s' already exists.".formatted(fsrl));
                }
            }
            catch (IOException e) {
                Msg.showError((Object)this, (Component)parentComp, (String)"Add Library Search Path", (Object)e);
            }
        }).build());
    }
}

