/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.MSP430_ElfRelocationType;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class MSP430_ElfRelocationHandler
extends AbstractElfRelocationHandler<MSP430_ElfRelocationType, ElfRelocationContext<?>> {
    public MSP430_ElfRelocationHandler() {
        super(MSP430_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 105 && (elf.e_flags() & 0xFF) != 45;
    }

    protected RelocationResult relocate(ElfRelocationContext<?> elfRelocationContext, ElfRelocation relocation, MSP430_ElfRelocationType type, Address relocationAddress, ElfSymbol sym, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        int byteLength;
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int symbolIndex = relocation.getSymbolIndex();
        long addend = relocation.getAddend();
        long offset = relocationAddress.getOffset();
        switch (type) {
            case R_MSP430_32: {
                int newIntValue = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, newIntValue);
                byteLength = 4;
                break;
            }
            case R_MSP430_10_PCREL: {
                short oldShortValue = memory.getShort(relocationAddress);
                oldShortValue = (short)(oldShortValue & 0xFC00);
                short newShortValue = (short)(symbolValue + addend - offset - 2L);
                newShortValue = (short)(newShortValue >> 1);
                newShortValue = (short)(newShortValue & 0x3FF);
                newShortValue = (short)(oldShortValue | newShortValue);
                memory.setShort(relocationAddress, newShortValue);
                byteLength = 2;
                break;
            }
            case R_MSP430_16: {
                short newShortValue = (short)(symbolValue + addend);
                memory.setShort(relocationAddress, newShortValue);
                byteLength = 2;
                break;
            }
            case R_MSP430_16_BYTE: {
                short newShortValue = (short)(symbolValue + addend);
                memory.setShort(relocationAddress, newShortValue);
                byteLength = 2;
                break;
            }
            case R_MSP430_16_PCREL_BYTE: {
                short newShortValue = (short)(symbolValue + addend - offset);
                memory.setShort(relocationAddress, newShortValue);
                byteLength = 2;
                break;
            }
            case R_MSP430_8: {
                byte newByteValue = (byte)(symbolValue + addend);
                memory.setByte(relocationAddress, newByteValue);
                byteLength = 1;
                break;
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

