/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.map;

import ghidra.lifecycle.Internal;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMap;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapAddressSetView;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.DBTraceSpaceBased;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.map.TraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.spatial.AbstractConstraintsTreeSpatialMap;
import ghidra.util.database.spatial.BoundedShape;
import ghidra.util.database.spatial.SpatialMap;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;

public class DBTraceAddressSnapRangePropertyMapSpace<T, DR extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<T>>
implements DBTraceSpaceBased,
SpatialMap<TraceAddressSnapRange, T, DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery>,
TraceAddressSnapRangePropertyMapSpace<T> {
    protected final AddressSpace space;
    protected final TraceThread thread;
    protected final int frameLevel;
    protected final ReadWriteLock lock;
    protected final DBTraceAddressSnapRangePropertyMapTree<T, DR> tree;
    protected final AbstractConstraintsTreeSpatialMap<TraceAddressSnapRange, DR, TraceAddressSnapRange, T, DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery> map;
    protected final AddressRangeImpl fullSpace;

    public DBTraceAddressSnapRangePropertyMapSpace(String tableName, DBCachedObjectStoreFactory storeFactory, ReadWriteLock lock, AddressSpace space, TraceThread thread, int frameLevel, Class<DR> dataType, DBTraceAddressSnapRangePropertyMap.DBTraceAddressSnapRangePropertyMapDataFactory<T, DR> dataFactory) throws VersionException, IOException {
        this.space = space;
        this.thread = thread;
        this.frameLevel = frameLevel;
        this.lock = lock;
        this.tree = new DBTraceAddressSnapRangePropertyMapTree<T, DR>(storeFactory, tableName, this, dataType, dataFactory, true);
        this.map = this.tree.asSpatialMap();
        this.fullSpace = new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress());
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.space;
    }

    @Override
    public TraceThread getThread() {
        return this.thread;
    }

    @Override
    public int getFrameLevel() {
        return this.frameLevel;
    }

    public <K> DBCachedObjectIndex<K, DR> getUserIndex(Class<K> fieldClass, DBObjectColumn column) {
        return this.tree.getUserIndex(fieldClass, column);
    }

    @Override
    public void deleteValue(T value) {
        if (!(value instanceof DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)) {
            throw new UnsupportedOperationException("Can only directly delete values for maps where the entry is the value");
        }
        this.deleteData((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)value);
    }

    public void deleteData(DR data) {
        if (((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)data).tree != this.tree) {
            throw new IllegalArgumentException("The given entry is not in this space");
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.tree.doDeleteEntry(data);
        }
    }

    public T put(TraceAddressSnapRange shape, T value) {
        return (T)this.map.put((BoundedShape)shape, value);
    }

    public boolean remove(TraceAddressSnapRange shape, T value) {
        return this.map.remove((BoundedShape)shape, value);
    }

    public boolean remove(Map.Entry<TraceAddressSnapRange, T> entry) {
        return this.map.remove(entry);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Collection<Map.Entry<TraceAddressSnapRange, T>> entries() {
        return this.map.entries();
    }

    public Collection<Map.Entry<TraceAddressSnapRange, T>> orderedEntries() {
        return this.map.orderedEntries();
    }

    public Collection<TraceAddressSnapRange> keys() {
        return this.map.keys();
    }

    public Collection<TraceAddressSnapRange> orderedKeys() {
        return this.map.orderedKeys();
    }

    public Collection<T> values() {
        return this.map.values();
    }

    public Collection<T> orderedValues() {
        return this.map.orderedValues();
    }

    public SpatialMap<TraceAddressSnapRange, T, DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery> reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery query) {
        return this.map.reduce((Object)query);
    }

    public Map.Entry<TraceAddressSnapRange, T> firstEntry() {
        return this.map.firstEntry();
    }

    public TraceAddressSnapRange firstKey() {
        return (TraceAddressSnapRange)this.map.firstKey();
    }

    public T firstValue() {
        return (T)this.map.firstValue();
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public void invalidateCache() {
        this.tree.invalidateCache();
    }

    @Override
    public AddressSetView getAddressSetView(Lifespan span, Predicate<T> predicate) {
        return new DBTraceAddressSnapRangePropertyMapAddressSetView<T>(this.space, this.lock, this.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)this.fullSpace, span)), predicate);
    }

    @Override
    public AddressSetView getAddressSetView(Lifespan span) {
        return this.getAddressSetView(span, t -> true);
    }

    public DR getDataByKey(long key) {
        return (DR)((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)this.tree.getDataByKey(key));
    }

    @Internal
    public void checkIntegrity() {
        this.tree.checkIntegrity();
    }
}

