/*
 * Decompiled with CFR 0.152.
 */
package mobiledevices.dmg.ghidra;

import java.io.IOException;
import mobiledevices.dmg.ghidra.GByteProvider;
import mobiledevices.dmg.ghidra.GDataConverter;
import mobiledevices.dmg.ghidra.GDataConverterBE;
import mobiledevices.dmg.ghidra.GDataConverterLE;

public class GBinaryReader {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    private GByteProvider provider;
    private GDataConverter converter;
    private long currentIndex;

    public GBinaryReader(GByteProvider provider, boolean isLittleEndian) {
        this.provider = provider;
        this.setLittleEndian(isLittleEndian);
    }

    public GBinaryReader clone(int newIndex) {
        GBinaryReader clone = new GBinaryReader(this.provider, this.isLittleEndian());
        clone.converter = this.converter;
        clone.currentIndex = newIndex;
        return clone;
    }

    public boolean isLittleEndian() {
        return this.converter instanceof GDataConverterLE;
    }

    public void setLittleEndian(boolean isLittleEndian) {
        this.converter = isLittleEndian ? new GDataConverterLE() : new GDataConverterBE();
    }

    public long length() throws IOException {
        return this.provider.length();
    }

    public boolean isValidIndex(int index) throws IOException {
        return this.provider.isValidIndex((long)index & 0xFFFFFFFFL);
    }

    public boolean isValidIndex(long index) throws IOException {
        return this.provider.isValidIndex(index);
    }

    public int align(int alignValue) {
        long align = this.currentIndex % (long)alignValue;
        if (align == 0L) {
            return 0;
        }
        this.currentIndex += (long)alignValue - align;
        return (int)((long)alignValue - align);
    }

    public void setPointerIndex(int index) {
        this.currentIndex = (long)index & 0xFFFFFFFFL;
    }

    public void setPointerIndex(long index) {
        this.currentIndex = index;
    }

    public long getPointerIndex() {
        return this.currentIndex;
    }

    public byte peekNextByte() throws IOException {
        return this.readByte(this.currentIndex);
    }

    public short peekNextShort() throws IOException {
        return this.readShort(this.currentIndex);
    }

    public int peekNextInt() throws IOException {
        return this.readInt(this.currentIndex);
    }

    public long peekNextLong() throws IOException {
        return this.readLong(this.currentIndex);
    }

    public byte readNextByte() throws IOException {
        byte b = this.readByte(this.currentIndex);
        ++this.currentIndex;
        return b;
    }

    public byte readNextByte(byte minClamp, byte maxClamp, Byte ... exceptions) throws IOException {
        byte b = this.readByte(this.currentIndex, minClamp, maxClamp, exceptions);
        ++this.currentIndex;
        return b;
    }

    public short readNextShort() throws IOException {
        short s = this.readShort(this.currentIndex);
        this.currentIndex += 2L;
        return s;
    }

    public short readNextShort(short minClamp, short maxClamp, Short ... exceptions) throws IOException {
        short s = this.readShort(this.currentIndex, minClamp, maxClamp, exceptions);
        this.currentIndex += 2L;
        return s;
    }

    public int readNextInt() throws IOException {
        int i = this.readInt(this.currentIndex);
        this.currentIndex += 4L;
        return i;
    }

    public int readNextInt(int minClamp, int maxClamp, Integer ... exceptions) throws IOException {
        int i = this.readInt(this.currentIndex, minClamp, maxClamp, exceptions);
        this.currentIndex += 4L;
        return i;
    }

    public long readNextLong() throws IOException {
        long l = this.readLong(this.currentIndex);
        this.currentIndex += 8L;
        return l;
    }

    public long readNextLong(long minClamp, long maxClamp, Long ... exceptions) throws IOException {
        long l = this.readLong(this.currentIndex, minClamp, maxClamp, exceptions);
        this.currentIndex += 8L;
        return l;
    }

    public String readNextAsciiString() throws IOException {
        String s = this.readAsciiString(this.currentIndex);
        this.currentIndex += (long)(s.length() + 1);
        return s;
    }

    public String readNextAsciiString(int length) throws IOException {
        String s = this.readAsciiString(this.currentIndex, length);
        this.currentIndex += (long)length;
        return s;
    }

    public String readNextUnicodeString() throws IOException {
        String s = this.readUnicodeString(this.currentIndex);
        this.currentIndex += (long)((s.length() + 1) * 2);
        return s;
    }

    public String readNextUnicodeString(int length) throws IOException {
        String s = this.readUnicodeString(this.currentIndex, length);
        this.currentIndex += (long)(length * 2);
        return s;
    }

    public byte[] readNextByteArray(int nElements) throws IOException {
        byte[] b = this.readByteArray(this.currentIndex, nElements);
        this.currentIndex += (long)(1 * nElements);
        return b;
    }

    public byte[] readNextByteArray(int nElements, byte minClamp, byte maxClamp, Byte ... exceptions) throws IOException {
        byte[] b = this.readByteArray(this.currentIndex, nElements, minClamp, maxClamp, exceptions);
        this.currentIndex += (long)(1 * nElements);
        return b;
    }

    public short[] readNextShortArray(int nElements) throws IOException {
        short[] s = this.readShortArray(this.currentIndex, nElements);
        this.currentIndex += (long)(2 * nElements);
        return s;
    }

    public short[] readNextShortArray(int nElements, short minClamp, short maxClamp, Short ... exceptions) throws IOException {
        short[] s = this.readShortArray(this.currentIndex, nElements, minClamp, maxClamp, exceptions);
        this.currentIndex += (long)(2 * nElements);
        return s;
    }

    public int[] readNextIntArray(int nElements) throws IOException {
        int[] i = this.readIntArray(this.currentIndex, nElements);
        this.currentIndex += (long)(4 * nElements);
        return i;
    }

    public int[] readNextIntArray(int nElements, int minClamp, int maxClamp, Integer ... exceptions) throws IOException {
        int[] i = this.readIntArray(this.currentIndex, nElements, minClamp, maxClamp, exceptions);
        this.currentIndex += (long)(4 * nElements);
        return i;
    }

    public long[] readNextLongArray(int nElements) throws IOException {
        long[] l = this.readLongArray(this.currentIndex, nElements);
        this.currentIndex += (long)(8 * nElements);
        return l;
    }

    public long[] readNextLongArray(int nElements, long minClamp, long maxClamp, Long ... exceptions) throws IOException {
        long[] l = this.readLongArray(this.currentIndex, nElements, minClamp, maxClamp, exceptions);
        this.currentIndex += (long)(8 * nElements);
        return l;
    }

    public String readAsciiString(long index) throws IOException {
        byte b;
        StringBuffer buffer = new StringBuffer();
        while ((b = this.provider.readByte(index++)) >= 32 && b <= 126) {
            buffer.append((char)b);
        }
        return buffer.toString().trim();
    }

    public String readAsciiString(long index, int length) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            byte b = this.provider.readByte(index++);
            buffer.append((char)(b & 0xFF));
        }
        return buffer.toString().trim();
    }

    public String readUnicodeString(long index) throws IOException {
        StringBuffer buffer = new StringBuffer();
        char c = '\u0000';
        int i = 0;
        while ((long)i < this.length()) {
            c = (char)(this.provider.readByte(index++) & 0xFF);
            if ((c = (char)(c + (char)((this.provider.readByte(index++) & 0xFF) << 8))) == '\u0000') break;
            buffer.append(c);
            i += 2;
        }
        return buffer.toString().trim();
    }

    public String readUnicodeString(long index, int length) throws IOException {
        StringBuffer buffer = new StringBuffer();
        char c = '\u0000';
        for (int i = 0; i < length * 2; i += 2) {
            c = (char)(this.provider.readByte(index++) & 0xFF);
            c = (char)(c + (char)((this.provider.readByte(index++) & 0xFF) << 8));
            buffer.append(c);
        }
        return buffer.toString().trim();
    }

    public byte readByte(long index) throws IOException {
        return this.provider.readByte(index);
    }

    public byte readByte(long index, byte minClamp, byte maxClamp, Byte ... exceptions) throws IOException {
        byte b = this.readByte(index);
        return this.clampByte(b, minClamp, maxClamp, exceptions);
    }

    public short readShort(long index) throws IOException {
        byte[] bytes = this.provider.readBytes(index, 2L);
        return this.converter.getShort(bytes);
    }

    public short readShort(long index, short minClamp, short maxClamp, Short ... exceptions) throws IOException {
        short s = this.readShort(index);
        return this.clampShort(s, minClamp, maxClamp, exceptions);
    }

    public int readInt(long index) throws IOException {
        byte[] bytes = this.provider.readBytes(index, 4L);
        return this.converter.getInt(bytes);
    }

    public int readInt(long index, int minClamp, int maxClamp, Integer ... exceptions) throws IOException {
        int i = this.readInt(index);
        return this.clampInt(i, minClamp, maxClamp, exceptions);
    }

    public long readLong(long index) throws IOException {
        byte[] bytes = this.provider.readBytes(index, 8L);
        return this.converter.getLong(bytes);
    }

    public long readLong(long index, long minClamp, long maxClamp, Long ... exceptions) throws IOException {
        long l = this.readLong(index);
        return this.clampLong(l, minClamp, maxClamp, exceptions);
    }

    public byte[] readByteArray(long index, int nElements) throws IOException {
        if (nElements < 0) {
            throw new IOException("Invalid number of elements specified: " + nElements);
        }
        return this.provider.readBytes(index, nElements);
    }

    public byte[] readByteArray(long index, int nElements, byte minClamp, byte maxClamp, Byte ... exceptions) throws IOException {
        byte[] array = this.readByteArray(index, nElements);
        for (int ii = 0; ii < array.length; ++ii) {
            array[ii] = this.clampByte(array[ii], minClamp, maxClamp, exceptions);
        }
        return array;
    }

    public short[] readShortArray(long index, int nElements) throws IOException {
        if (nElements < 0) {
            throw new IOException("Invalid number of elements specified: " + nElements);
        }
        short[] arr = new short[nElements];
        for (int i = 0; i < nElements; ++i) {
            arr[i] = this.readShort(index);
            index += 2L;
        }
        return arr;
    }

    public short[] readShortArray(long index, int nElements, short minClamp, short maxClamp, Short ... exceptions) throws IOException {
        short[] array = this.readShortArray(index, nElements);
        for (int ii = 0; ii < array.length; ++ii) {
            array[ii] = this.clampShort(array[ii], minClamp, maxClamp, exceptions);
        }
        return array;
    }

    public int[] readIntArray(long index, int nElements) throws IOException {
        if (nElements < 0) {
            throw new IOException("Invalid number of elements specified: " + nElements);
        }
        int[] arr = new int[nElements];
        for (int i = 0; i < nElements; ++i) {
            arr[i] = this.readInt(index);
            index += 4L;
        }
        return arr;
    }

    public int[] readIntArray(long index, int nElements, int minClamp, int maxClamp, Integer ... exceptions) throws IOException {
        int[] array = this.readIntArray(index, nElements);
        for (int ii = 0; ii < array.length; ++ii) {
            array[ii] = this.clampInt(array[ii], minClamp, maxClamp, exceptions);
        }
        return array;
    }

    public long[] readLongArray(long index, int nElements) throws IOException {
        if (nElements < 0) {
            throw new IOException("Invalid number of elements specified: " + nElements);
        }
        long[] arr = new long[nElements];
        for (int i = 0; i < nElements; ++i) {
            arr[i] = this.readLong(index);
            index += 8L;
        }
        return arr;
    }

    public long[] readLongArray(long index, int nElements, long minClamp, long maxClamp, Long ... exceptions) throws IOException {
        long[] array = this.readLongArray(index, nElements);
        for (int ii = 0; ii < array.length; ++ii) {
            array[ii] = this.clampLong(array[ii], minClamp, maxClamp, exceptions);
        }
        return array;
    }

    public String[] readAsciiStringArray(long index, int nElements) throws IOException {
        if (nElements < 0) {
            throw new IOException("Invalid number of elements specified: " + nElements);
        }
        String[] arr = new String[nElements];
        for (int i = 0; i < nElements; ++i) {
            String tmp;
            arr[i] = tmp = this.readAsciiString(index);
            index += (long)(tmp == null ? 1 : tmp.length());
        }
        return arr;
    }

    public void writeByte(long index, byte value) throws IOException {
        this.provider.writeByte(index, value);
    }

    public void writeShort(long index, short value) throws IOException {
        byte[] bytes = this.converter.getBytes(value);
        this.provider.writeBytes(index, bytes);
    }

    public void writeInt(long index, int value) throws IOException {
        byte[] bytes = this.converter.getBytes(value);
        this.provider.writeBytes(index, bytes);
    }

    public void writeLong(long index, long value) throws IOException {
        byte[] bytes = this.converter.getBytes(value);
        this.provider.writeBytes(index, bytes);
    }

    public GByteProvider getByteProvider() {
        return this.provider;
    }

    protected byte clampByte(byte b, byte minClamp, byte maxClamp, Byte ... exceptions) {
        if (maxClamp < minClamp) {
            throw new IllegalArgumentException("maxClamp < minClamp not allowed");
        }
        if (exceptions != null && exceptions.length % 2 != 0) {
            throw new IllegalArgumentException("exceptions must be pairs of (flag, replacement) bytes");
        }
        boolean clamp = true;
        if (exceptions != null) {
            for (int ii = 0; ii < exceptions.length; ii += 2) {
                if (b != exceptions[ii]) continue;
                b = exceptions[ii + 1];
                clamp = false;
                break;
            }
        }
        if (clamp) {
            if (b < minClamp) {
                b = minClamp;
            } else if (b > maxClamp) {
                b = maxClamp;
            }
        }
        return b;
    }

    protected short clampShort(short s, short minClamp, short maxClamp, Short ... exceptions) {
        if (maxClamp < minClamp) {
            throw new IllegalArgumentException("maxClamp < minClamp not allowed");
        }
        if (exceptions != null && exceptions.length % 2 != 0) {
            throw new IllegalArgumentException("exceptions must be pairs of (flag, replacement) shorts");
        }
        boolean clamp = true;
        if (exceptions != null) {
            for (int ii = 0; ii < exceptions.length; ii += 2) {
                if (s != exceptions[ii]) continue;
                s = exceptions[ii + 1];
                clamp = false;
                break;
            }
        }
        if (clamp) {
            if (s < minClamp) {
                s = minClamp;
            } else if (s > maxClamp) {
                s = maxClamp;
            }
        }
        return s;
    }

    protected int clampInt(int i, int minClamp, int maxClamp, Integer ... exceptions) {
        if (maxClamp < minClamp) {
            throw new IllegalArgumentException("maxClamp < minClamp not allowed");
        }
        if (exceptions != null && exceptions.length % 2 != 0) {
            throw new IllegalArgumentException("exceptions must be pairs of (flag, replacement) ints");
        }
        boolean clamp = true;
        if (exceptions != null) {
            for (int ii = 0; ii < exceptions.length; ii += 2) {
                if (i != exceptions[ii]) continue;
                i = exceptions[ii + 1];
                clamp = false;
                break;
            }
        }
        if (clamp) {
            if (i < minClamp) {
                i = minClamp;
            } else if (i > maxClamp) {
                i = maxClamp;
            }
        }
        return i;
    }

    protected long clampLong(long l, long minClamp, long maxClamp, Long ... exceptions) {
        if (maxClamp < minClamp) {
            throw new IllegalArgumentException("maxClamp < minClamp not allowed");
        }
        if (exceptions != null && exceptions.length % 2 != 0) {
            throw new IllegalArgumentException("exceptions must be pairs of (flag, replacement) longs");
        }
        boolean clamp = true;
        if (exceptions != null) {
            for (int ii = 0; ii < exceptions.length; ii += 2) {
                if (l != exceptions[ii]) continue;
                l = exceptions[ii + 1];
                clamp = false;
                break;
            }
        }
        if (clamp) {
            if (l < minClamp) {
                l = minClamp;
            } else if (l > maxClamp) {
                l = maxClamp;
            }
        }
        return l;
    }
}

