/*
 * Decompiled with CFR 0.152.
 */
package generic.lsh;

import generic.lsh.vector.HashEntry;

public class Partition {
    private static final int FNV_32_BIT_OFFSET_BASIS = -2128831035;
    private static final int FNV_32_BIT_PRIME = 16777619;

    private Partition() {
    }

    private static boolean partition(int identity, int value) {
        int hash = -2128831035;
        int blender = value;
        hash ^= blender & 0xFF;
        hash *= 16777619;
        hash ^= (blender >>>= 8) & 0xFF;
        hash *= 16777619;
        hash ^= (blender >>>= 8) & 0xFF;
        hash *= 16777619;
        hash ^= (blender >>>= 8) & 0xFF;
        hash *= 16777619;
        blender = identity;
        hash ^= blender & 0xFF;
        hash *= 16777619;
        hash ^= (blender >>>= 8) & 0xFF;
        hash *= 16777619;
        hash ^= (blender >>>= 8) & 0xFF;
        hash *= 16777619;
        hash ^= (blender >>>= 8) & 0xFF;
        int bitCount = Integer.bitCount(hash *= 16777619);
        return bitCount % 2 == 0;
    }

    private static int partition(int identity, HashEntry[] values) {
        float total = 0.0f;
        for (int i = 0; i < values.length; ++i) {
            HashEntry entry = values[i];
            total = Partition.partition(identity, entry.getHash()) ? (float)((double)total + entry.getCoeff()) : (float)((double)total - entry.getCoeff());
        }
        return total < 0.0f ? 0 : 1;
    }

    public static int hash(int[] partitionIdentities, HashEntry[] values) {
        int result = 0;
        int bit = 1;
        for (int identity : partitionIdentities) {
            if (Partition.partition(identity, values) == 1) {
                result |= bit;
            }
            bit <<= 1;
        }
        return result;
    }
}

