/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

public enum Architecture {
    X86("x86", "i386"),
    X86_64("x86_64", "amd64"),
    POWERPC("ppc"),
    POWERPC_64("ppc64"),
    ARM_64("aarch64", "arm64"),
    RISCV_64("riscv64"),
    UNKNOWN("Unknown Architecture");

    static final Architecture CURRENT_ARCHITECTURE;
    private String[] supportedArchitectureNames;
    private String architectureName = System.getProperty("os.arch");

    private Architecture(String ... architectures) {
        this.supportedArchitectureNames = architectures;
    }

    private static Architecture findCurrentArchitecture() {
        String architectureNameProperty = System.getProperty("os.arch");
        for (Architecture architecture : Architecture.values()) {
            if (!architecture.supportsArchitecture(architectureNameProperty)) continue;
            return architecture;
        }
        return UNKNOWN;
    }

    private boolean supportsArchitecture(String architecture) {
        for (String string : this.supportedArchitectureNames) {
            if (!string.equalsIgnoreCase(architecture)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name() + "(" + this.architectureName + ")";
    }

    static {
        CURRENT_ARCHITECTURE = Architecture.findCurrentArchitecture();
    }
}

