/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.annotproc;

import ghidra.util.database.annotproc.ValidationContext;
import java.lang.annotation.Annotation;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;

public class AbstractDBAnnotationValidator {
    protected final ValidationContext ctx;

    public AbstractDBAnnotationValidator(ValidationContext ctx) {
        this.ctx = ctx;
    }

    protected void checkEnclosingType(Class<? extends Annotation> annotType, VariableElement field, TypeElement type) {
        if (type.getKind() != ElementKind.CLASS) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s can only be applied to fields in a class", annotType.getSimpleName()), field);
        } else if (!this.ctx.isSubclass(type, this.ctx.DB_ANNOTATED_OBJECT_ELEM)) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s can only be applied within a subclass of %s", annotType.getSimpleName(), this.ctx.DB_ANNOTATED_OBJECT_ELEM), field);
        }
    }
}

