/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.correlate.HashedFunctionAddressCorrelation;
import ghidra.program.model.listing.Function;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.AddressCorrelation;
import ghidra.program.util.AddressCorrelationRange;
import ghidra.program.util.DummyListingAddressCorrelation;
import ghidra.program.util.ListingAddressCorrelation;
import ghidra.util.Msg;
import ghidra.util.datastruct.Duo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class VTHashedFunctionAddressCorrelation
implements AddressCorrelation {
    public static final String NAME = "VTHashedFunctionAddressCorrelation";
    private final Function sourceFunction;
    private final Function destinationFunction;
    private ListingAddressCorrelation addressCorrelation;

    public VTHashedFunctionAddressCorrelation(Function sourceFunction, Function destinationFunction) {
        this.sourceFunction = sourceFunction;
        this.destinationFunction = destinationFunction;
        this.addressCorrelation = null;
    }

    public String getName() {
        return NAME;
    }

    public AddressCorrelationRange getCorrelatedDestinationRange(Address sourceAddress, TaskMonitor monitor) throws CancelledException {
        try {
            this.initializeCorrelation(monitor);
            Address destinationAddress = this.addressCorrelation.getAddress(Duo.Side.RIGHT, sourceAddress);
            if (destinationAddress == null) {
                return null;
            }
            AddressRangeImpl range = new AddressRangeImpl(destinationAddress, destinationAddress);
            return new AddressCorrelationRange((AddressRange)range, this.getName());
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)"Could not create HashedFunctionAddressCorrelation", (Throwable)e);
            return null;
        }
    }

    private void initializeCorrelation(TaskMonitor monitor) throws CancelledException, MemoryAccessException {
        if (this.addressCorrelation != null) {
            return;
        }
        this.addressCorrelation = this.sourceFunction != null && this.destinationFunction != null ? new HashedFunctionAddressCorrelation(this.sourceFunction, this.destinationFunction, monitor) : new DummyListingAddressCorrelation();
    }
}

