/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.add;

import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.feature.vt.api.impl.VTProgramCorrelatorInfo;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.wizard.add.VTProgramTableCorrelatorModel;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import utility.function.Callback;

public class CorrelatorChooserPanel
extends JPanel {
    private VTProgramTableCorrelatorModel model;
    private GhidraTable table;
    private Callback statusChangedCallback;

    CorrelatorChooserPanel(VTSession session, Callback statusChangedCallback) {
        this.setLayout(new BorderLayout());
        this.table = this.createBasicTable(this.getPreviouslyRunAlgorithms(session));
        this.add((Component)new JScrollPane((Component)this.table), "Center");
        this.statusChangedCallback = statusChangedCallback;
    }

    private GhidraTable createBasicTable(Set<String> previouslyRunCorrelators) {
        this.model = new VTProgramTableCorrelatorModel(this, previouslyRunCorrelators);
        this.table = new GhidraTable((TableModel)((Object)this.model));
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setColumnHeaderPopupEnabled(false);
        this.table.setDefaultRenderer(Icon.class, (TableCellRenderer)((Object)new PreviouslyRunColumnRenderer()));
        this.setColumnSizes();
        return this.table;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(1000, 400);
    }

    void notifyStatusChanged() {
        this.statusChangedCallback.call();
    }

    private void setColumnSizes() {
        TableColumnModel columnModel = this.table.getColumnModel();
        int width = 0;
        for (int col = 0; col < columnModel.getColumnCount(); ++col) {
            TableColumn column = columnModel.getColumn(col);
            if ("Select".equals(column.getHeaderValue())) {
                width = 30;
                column.setMinWidth(width);
            } else if ("Name".equals(column.getHeaderValue())) {
                width = 250;
            } else if ("Previous".equals(column.getHeaderValue())) {
                width = 30;
                column.setMinWidth(width);
            } else if ("Description".equals(column.getHeaderValue())) {
                width = 650;
            }
            column.setPreferredWidth(width);
        }
    }

    private Set<String> getPreviouslyRunAlgorithms(VTSession session) {
        HashSet<String> set = new HashSet<String>();
        List<VTMatchSet> matchSets = session.getMatchSets();
        for (VTMatchSet vtMatchSet : matchSets) {
            VTProgramCorrelatorInfo info = vtMatchSet.getProgramCorrelatorInfo();
            set.add(info.getName());
        }
        return set;
    }

    public List<VTProgramCorrelatorFactory> getSelectedCorrelators() {
        return this.model.getSelectedFactories();
    }

    private class PreviouslyRunColumnRenderer
    extends GTableCellRenderer {
        PreviouslyRunColumnRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            renderer.setIcon((Icon)value);
            renderer.setText(null);
            renderer.setToolTipText(value == null ? null : "Correlator has already been run at least once.");
            return renderer;
        }
    }
}

