/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data.ISF;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ISF.AbstractIsfWriter;
import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.data.ISF.IsfSetting;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractIsfObject
implements IsfObject {
    @AbstractIsfWriter.Exclude
    public String name;
    @AbstractIsfWriter.Exclude
    public String location;
    @AbstractIsfWriter.Exclude
    public List<IsfSetting> settings;

    public AbstractIsfObject(DataType dt) {
        if (dt != null) {
            this.name = dt.getName();
            this.location = dt.getCategoryPath().getPath();
            Settings defaultSettings = dt.getDefaultSettings();
            this.processSettings(dt, defaultSettings);
        }
    }

    protected void processSettings(DataType dt, Settings defaultSettings) {
        SettingsDefinition[] settingsDefinitions;
        for (SettingsDefinition def : settingsDefinitions = dt.getSettingsDefinitions()) {
            String[] names;
            if (!def.hasValue(defaultSettings)) continue;
            this.settings = new ArrayList<IsfSetting>();
            for (String n : names = defaultSettings.getNames()) {
                Object value = defaultSettings.getValue(n);
                if (value == null) continue;
                IsfSetting setting = new IsfSetting(n, value);
                this.settings.add(setting);
            }
        }
    }
}

