/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import ghidra.app.decompiler.ClangToken;
import ghidra.features.codecompare.decompile.CodeDiffFieldPanelCoordinator;
import ghidra.features.codecompare.decompile.DecompileDataDiff;
import ghidra.features.codecompare.decompile.DiffClangHighlightController;
import ghidra.features.codecompare.graphanalysis.TokenBin;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashSet;

public class DetermineDecompilerDifferencesTask
extends Task {
    private boolean matchConstantsExactly;
    private DiffClangHighlightController leftHighlightController;
    private DiffClangHighlightController rightHighlightController;
    private DecompileDataDiff decompileDataDiff;
    private CodeDiffFieldPanelCoordinator decompilerFieldPanelCoordinator;

    public DetermineDecompilerDifferencesTask(DecompileDataDiff decompileDataDiff, boolean matchConstantsExactly, DiffClangHighlightController leftHighlightController, DiffClangHighlightController rightHighlightController, CodeDiffFieldPanelCoordinator decompilerFieldPanelCoordinator) {
        super("Mapping C Tokens Between Functions", true, true, true);
        this.decompileDataDiff = decompileDataDiff;
        this.matchConstantsExactly = matchConstantsExactly;
        this.leftHighlightController = leftHighlightController;
        this.rightHighlightController = rightHighlightController;
        this.decompilerFieldPanelCoordinator = decompilerFieldPanelCoordinator;
    }

    public void run(TaskMonitor monitor) {
        monitor.setMessage(this.matchConstantsExactly ? "Function Token Mapping By Matching Constants Exactly..." : "Function Token Mapping WITHOUT Matching Constants Exactly...");
        try {
            this.determineDifferences(monitor);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    synchronized void determineDifferences(TaskMonitor monitor) throws CancelledException {
        ArrayList<TokenBin> highBins = this.decompileDataDiff.getTokenMap(this.matchConstantsExactly, monitor);
        HashSet<ClangToken> leftHighlightTokenSet = this.decompileDataDiff.getLeftHighlightTokenSet(this.matchConstantsExactly, monitor);
        HashSet<ClangToken> rightHighlightTokenSet = this.decompileDataDiff.getRightHighlightTokenSet(this.matchConstantsExactly, monitor);
        this.leftHighlightController.setDiffHighlights(highBins, leftHighlightTokenSet);
        this.rightHighlightController.setDiffHighlights(highBins, rightHighlightTokenSet);
        this.decompilerFieldPanelCoordinator.replaceDecompileDataDiff(this.decompileDataDiff, this.matchConstantsExactly, monitor);
    }
}

