/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableSortState;
import docking.widgets.table.TableSortStateEditor;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TableColumnDescriptor<ROW_TYPE> {
    private List<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();

    public List<DynamicTableColumn<ROW_TYPE, ?, ?>> getAllColumns() {
        ArrayList list = new ArrayList();
        for (TableColumnInfo info : this.columns) {
            list.add(info.column);
        }
        return list;
    }

    public List<DynamicTableColumn<ROW_TYPE, ?, ?>> getDefaultVisibleColumns() {
        ArrayList list = new ArrayList();
        for (TableColumnInfo info : this.columns) {
            if (!info.isVisible) continue;
            list.add(info.column);
        }
        return list;
    }

    public TableSortState getDefaultTableSortState(DynamicColumnTableModel<ROW_TYPE> model) {
        TableSortStateEditor editor = new TableSortStateEditor();
        ArrayList<TableColumnInfo> sortedColumns = new ArrayList<TableColumnInfo>(this.columns);
        Collections.sort(sortedColumns);
        for (TableColumnInfo info : sortedColumns) {
            if (info.sortIndex == -1) continue;
            int columnIndex = model.getColumnIndex(info.column);
            editor.addSortedColumn(columnIndex);
            if (info.ascending) continue;
            editor.flipColumnSortDirection(columnIndex);
        }
        return editor.createTableSortState();
    }

    public void setVisible(String columnName, boolean visible) {
        TableColumnInfo info = this.getColumn(columnName);
        if (info == null) {
            Msg.debug((Object)this, (Object)"Unable to change visibility state of column '%s'".formatted(columnName));
            return;
        }
        if (visible) {
            info.isVisible = true;
        } else {
            int index = this.columns.indexOf(info);
            this.columns.set(index, new TableColumnInfo(this, info.column));
        }
    }

    private TableColumnInfo getColumn(String name) {
        for (TableColumnInfo info : this.columns) {
            String columnName = info.column.getColumnName();
            if (!columnName.equals(name)) continue;
            return info;
        }
        return null;
    }

    public void addHiddenColumn(DynamicTableColumn<ROW_TYPE, ?, ?> column) {
        this.columns.add(new TableColumnInfo(this, column));
    }

    public void addVisibleColumn(DynamicTableColumn<ROW_TYPE, ?, ?> column) {
        this.addVisibleColumn(column, -1, true);
    }

    public void addVisibleColumn(DynamicTableColumn<ROW_TYPE, ?, ?> column, int sortOrdinal, boolean ascending) {
        this.columns.add(new TableColumnInfo(this, column, true, sortOrdinal, ascending));
    }

    private class TableColumnInfo
    implements Comparable<TableColumnInfo> {
        private DynamicTableColumn<ROW_TYPE, ?, ?> column;
        private boolean isVisible = false;
        private int sortIndex = -1;
        private boolean ascending = true;

        TableColumnInfo(TableColumnDescriptor tableColumnDescriptor, DynamicTableColumn<ROW_TYPE, ?, ?> column) {
            this.column = column;
        }

        TableColumnInfo(TableColumnDescriptor tableColumnDescriptor, DynamicTableColumn<ROW_TYPE, ?, ?> column, boolean isVisible, int sortIndex, boolean ascending) {
            this.column = column;
            this.isVisible = isVisible;
            this.sortIndex = sortIndex;
            this.ascending = ascending;
        }

        @Override
        public int compareTo(TableColumnInfo o) {
            return this.sortIndex - o.sortIndex;
        }
    }
}

