/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.jad;

import ghidra.file.jad.Radix;
import ghidra.framework.Application;
import ghidra.framework.Platform;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class JadProcessWrapper {
    public boolean shouldDecompileDeadCode = true;
    public boolean shouldInsertNewLineBeforeOpeningBrace = false;
    public boolean shouldOutputFieldsBeforeMethods = true;
    public boolean shouldOutputSpaceBetweenKeywords = true;
    public boolean shouldOverwriteOutputFiles = true;
    public boolean shouldRestoreDirectoryStructure = false;
    public boolean shouldUseTabsForIndentation = true;
    public boolean verbose = false;
    public Radix radix = Radix.SIXTEEN;
    public String outputFileExtension = "java";
    public File outputDirectory;
    private File file;

    public JadProcessWrapper(File file) {
        this.file = file;
    }

    public File getInputDirectory() {
        return this.file;
    }

    public File getWorkingDirectory() {
        if (this.file.isDirectory()) {
            return this.file;
        }
        return this.file.getParentFile();
    }

    public String[] getCommands() throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(JadProcessWrapper.getJadPath());
        if (this.shouldDecompileDeadCode) {
            list.add("-dead");
        }
        if (this.shouldOutputFieldsBeforeMethods) {
            list.add("-ff");
        }
        if (!this.shouldInsertNewLineBeforeOpeningBrace) {
            list.add("-nonlb");
        }
        if (this.shouldOverwriteOutputFiles) {
            list.add("-o");
        }
        if (this.shouldRestoreDirectoryStructure) {
            list.add("-r");
        }
        list.add("-radix" + this.radix.toString());
        if (this.outputFileExtension != null) {
            list.add("-s" + this.outputFileExtension);
        }
        if (this.shouldOutputSpaceBetweenKeywords) {
            list.add("-space");
        }
        if (this.shouldUseTabsForIndentation) {
            list.add("-t");
        }
        if (this.verbose) {
            list.add("-v");
        }
        if (this.file.isDirectory()) {
            list.add(this.file.getAbsolutePath() + "/*.class");
        } else {
            list.add(this.file.getAbsolutePath());
        }
        return list.toArray(new String[list.size()]);
    }

    private static String getJadPath() throws IOException {
        File jadExecutableFile = Application.getOSFile((String)(Platform.CURRENT_PLATFORM == Platform.WIN_X86_32 || Platform.CURRENT_PLATFORM == Platform.WIN_X86_64 ? "jad.exe" : "jad"));
        String jadPath = jadExecutableFile.getAbsolutePath();
        return jadPath;
    }

    public static boolean isJadPresent() {
        return JADPresentHolder.JAD_PRESENT;
    }

    static class JADPresentHolder {
        static final boolean JAD_PRESENT = JADPresentHolder.isJadPresent();

        JADPresentHolder() {
        }

        static boolean isJadPresent() {
            try {
                String path = JadProcessWrapper.getJadPath();
                if (path != null) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }
}

