/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.emulator;

import ghidra.app.emulator.memory.EmulatorLoadData;
import ghidra.pcode.memstate.MemoryFaultHandler;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;

public interface EmulatorConfiguration {

	Language getLanguage();

	EmulatorLoadData getLoadData();

	MemoryFaultHandler getMemoryFaultHandler();

	default boolean isWriteBackEnabled() {
		return false;
	}

	default int getPreferredMemoryPageSize() {
		return 0x1000;
	}

	default String getProgramCounterName() {
		Language lang = getLanguage();
		Register pcReg = lang.getProgramCounter();
		if (pcReg == null) {
			throw new IllegalStateException(
				"Language has not defined Program Counter Register: " + lang.getLanguageID());
		}
		return pcReg.getName();
	}
}
