from __future__ import annotations
import collections.abc
import datetime
import typing
from warnings import deprecated # type: ignore

import jpype # type: ignore
import jpype.protocol # type: ignore

import ghidra.app.services
import ghidra.app.util.cparser.CPP
import ghidra.framework.plugintool
import ghidra.program.model.data
import ghidra.program.model.listing
import ghidra.util.task
import java.io # type: ignore
import java.lang # type: ignore
import java.util # type: ignore


class CParserConstants(java.lang.Object):
    """
    Token literal values and constants.
    Generated by org.javacc.parser.OtherFilesGen#start()
    """

    class_: typing.ClassVar[java.lang.Class]
    EOF: typing.Final = 0
    """
    End of File.
    """

    INTEGER_LITERAL: typing.Final = 10
    """
    RegularExpression Id.
    """

    DECIMAL_LITERAL: typing.Final = 11
    """
    RegularExpression Id.
    """

    HEX_LITERAL: typing.Final = 12
    """
    RegularExpression Id.
    """

    OCTAL_LITERAL: typing.Final = 13
    """
    RegularExpression Id.
    """

    FLOATING_POINT_LITERAL: typing.Final = 14
    """
    RegularExpression Id.
    """

    EXPONENT: typing.Final = 15
    """
    RegularExpression Id.
    """

    CHARACTER_LITERAL: typing.Final = 16
    """
    RegularExpression Id.
    """

    STRING_LITERAL: typing.Final = 17
    """
    RegularExpression Id.
    """

    CONTINUE: typing.Final = 18
    """
    RegularExpression Id.
    """

    VOLATILE: typing.Final = 19
    """
    RegularExpression Id.
    """

    REGISTER: typing.Final = 20
    """
    RegularExpression Id.
    """

    UNSIGNED: typing.Final = 21
    """
    RegularExpression Id.
    """

    TYPEDEF: typing.Final = 22
    """
    RegularExpression Id.
    """

    DFLT: typing.Final = 23
    """
    RegularExpression Id.
    """

    DOUBLE: typing.Final = 24
    """
    RegularExpression Id.
    """

    SIZEOF: typing.Final = 25
    """
    RegularExpression Id.
    """

    SWITCH: typing.Final = 26
    """
    RegularExpression Id.
    """

    RETURN: typing.Final = 27
    """
    RegularExpression Id.
    """

    EXTERN: typing.Final = 28
    """
    RegularExpression Id.
    """

    QUOTE_C: typing.Final = 29
    """
    RegularExpression Id.
    """

    STRUCT: typing.Final = 30
    """
    RegularExpression Id.
    """

    STATIC: typing.Final = 31
    """
    RegularExpression Id.
    """

    THREADLOCAL: typing.Final = 32
    """
    RegularExpression Id.
    """

    SIGNED: typing.Final = 33
    """
    RegularExpression Id.
    """

    WHILE: typing.Final = 34
    """
    RegularExpression Id.
    """

    BREAK: typing.Final = 35
    """
    RegularExpression Id.
    """

    UNION: typing.Final = 36
    """
    RegularExpression Id.
    """

    CONST: typing.Final = 37
    """
    RegularExpression Id.
    """

    DECLSPEC: typing.Final = 38
    """
    RegularExpression Id.
    """

    PRAGMA: typing.Final = 39
    """
    RegularExpression Id.
    """

    PRAGMA_FUNC: typing.Final = 40
    """
    RegularExpression Id.
    """

    READABLETO: typing.Final = 41
    """
    RegularExpression Id.
    """

    CDECL: typing.Final = 42
    """
    RegularExpression Id.
    """

    STDCALL: typing.Final = 43
    """
    RegularExpression Id.
    """

    FASTCALL: typing.Final = 44
    """
    RegularExpression Id.
    """

    VECTORCALL: typing.Final = 45
    """
    RegularExpression Id.
    """

    RUSTCALL: typing.Final = 46
    """
    RegularExpression Id.
    """

    PASCALCALL: typing.Final = 47
    """
    RegularExpression Id.
    """

    NORETURN: typing.Final = 48
    """
    RegularExpression Id.
    """

    ALIGNAS: typing.Final = 49
    """
    RegularExpression Id.
    """

    ALIGNOF: typing.Final = 50
    """
    RegularExpression Id.
    """

    UNALIGNED: typing.Final = 51
    """
    RegularExpression Id.
    """

    PACKED: typing.Final = 52
    """
    RegularExpression Id.
    """

    ATTRIBUTE: typing.Final = 53
    """
    RegularExpression Id.
    """

    EXTENSION: typing.Final = 54
    """
    RegularExpression Id.
    """

    RESTRICT: typing.Final = 55
    """
    RegularExpression Id.
    """

    ASM: typing.Final = 56
    """
    RegularExpression Id.
    """

    INLINE: typing.Final = 57
    """
    RegularExpression Id.
    """

    STATICASSERT: typing.Final = 58
    """
    RegularExpression Id.
    """

    FLOAT: typing.Final = 59
    """
    RegularExpression Id.
    """

    SHORT: typing.Final = 60
    """
    RegularExpression Id.
    """

    ELSE: typing.Final = 61
    """
    RegularExpression Id.
    """

    CASE: typing.Final = 62
    """
    RegularExpression Id.
    """

    LONG: typing.Final = 63
    """
    RegularExpression Id.
    """

    INT8: typing.Final = 64
    """
    RegularExpression Id.
    """

    INT16: typing.Final = 65
    """
    RegularExpression Id.
    """

    INT32: typing.Final = 66
    """
    RegularExpression Id.
    """

    INT64: typing.Final = 67
    """
    RegularExpression Id.
    """

    PTR64: typing.Final = 68
    """
    RegularExpression Id.
    """

    PTR32: typing.Final = 69
    """
    RegularExpression Id.
    """

    BOOL: typing.Final = 70
    """
    RegularExpression Id.
    """

    W64: typing.Final = 71
    """
    RegularExpression Id.
    """

    ENUM: typing.Final = 72
    """
    RegularExpression Id.
    """

    AUTO: typing.Final = 73
    """
    RegularExpression Id.
    """

    VOID: typing.Final = 74
    """
    RegularExpression Id.
    """

    CHAR: typing.Final = 75
    """
    RegularExpression Id.
    """

    GOTO: typing.Final = 76
    """
    RegularExpression Id.
    """

    NEAR: typing.Final = 77
    """
    RegularExpression Id.
    """

    FAR: typing.Final = 78
    """
    RegularExpression Id.
    """

    FOR: typing.Final = 79
    """
    RegularExpression Id.
    """

    INT: typing.Final = 80
    """
    RegularExpression Id.
    """

    IF: typing.Final = 81
    """
    RegularExpression Id.
    """

    DO: typing.Final = 82
    """
    RegularExpression Id.
    """

    PROTOCOL: typing.Final = 83
    """
    RegularExpression Id.
    """

    INTERFACE: typing.Final = 84
    """
    RegularExpression Id.
    """

    LINE: typing.Final = 85
    """
    RegularExpression Id.
    """

    LINEALT: typing.Final = 86
    """
    RegularExpression Id.
    """

    IDENTIFIER: typing.Final = 87
    """
    RegularExpression Id.
    """

    LETTER: typing.Final = 88
    """
    RegularExpression Id.
    """

    DIGIT: typing.Final = 89
    """
    RegularExpression Id.
    """

    ASMBLOCKB: typing.Final = 92
    """
    RegularExpression Id.
    """

    ASMBLOCKP: typing.Final = 93
    """
    RegularExpression Id.
    """

    ASM_SEMI: typing.Final = 94
    """
    RegularExpression Id.
    """

    PATH_LITERAL: typing.Final = 99
    """
    RegularExpression Id.
    """

    LINENUMBER_LITERAL: typing.Final = 100
    """
    RegularExpression Id.
    """

    PIDENTIFIER: typing.Final = 109
    """
    RegularExpression Id.
    """

    PLETTER: typing.Final = 110
    """
    RegularExpression Id.
    """

    PDIGIT: typing.Final = 111
    """
    RegularExpression Id.
    """

    POPEN: typing.Final = 112
    """
    RegularExpression Id.
    """

    PCLOSE: typing.Final = 113
    """
    RegularExpression Id.
    """

    PMINUS: typing.Final = 114
    """
    RegularExpression Id.
    """

    PPLUS: typing.Final = 115
    """
    RegularExpression Id.
    """

    PSTAR: typing.Final = 116
    """
    RegularExpression Id.
    """

    PCOLON: typing.Final = 117
    """
    RegularExpression Id.
    """

    PCOMMA: typing.Final = 118
    """
    RegularExpression Id.
    """

    PINTEGER_LITERAL: typing.Final = 119
    """
    RegularExpression Id.
    """

    PDECIMAL_LITERAL: typing.Final = 120
    """
    RegularExpression Id.
    """

    PHEX_LITERAL: typing.Final = 121
    """
    RegularExpression Id.
    """

    POCTAL_LITERAL: typing.Final = 122
    """
    RegularExpression Id.
    """

    PSTRING_LITERAL: typing.Final = 123
    """
    RegularExpression Id.
    """

    OBJC_IGNORE: typing.Final = 129
    """
    RegularExpression Id.
    """

    OBJC_IDENTIFIER: typing.Final = 130
    """
    RegularExpression Id.
    """

    OBJC_LETTER: typing.Final = 131
    """
    RegularExpression Id.
    """

    OBJC_DIGIT: typing.Final = 132
    """
    RegularExpression Id.
    """

    OBJC_SEMI: typing.Final = 133
    """
    RegularExpression Id.
    """

    OBJC2_IGNORE: typing.Final = 144
    """
    RegularExpression Id.
    """

    OBJC2_END: typing.Final = 145
    """
    RegularExpression Id.
    """

    DEFAULT: typing.Final = 0
    """
    Lexical state.
    """

    ASMBLOCK: typing.Final = 1
    """
    Lexical state.
    """

    LINEBLOCK: typing.Final = 2
    """
    Lexical state.
    """

    PRAGMALINE: typing.Final = 3
    """
    Lexical state.
    """

    OBJC: typing.Final = 4
    """
    Lexical state.
    """

    OBJC2: typing.Final = 5
    """
    Lexical state.
    """

    tokenImage: typing.Final[jpype.JArray[java.lang.String]]
    """
    Literal token values.
    """



class CompositeHandler(java.lang.Object):
    """
    Used by the CParser to handle fields added to structures(composites).
    Currently only bitfields are handled specially.
     
    NOTE: when bitfield handling is added directly to structures, this class may
    no longer be necessary.
    """

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self, parent: ghidra.program.model.data.Composite):
        ...

    def add(self, dec: Declaration):
        ...

    def getComposite(self) -> ghidra.program.model.data.Composite:
        ...

    @property
    def composite(self) -> ghidra.program.model.data.Composite:
        ...


class Token(java.io.Serializable):
    """
    Describes the input token stream.
    """

    class_: typing.ClassVar[java.lang.Class]
    kind: jpype.JInt
    """
    An integer that describes the kind of this token.  This numbering
    system is determined by JavaCCParser, and a table of these numbers is
    stored in the file ...Constants.java.
    """

    beginLine: jpype.JInt
    """
    The line number of the first character of this Token.
    """

    beginColumn: jpype.JInt
    """
    The column number of the first character of this Token.
    """

    endLine: jpype.JInt
    """
    The line number of the last character of this Token.
    """

    endColumn: jpype.JInt
    """
    The column number of the last character of this Token.
    """

    image: java.lang.String
    """
    The string image of the token.
    """

    next: Token
    """
    A reference to the next regular (non-special) token from the input
    stream.  If this is the last token from the input stream, or if the
    token manager has not read tokens beyond this one, this field is
    set to null.  This is true only if this token is also a regular
    token.  Otherwise, see below for a description of the contents of
    this field.
    """

    specialToken: Token
    """
    This field is used to access special tokens that occur prior to this
    token, but after the immediately preceding regular (non-special) token.
    If there are no such special tokens, this field is set to null.
    When there are more than one such special token, this field refers
    to the last of these special tokens, which in turn refers to the next
    previous special token through its specialToken field, and so on
    until the first special token (whose specialToken field is null).
    The next fields of special tokens refer to other special tokens that
    immediately follow it (without an intervening regular token).  If there
    is no such token, this field is null.
    """


    @typing.overload
    def __init__(self):
        """
        No-argument constructor
        """

    @typing.overload
    def __init__(self, kind: typing.Union[jpype.JInt, int]):
        """
        Constructs a new token for the specified Image.
        """

    @typing.overload
    def __init__(self, kind: typing.Union[jpype.JInt, int], image: typing.Union[java.lang.String, str]):
        """
        Constructs a new token for the specified Image and Kind.
        """

    def getValue(self) -> java.lang.Object:
        """
        An optional attribute value of the Token.
        Tokens which are not used as syntactic sugar will often contain
        meaningful values that will be used later on by the compiler or
        interpreter. This attribute value is often different from the image.
        Any subclass of Token that actually wants to return a non-null value can
        override this method as appropriate.
        """

    @staticmethod
    @typing.overload
    def newToken(ofKind: typing.Union[jpype.JInt, int], image: typing.Union[java.lang.String, str]) -> Token:
        """
        Returns a new Token object, by default. However, if you want, you
        can create and return subclass objects based on the value of ofKind.
        Simply add the cases to the switch for all those special cases.
        For example, if you have a subclass of Token called IDToken that
        you want to create if ofKind is ID, simply add something like :
        
            case MyParserConstants.ID : return new IDToken(ofKind, image);
        
        to the following switch statement. Then you can cast matchedToken
        variable to the appropriate type and use sit in your lexical actions.
        """

    @staticmethod
    @typing.overload
    def newToken(ofKind: typing.Union[jpype.JInt, int]) -> Token:
        ...

    def toString(self) -> str:
        """
        Returns the image.
        """

    @property
    def value(self) -> java.lang.Object:
        ...


class CParser(CParserConstants):

    @typing.type_check_only
    class EnumMember(java.lang.Object):
        ...
        class_: typing.ClassVar[java.lang.Class]


    @typing.type_check_only
    class LookaheadSuccess(java.lang.Error):
        ...
        class_: typing.ClassVar[java.lang.Class]


    @typing.type_check_only
    class JJCalls(java.lang.Object):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class_: typing.ClassVar[java.lang.Class]
    token_source: CParserTokenManager
    """
    Generated Token Manager.
    """

    token: Token
    """
    Current token.
    """

    jj_nt: Token
    """
    Next token.
    """


    @typing.overload
    def __init__(self):
        ...

    @typing.overload
    def __init__(self, dtmgr: ghidra.program.model.data.DataTypeManager):
        ...

    @typing.overload
    def __init__(self, dtmgr: ghidra.program.model.data.DataTypeManager, storeDataType: typing.Union[jpype.JBoolean, bool], subDTMgrs: jpype.JArray[ghidra.program.model.data.DataTypeManager]):
        ...

    @typing.overload
    def __init__(self, stream: java.io.InputStream):
        """
        Constructor with InputStream.
        """

    @typing.overload
    def __init__(self, stream: java.io.InputStream, encoding: typing.Union[java.lang.String, str]):
        """
        Constructor with InputStream and supplied encoding
        """

    @typing.overload
    def __init__(self, stream: java.io.Reader):
        """
        Constructor.
        """

    @typing.overload
    def __init__(self, tm: CParserTokenManager):
        """
        Constructor with generated Token Manager.
        """

    def ANDExpression(self) -> java.lang.Object:
        ...

    def AbstractDeclarator(self, dt: Declaration) -> Declaration:
        ...

    def AdditiveExpression(self) -> java.lang.Object:
        ...

    def AlignmentSpecifier(self):
        ...

    def ArgumentExpressionList(self):
        ...

    def AsmLine(self):
        ...

    def AsmStatement(self):
        ...

    def AssignmentExpression(self) -> java.lang.Object:
        ...

    def AssignmentOperator(self):
        ...

    def AttributeList(self, dec: Declaration):
        ...

    def AttributeSpec(self, dec: Declaration):
        ...

    def AttributeSpecList(self, dec: Declaration):
        ...

    def AttributeToken(self, dec: Declaration):
        ...

    def BuiltInDeclarationSpecifier(self, dec: Declaration) -> Declaration:
        ...

    def BuiltInTypeSpecifier(self, dec: Declaration) -> Declaration:
        ...

    def CastExpression(self) -> java.lang.Object:
        ...

    def CompoundStatement(self):
        ...

    def ConditionalExpression(self) -> java.lang.Object:
        ...

    def Constant(self) -> java.lang.Object:
        ...

    def ConstantExpression(self) -> java.lang.Object:
        ...

    def DeclConstant(self):
        ...

    def DeclSpec(self, dec: Declaration):
        ...

    def DeclSpecifier(self, dec: Declaration):
        ...

    def Declaration(self) -> Declaration:
        ...

    def DeclarationList(self):
        ...

    def DeclarationSpecifiers(self, specDT: Declaration) -> Declaration:
        ...

    def Declarator(self, dt: Declaration, container: ghidra.program.model.data.DataType) -> Declaration:
        ...

    def Designation(self):
        ...

    def Designator(self):
        ...

    def DesignatorList(self):
        ...

    def DirectAbstractDeclarator(self, dt: Declaration) -> Declaration:
        ...

    def DirectDeclarator(self, dt: Declaration, container: ghidra.program.model.data.DataType) -> Declaration:
        ...

    def EnumSpecifier(self) -> ghidra.program.model.data.DataType:
        ...

    def Enumerator(self, list: java.util.ArrayList[CParser.EnumMember], value: typing.Union[jpype.JInt, int]) -> int:
        ...

    def EnumeratorList(self) -> java.util.ArrayList[CParser.EnumMember]:
        ...

    def EqualityExpression(self) -> java.lang.Object:
        ...

    def ExclusiveORExpression(self) -> java.lang.Object:
        ...

    def Expression(self) -> java.lang.Object:
        ...

    def ExpressionStatement(self):
        ...

    def ExternalDeclaration(self):
        ...

    def FunctionDefinition(self):
        ...

    def IdentifierList(self, funcDT: ghidra.program.model.data.FunctionDefinitionDataType, retDT: ghidra.program.model.data.DataType):
        ...

    def InclusiveORExpression(self) -> java.lang.Object:
        ...

    def InitDeclarator(self, dt: Declaration):
        ...

    def InitDeclaratorList(self, dt: Declaration):
        ...

    def Initializer(self):
        ...

    def InitializerList(self):
        ...

    def IterationStatement(self):
        ...

    def JumpStatement(self):
        ...

    def LabeledStatement(self):
        ...

    def LineDef(self):
        ...

    def LogicalANDExpression(self) -> java.lang.Object:
        ...

    def LogicalORExpression(self) -> java.lang.Object:
        ...

    def MultiLineString(self) -> Token:
        ...

    def MultiplicativeExpression(self) -> java.lang.Object:
        ...

    def ObjcDef(self) -> ghidra.program.model.data.DataType:
        ...

    def ParameterDeclaration(self, list: java.util.ArrayList[Declaration]):
        ...

    def ParameterList(self) -> java.util.ArrayList[Declaration]:
        ...

    def ParameterTypeList(self, funcDT: ghidra.program.model.data.FunctionDefinitionDataType, retDT: ghidra.program.model.data.DataType) -> Declaration:
        ...

    def Pointer(self, dec: Declaration) -> Declaration:
        ...

    def PostfixExpression(self) -> java.lang.Object:
        ...

    def PragmaConstant(self) -> Token:
        ...

    def PragmaSpec(self):
        ...

    def PragmaSpecifier(self):
        ...

    def PrimaryExpression(self) -> java.lang.Object:
        ...

    @typing.overload
    def ReInit(self, stream: java.io.InputStream):
        """
        Reinitialise.
        """

    @typing.overload
    def ReInit(self, stream: java.io.InputStream, encoding: typing.Union[java.lang.String, str]):
        """
        Reinitialise.
        """

    @typing.overload
    def ReInit(self, stream: java.io.Reader):
        """
        Reinitialise.
        """

    @typing.overload
    def ReInit(self, tm: CParserTokenManager):
        """
        Reinitialise.
        """

    def RelationalExpression(self) -> java.lang.Object:
        ...

    def SelectionStatement(self):
        ...

    def ShiftExpression(self) -> java.lang.Object:
        ...

    def SpecifierQualifierList(self) -> Declaration:
        ...

    def Statement(self):
        ...

    def StatementList(self):
        ...

    def StaticAssert(self):
        ...

    def StorageClassSpecifier(self, specDT: Declaration) -> Declaration:
        ...

    def StructDeclaration(self, comp: ghidra.program.model.data.Composite, compositeHandler: CompositeHandler):
        ...

    def StructDeclarationList(self, comp: ghidra.program.model.data.Composite):
        ...

    def StructDeclarator(self, dt: Declaration, comp: ghidra.program.model.data.Composite, compositeHandler: CompositeHandler):
        ...

    def StructDeclaratorList(self, dt: Declaration, comp: ghidra.program.model.data.Composite, compositeHandler: CompositeHandler):
        ...

    def StructOrUnion(self) -> ghidra.program.model.data.Composite:
        ...

    def StructOrUnionSpecifier(self) -> ghidra.program.model.data.DataType:
        ...

    def SubIdent(self, dec: Declaration):
        ...

    def TranslationUnit(self):
        ...

    def TypeName(self) -> Declaration:
        ...

    def TypeQualifier(self, dec: Declaration) -> Declaration:
        ...

    def TypeQualifierList(self, dec: Declaration) -> Declaration:
        ...

    def TypeSpecifier(self, dec: Declaration) -> Declaration:
        ...

    def TypedefName(self) -> ghidra.program.model.data.DataType:
        ...

    def UnaryExpression(self) -> java.lang.Object:
        ...

    def UnaryOperator(self):
        ...

    def didParseSucceed(self) -> bool:
        ...

    def disable_tracing(self):
        """
        Disable tracing.
        """

    def enable_tracing(self):
        """
        Enable tracing.
        """

    def generateParseException(self) -> ParseException:
        """
        Generate ParseException.
        """

    def getComposites(self) -> java.util.Map[java.lang.String, ghidra.program.model.data.DataType]:
        """
        Get composite definitions
        
        :return: Composite (structure/union) definitions
        :rtype: java.util.Map[java.lang.String, ghidra.program.model.data.DataType]
        """

    def getDataTypeManager(self) -> ghidra.program.model.data.DataTypeManager:
        """
        Get the data type manager
        
        :return: 
        :rtype: ghidra.program.model.data.DataTypeManager
        """

    def getDeclarations(self) -> java.util.Map[java.lang.String, ghidra.program.model.data.DataType]:
        """
        Get Global variable declarations
        
        :return: 
        :rtype: java.util.Map[java.lang.String, ghidra.program.model.data.DataType]
        """

    def getEnums(self) -> java.util.Map[java.lang.String, ghidra.program.model.data.DataType]:
        """
        Get Defined Enumerations
        
        :return: Defined enumeration names
        :rtype: java.util.Map[java.lang.String, ghidra.program.model.data.DataType]
        """

    def getFunctions(self) -> java.util.Map[java.lang.String, ghidra.program.model.data.DataType]:
        """
        Get Function signatures
        
        :return: Function signatures
        :rtype: java.util.Map[java.lang.String, ghidra.program.model.data.DataType]
        """

    def getLastDataType(self) -> ghidra.program.model.data.DataType:
        """
        
        
        :return: the last data type parsed
        :rtype: ghidra.program.model.data.DataType
        """

    def getNextToken(self) -> Token:
        """
        Get the next Token.
        """

    def getParseMessages(self) -> str:
        ...

    def getToken(self, index: typing.Union[jpype.JInt, int]) -> Token:
        """
        Get the specific Token.
        """

    def getTypes(self) -> java.util.Map[java.lang.String, ghidra.program.model.data.DataType]:
        """
        Get Type definitions
        
        :return: Type definitions
        :rtype: java.util.Map[java.lang.String, ghidra.program.model.data.DataType]
        """

    @staticmethod
    def main(args: jpype.JArray[java.lang.String]):
        ...

    @typing.overload
    def parse(self, str: typing.Union[java.lang.String, str]) -> ghidra.program.model.data.DataType:
        ...

    @typing.overload
    def parse(self, fis: java.io.InputStream):
        ...

    def setMonitor(self, monitor: ghidra.util.task.TaskMonitor):
        ...

    def setParseFileName(self, fName: typing.Union[java.lang.String, str]):
        ...

    @property
    def composites(self) -> java.util.Map[java.lang.String, ghidra.program.model.data.DataType]:
        ...

    @property
    def enums(self) -> java.util.Map[java.lang.String, ghidra.program.model.data.DataType]:
        ...

    @property
    def types(self) -> java.util.Map[java.lang.String, ghidra.program.model.data.DataType]:
        ...

    @property
    def functions(self) -> java.util.Map[java.lang.String, ghidra.program.model.data.DataType]:
        ...

    @property
    def nextToken(self) -> Token:
        ...

    @property
    def parseMessages(self) -> java.lang.String:
        ...

    @property
    def lastDataType(self) -> ghidra.program.model.data.DataType:
        ...

    @property
    def declarations(self) -> java.util.Map[java.lang.String, ghidra.program.model.data.DataType]:
        ...

    @property
    def dataTypeManager(self) -> ghidra.program.model.data.DataTypeManager:
        ...


class Declaration(java.lang.Object):
    """
    Container for information about a Declaration that is accumulated during parsing.
    """

    class_: typing.ClassVar[java.lang.Class]

    @typing.overload
    def __init__(self):
        ...

    @typing.overload
    def __init__(self, dec: Declaration):
        ...

    @typing.overload
    def __init__(self, dec: Declaration, name: typing.Union[java.lang.String, str]):
        ...

    @typing.overload
    def __init__(self, name: typing.Union[java.lang.String, str]):
        ...

    @typing.overload
    def __init__(self, dt: ghidra.program.model.data.DataType):
        ...

    @typing.overload
    def __init__(self, subDecl: Declaration, dt: ghidra.program.model.data.DataType):
        ...

    @typing.overload
    def __init__(self, dt: ghidra.program.model.data.DataType, name: typing.Union[java.lang.String, str]):
        ...

    @typing.overload
    def __init__(self, dt: ghidra.program.model.data.DataType, name: typing.Union[java.lang.String, str], comment: typing.Union[java.lang.String, str]):
        ...

    def addQualifier(self, qualifier: typing.Union[jpype.JInt, int]):
        ...

    def addQualifiers(self, dec: Declaration):
        ...

    def getBitFieldSize(self) -> int:
        """
        
        
        :return: the currently set bitfield size
        :rtype: int
        """

    def getComment(self) -> str:
        ...

    def getDataType(self) -> ghidra.program.model.data.DataType:
        ...

    def getName(self) -> str:
        ...

    def getQualifiers(self) -> java.util.List[java.lang.Integer]:
        ...

    def setComment(self, string: typing.Union[java.lang.String, str]):
        ...

    def setDataType(self, type: ghidra.program.model.data.DataType):
        ...

    def setName(self, string: typing.Union[java.lang.String, str]):
        ...

    @property
    def dataType(self) -> ghidra.program.model.data.DataType:
        ...

    @dataType.setter
    def dataType(self, value: ghidra.program.model.data.DataType):
        ...

    @property
    def name(self) -> java.lang.String:
        ...

    @name.setter
    def name(self, value: java.lang.String):
        ...

    @property
    def qualifiers(self) -> java.util.List[java.lang.Integer]:
        ...

    @property
    def comment(self) -> java.lang.String:
        ...

    @comment.setter
    def comment(self, value: java.lang.String):
        ...

    @property
    def bitFieldSize(self) -> jpype.JInt:
        ...


class SimpleCharStream(java.lang.Object):
    """
    An implementation of interface CharStream, where the stream is assumed to
    contain only ASCII characters (without unicode processing).
    """

    class_: typing.ClassVar[java.lang.Class]
    staticFlag: typing.Final = False
    """
    Whether parser is static.
    """

    bufpos: jpype.JInt
    """
    Position in buffer.
    """


    @typing.overload
    def __init__(self, dstream: java.io.Reader, startline: typing.Union[jpype.JInt, int], startcolumn: typing.Union[jpype.JInt, int], buffersize: typing.Union[jpype.JInt, int]):
        """
        Constructor.
        """

    @typing.overload
    def __init__(self, dstream: java.io.Reader, startline: typing.Union[jpype.JInt, int], startcolumn: typing.Union[jpype.JInt, int]):
        """
        Constructor.
        """

    @typing.overload
    def __init__(self, dstream: java.io.Reader):
        """
        Constructor.
        """

    @typing.overload
    def __init__(self, dstream: java.io.InputStream, encoding: typing.Union[java.lang.String, str], startline: typing.Union[jpype.JInt, int], startcolumn: typing.Union[jpype.JInt, int], buffersize: typing.Union[jpype.JInt, int]):
        """
        Constructor.
        """

    @typing.overload
    def __init__(self, dstream: java.io.InputStream, startline: typing.Union[jpype.JInt, int], startcolumn: typing.Union[jpype.JInt, int], buffersize: typing.Union[jpype.JInt, int]):
        """
        Constructor.
        """

    @typing.overload
    def __init__(self, dstream: java.io.InputStream, encoding: typing.Union[java.lang.String, str], startline: typing.Union[jpype.JInt, int], startcolumn: typing.Union[jpype.JInt, int]):
        """
        Constructor.
        """

    @typing.overload
    def __init__(self, dstream: java.io.InputStream, startline: typing.Union[jpype.JInt, int], startcolumn: typing.Union[jpype.JInt, int]):
        """
        Constructor.
        """

    @typing.overload
    def __init__(self, dstream: java.io.InputStream, encoding: typing.Union[java.lang.String, str]):
        """
        Constructor.
        """

    @typing.overload
    def __init__(self, dstream: java.io.InputStream):
        """
        Constructor.
        """

    def BeginToken(self) -> str:
        """
        Start.
        """

    def Done(self):
        """
        Reset buffer when finished.
        """

    def GetImage(self) -> str:
        """
        Get token literal value.
        """

    def GetSuffix(self, len: typing.Union[jpype.JInt, int]) -> jpype.JArray[jpype.JChar]:
        """
        Get the suffix.
        """

    @typing.overload
    def ReInit(self, dstream: java.io.Reader, startline: typing.Union[jpype.JInt, int], startcolumn: typing.Union[jpype.JInt, int], buffersize: typing.Union[jpype.JInt, int]):
        """
        Reinitialise.
        """

    @typing.overload
    def ReInit(self, dstream: java.io.Reader, startline: typing.Union[jpype.JInt, int], startcolumn: typing.Union[jpype.JInt, int]):
        """
        Reinitialise.
        """

    @typing.overload
    def ReInit(self, dstream: java.io.Reader):
        """
        Reinitialise.
        """

    @typing.overload
    def ReInit(self, dstream: java.io.InputStream, encoding: typing.Union[java.lang.String, str], startline: typing.Union[jpype.JInt, int], startcolumn: typing.Union[jpype.JInt, int], buffersize: typing.Union[jpype.JInt, int]):
        """
        Reinitialise.
        """

    @typing.overload
    def ReInit(self, dstream: java.io.InputStream, startline: typing.Union[jpype.JInt, int], startcolumn: typing.Union[jpype.JInt, int], buffersize: typing.Union[jpype.JInt, int]):
        """
        Reinitialise.
        """

    @typing.overload
    def ReInit(self, dstream: java.io.InputStream, encoding: typing.Union[java.lang.String, str]):
        """
        Reinitialise.
        """

    @typing.overload
    def ReInit(self, dstream: java.io.InputStream):
        """
        Reinitialise.
        """

    @typing.overload
    def ReInit(self, dstream: java.io.InputStream, encoding: typing.Union[java.lang.String, str], startline: typing.Union[jpype.JInt, int], startcolumn: typing.Union[jpype.JInt, int]):
        """
        Reinitialise.
        """

    @typing.overload
    def ReInit(self, dstream: java.io.InputStream, startline: typing.Union[jpype.JInt, int], startcolumn: typing.Union[jpype.JInt, int]):
        """
        Reinitialise.
        """

    def adjustBeginLineColumn(self, newLine: typing.Union[jpype.JInt, int], newCol: typing.Union[jpype.JInt, int]):
        """
        Method to adjust line and column numbers for the start of a token.
        """

    def backup(self, amount: typing.Union[jpype.JInt, int]):
        """
        Backup a number of characters.
        """

    def getBeginColumn(self) -> int:
        """
        Get token beginning column number.
        """

    def getBeginLine(self) -> int:
        """
        Get token beginning line number.
        """

    def getColumn(self) -> int:
        ...

    def getEndColumn(self) -> int:
        """
        Get token end column number.
        """

    def getEndLine(self) -> int:
        """
        Get token end line number.
        """

    def getLine(self) -> int:
        ...

    def readChar(self) -> str:
        """
        Read a character.
        """

    @property
    def endLine(self) -> jpype.JInt:
        ...

    @property
    def endColumn(self) -> jpype.JInt:
        ...

    @property
    def beginColumn(self) -> jpype.JInt:
        ...

    @property
    def line(self) -> jpype.JInt:
        ...

    @property
    def beginLine(self) -> jpype.JInt:
        ...

    @property
    def column(self) -> jpype.JInt:
        ...


class CParserTokenManager(CParserConstants):
    """
    Token Manager.
    """

    class_: typing.ClassVar[java.lang.Class]
    debugStream: java.io.PrintStream
    """
    Debug output.
    """

    jjstrLiteralImages: typing.Final[jpype.JArray[java.lang.String]]
    """
    Token literal values.
    """

    lexStateNames: typing.Final[jpype.JArray[java.lang.String]]
    """
    Lexer state names.
    """

    jjnewLexState: typing.Final[jpype.JArray[jpype.JInt]]
    """
    Lex State array.
    """


    @typing.overload
    def __init__(self, stream: SimpleCharStream):
        """
        Constructor.
        """

    @typing.overload
    def __init__(self, stream: SimpleCharStream, lexState: typing.Union[jpype.JInt, int]):
        """
        Constructor.
        """

    @typing.overload
    def ReInit(self, stream: SimpleCharStream):
        """
        Reinitialise parser.
        """

    @typing.overload
    def ReInit(self, stream: SimpleCharStream, lexState: typing.Union[jpype.JInt, int]):
        """
        Reinitialise parser.
        """

    def SwitchTo(self, lexState: typing.Union[jpype.JInt, int]):
        """
        Switch to specified lex state.
        """

    def getNextToken(self) -> Token:
        """
        Get the next Token.
        """

    def setDebugStream(self, ds: java.io.PrintStream):
        """
        Set debug output.
        """

    @property
    def nextToken(self) -> Token:
        ...


class TokenMgrError(java.lang.Error):
    """
    Token Manager Error.
    """

    class_: typing.ClassVar[java.lang.Class]

    @typing.overload
    def __init__(self):
        """
        No arg constructor.
        """

    @typing.overload
    def __init__(self, message: typing.Union[java.lang.String, str], reason: typing.Union[jpype.JInt, int]):
        """
        Constructor with message and reason.
        """

    @typing.overload
    def __init__(self, EOFSeen: typing.Union[jpype.JBoolean, bool], lexState: typing.Union[jpype.JInt, int], errorLine: typing.Union[jpype.JInt, int], errorColumn: typing.Union[jpype.JInt, int], errorAfter: typing.Union[java.lang.String, str], curChar: typing.Union[jpype.JChar, int, str], reason: typing.Union[jpype.JInt, int]):
        """
        Full Constructor.
        """

    def getMessage(self) -> str:
        """
        You can also modify the body of this method to customize your error messages.
        For example, cases like LOOP_DETECTED and INVALID_LEXICAL_STATE are not
        of end-users concern, so you can return something like :
        
            "Internal Error : Please file a bug report .... "
        
        from this method for such cases in the release version of your parser.
        """

    @property
    def message(self) -> java.lang.String:
        ...


class ParseException(java.lang.Exception):
    """
    This exception is thrown when parse errors are encountered.
    You can explicitly create objects of this exception type by
    calling the method generateParseException in the generated
    parser.
    
    You can modify this class to customize your error reporting
    mechanisms so long as you retain the public fields.
    """

    class_: typing.ClassVar[java.lang.Class]
    currentToken: Token
    """
    This is the last token that has been consumed successfully.  If
    this object has been created due to a parse error, the token
    followng this token will (therefore) be the first error token.
    """

    expectedTokenSequences: jpype.JArray[jpype.JArray[jpype.JInt]]
    """
    Each entry in this array is an array of integers.  Each array
    of integers represents a sequence of tokens (by their ordinal
    values) that is expected at this point of the parse.
    """

    tokenImage: jpype.JArray[java.lang.String]
    """
    This is a reference to the "tokenImage" array of the generated
    parser within which the parse error occurred.  This array is
    defined in the generated ...Constants interface.
    """


    @typing.overload
    def __init__(self, currentTokenVal: Token, expectedTokenSequencesVal: jpype.JArray[jpype.JArray[jpype.JInt]], tokenImageVal: jpype.JArray[java.lang.String]):
        """
        This constructor is used by the method "generateParseException"
        in the generated parser.  Calling this constructor generates
        a new object of this type with the fields "currentToken",
        "expectedTokenSequences", and "tokenImage" set.
        """

    @typing.overload
    def __init__(self):
        """
        The following constructors are for use by you for whatever
        purpose you can think of.  Constructing the exception in this
        manner makes the exception behave in the normal way - i.e., as
        documented in the class "Throwable".  The fields "errorToken",
        "expectedTokenSequences", and "tokenImage" do not contain
        relevant information.  The JavaCC generated code does not use
        these constructors.
        """

    @typing.overload
    def __init__(self, message: typing.Union[java.lang.String, str]):
        """
        Constructor with message.
        """


class CParserUtils(java.lang.Object):

    class CParseResults(java.lang.Record):

        class_: typing.ClassVar[java.lang.Class]

        def __init__(self, preProcessor: ghidra.app.util.cparser.CPP.PreProcessor, cppParseMessages: typing.Union[java.lang.String, str], cParseMessages: typing.Union[java.lang.String, str], successful: typing.Union[jpype.JBoolean, bool]):
            ...

        def cParseMessages(self) -> str:
            ...

        def cppParseMessages(self) -> str:
            ...

        def equals(self, o: java.lang.Object) -> bool:
            ...

        def getFormattedParseMessage(self, errMsg: typing.Union[java.lang.String, str]) -> str:
            ...

        def hashCode(self) -> int:
            ...

        def preProcessor(self) -> ghidra.app.util.cparser.CPP.PreProcessor:
            ...

        def successful(self) -> bool:
            ...

        def toString(self) -> str:
            ...

        @property
        def formattedParseMessage(self) -> java.lang.String:
            ...


    class_: typing.ClassVar[java.lang.Class]

    @staticmethod
    def getFile(parent: typing.Union[java.lang.String, str], filename: typing.Union[java.lang.String, str]) -> java.io.File:
        ...

    @staticmethod
    def handleParseProblem(t: java.lang.Throwable, functionString: typing.Union[java.lang.String, str]) -> str:
        """
        Given a throwable, attempt pull out the significant error parts to generate a 
        user-friendly error message.
        
        :param java.lang.Throwable t: the throwable to examine, originating from the :obj:`CParser`.
        :param java.lang.String or str functionString: the full function signature text that was parsed by the parser.
        :return: a user-friendly error message, or null if this class did not know how to 
                handle the given exception.
        :rtype: str
        """

    @staticmethod
    @typing.overload
    def parseHeaderFiles(openDTMgrs: jpype.JArray[ghidra.program.model.data.DataTypeManager], filenames: jpype.JArray[java.lang.String], args: jpype.JArray[java.lang.String], dataFileName: typing.Union[java.lang.String, str], monitor: ghidra.util.task.TaskMonitor) -> ghidra.program.model.data.FileDataTypeManager:
        """
        Parse a set of C Header files and associated parsing arguments, returning a new File 
        Data TypeManager with in the provided dataFileName.  The resulting archive
        will not be associated with a specific language/compiler and will use the default 
        data organization.
         
        Note: Using another open archive while parsing will cause:
        - a dependence on the other archive
        - any missing data types while parsing are supplied if present from an openDTMgr
        - after parsing all data types parsed with an equivalent data type in any openDTMgr
            replaced by the data type from the openDTMgr
             
        NOTE: This will only occur if the data type from the openDTMgr's is equivalent.
        
        :param jpype.JArray[ghidra.program.model.data.DataTypeManager] openDTMgrs: array of datatypes managers to use for undefined data types
        :param jpype.JArray[java.lang.String] filenames: names of files in order to parse, could include strings with
                "#" at start, which are ignored as comments
        :param jpype.JArray[java.lang.String] args: arguments for parsing, ``-D<defn>=, -I<includepath>``
        :param java.lang.String or str dataFileName: name of data type archive file (include the .gdt extension)
        :param ghidra.util.task.TaskMonitor monitor: used to cancel or provide results
        :return: the data types in the ghidra .gdt archive file
        :rtype: ghidra.program.model.data.FileDataTypeManager
        :raises ParseException: for catastrophic errors in C parsing
        :raises ghidra.app.util.cparser.CPP.ParseException: for catastrophic errors in Preprocessor macro parsing
        :raises IOException: if there io are errors saving the archive
        """

    @staticmethod
    @typing.overload
    def parseHeaderFiles(openDTMgrs: jpype.JArray[ghidra.program.model.data.DataTypeManager], filenames: jpype.JArray[java.lang.String], includePaths: jpype.JArray[java.lang.String], args: jpype.JArray[java.lang.String], dataFileName: typing.Union[java.lang.String, str], monitor: ghidra.util.task.TaskMonitor) -> ghidra.program.model.data.FileDataTypeManager:
        """
        Parse a set of C Header files and associated parsing arguments, returning a new 
        File Data TypeManager with in the provided dataFileName.  The resulting archive
        will not be associated with a specific language/compiler and will use the default 
        data organization.
         
        Note: Using another open archive while parsing will cause:
        - a dependence on the other archive
        - any missing data types while parsing are supplied if present from an openDTMgr
        - after parsing all data types parsed with an equivalent data type in any openDTMgr
            replaced by the data type from the openDTMgr
             
        NOTE: This will only occur if the data type from the openDTMgr's is equivalent.
        
        :param jpype.JArray[ghidra.program.model.data.DataTypeManager] openDTMgrs: array of datatypes managers to use for undefined data types
        :param jpype.JArray[java.lang.String] filenames: names of files in order to parse, could include strings with
                "#" at start, which are ignored as comments
        :param jpype.JArray[java.lang.String] includePaths: paths to include files, instead of using ``-I<includepath>`` in args
        :param jpype.JArray[java.lang.String] args: arguments for parsing, ``-D<defn>=``, ( ``-I<includepath>`` use 
                includePaths parm instead)
        :param java.lang.String or str dataFileName: name of data type archive file (include the .gdt extension)
        :param ghidra.util.task.TaskMonitor monitor: used to cancel or provide results
        :return: the data types in the ghidra .gdt archive file
        :rtype: ghidra.program.model.data.FileDataTypeManager
        :raises ParseException: for catastrophic errors in C parsing
        :raises ghidra.app.util.cparser.CPP.ParseException: for catastrophic errors in Preprocessor macro parsing
        :raises IOException: if there io are errors saving the archive
        """

    @staticmethod
    @typing.overload
    def parseHeaderFiles(openDTMgrs: jpype.JArray[ghidra.program.model.data.DataTypeManager], filenames: jpype.JArray[java.lang.String], includePaths: jpype.JArray[java.lang.String], args: jpype.JArray[java.lang.String], dataFileName: typing.Union[java.lang.String, str], languageId: typing.Union[java.lang.String, str], compileSpecId: typing.Union[java.lang.String, str], monitor: ghidra.util.task.TaskMonitor) -> ghidra.program.model.data.FileDataTypeManager:
        """
        Parse a set of C Header files and associated parsing arguments, returning a new File Data TypeManager
        with in the provided dataFileName.
         
        When parsing is complete any parser messages will be logged.
         
        Note: Using another open archive while parsing will cause:
        - a dependence on the other archive
        - any missing data types while parsing are supplied if present from an openDTMgr
        - after parsing all data types parsed with an equivalent data type in any openDTMgr
            replaced by the data type from the openDTMgr
             
        NOTE: This will only occur if the data type from the openDTMgr's is equivalent.
         
        NOTE: Providing the correct languageId and compileSpecId is very important for header files that might use sizeof()
        
        :param jpype.JArray[ghidra.program.model.data.DataTypeManager] openDTMgrs: array of datatypes managers to use for undefined data types
        :param jpype.JArray[java.lang.String] filenames: names of files in order to parse, could include strings with
                "#" at start, which are ignored as comments
        :param jpype.JArray[java.lang.String] includePaths: path to include files, could also be in args with ``-I<includepath>``
        :param jpype.JArray[java.lang.String] args: arguments for parsing, ``-D<defn>=, -I<includepath>``
        :param java.lang.String or str dataFileName: name of data type archive file (include the .gdt extension)
        :param java.lang.String or str languageId: language identication to use for data type organization definitions (int, long, ptr size)
        :param java.lang.String or str compileSpecId: compiler specification to use for parsing
        :param ghidra.util.task.TaskMonitor monitor: used to cancel or provide results
        :return: the FileDataTypeManager corresponding to the Ghidra .gdt archive file.
        The caller is responsible for closing the instance.
        :rtype: ghidra.program.model.data.FileDataTypeManager
        :raises ParseException: for catastrophic errors in C parsing
        :raises ghidra.app.util.cparser.CPP.ParseException: for catastrophic errors in Preprocessor macro parsing
        :raises IOException: if there io are errors saving the archive
        """

    @staticmethod
    @typing.overload
    def parseHeaderFiles(openDTMgrs: jpype.JArray[ghidra.program.model.data.DataTypeManager], filenames: jpype.JArray[java.lang.String], args: jpype.JArray[java.lang.String], dtMgr: ghidra.program.model.data.DataTypeManager, monitor: ghidra.util.task.TaskMonitor) -> CParserUtils.CParseResults:
        """
        Parse a set of C Header files and associated parsing arguments, data types are added to the provided
        DTMgr.
        
        Note: Using another open archive while parsing will cause:
        - a dependence on the other archive
        - any missing data types while parsing are supplied if present from an openDTMgr
        - after parsing all data types parsed with an equivalent data type in any openDTMgr
            replaced by the data type from the openDTMgr
             
        NOTE: This will only occur if the data type from the openDTMgr's is equivalent.
        
        :param jpype.JArray[ghidra.program.model.data.DataTypeManager] openDTMgrs: array of datatypes managers to use for undefined data types
        :param jpype.JArray[java.lang.String] filenames: names of files in order to parse, could include strings with
                "#" at start, which are ignored as comments
        :param jpype.JArray[java.lang.String] args: arguments for parsing, ``-D<defn>=``, (``-I<includepath>`` use 
                includePaths parm instead)
        :param ghidra.program.model.data.DataTypeManager dtMgr: datatypes will be populated into this provided DTMgr, can pass Program or File DTMgr
        :param ghidra.util.task.TaskMonitor monitor: used to cancel or provide results
        :return: a formatted string of any output from pre processor parsing or C parsing
        :rtype: CParserUtils.CParseResults
        :raises ParseException: for catastrophic errors in C parsing
        :raises ghidra.app.util.cparser.CPP.ParseException: for catastrophic errors in Preprocessor macro parsing
        :raises IOException: if there io are errors saving the archive
        """

    @staticmethod
    @typing.overload
    def parseHeaderFiles(openDTmanagers: jpype.JArray[ghidra.program.model.data.DataTypeManager], filenames: jpype.JArray[java.lang.String], includePaths: jpype.JArray[java.lang.String], args: jpype.JArray[java.lang.String], dtMgr: ghidra.program.model.data.DataTypeManager, monitor: ghidra.util.task.TaskMonitor) -> CParserUtils.CParseResults:
        """
        Parse a set of C Header files and associated parsing arguments, data types are added to the provided
        DTMgr.
         
        Note: Using another open archive while parsing will cause:
        - a dependence on the other archive
        - any missing data types while parsing are supplied if present from an openDTMgr
        - after parsing all data types parsed with an equivalent data type in any openDTMgr
            replaced by the data type from the openDTMgr
             
        NOTE: This will only occur if the data type from the openDTMgr's is equivalent.
         
        NOTE: The DTMgr should have been created with the correct data type organization from a language/compilerspec
            if there could be variants in datatype defintions when using the generic data type manager data organization
            for example in a generic FileDataTypeManager int and long are size 4. This will change in the future,
            but with the current implementation, beware!
        
        :param jpype.JArray[ghidra.program.model.data.DataTypeManager] openDTmanagers: array of datatypes managers to use for undefined data types
        :param jpype.JArray[java.lang.String] filenames: names of files in order to parse, could include strings with
                "#" at start, which are ignored as comments
        :param jpype.JArray[java.lang.String] includePaths: paths to include files, instead of using ``-I<includepath>`` in args
        :param jpype.JArray[java.lang.String] args: arguments for parsing, ``-D<defn>=``, ( ``-I<includepath>`` use includePaths parm instead)
        :param ghidra.program.model.data.DataTypeManager dtMgr: datatypes will be populated into this provided DTMgr, can pass Program or File DTMgr
        :param ghidra.util.task.TaskMonitor monitor: used to cancel or provide results
        :return: a formatted string of any output from pre processor parsing or C parsing
        :rtype: CParserUtils.CParseResults
        :raises ParseException: for catastrophic errors in C parsing
        :raises ghidra.app.util.cparser.CPP.ParseException: for catastrophic errors in Preprocessor macro parsing
        """

    @staticmethod
    @typing.overload
    def parseSignature(serviceProvider: ghidra.framework.plugintool.ServiceProvider, program: ghidra.program.model.listing.Program, signatureText: typing.Union[java.lang.String, str]) -> ghidra.program.model.data.FunctionDefinitionDataType:
        """
        Parse the given function signature text.  Any exceptions will be handled herein
        by showing an error dialog (null is returned in that case).
        
        :param ghidra.framework.plugintool.ServiceProvider serviceProvider: the service provider used to access DataTypeManagers
        :param ghidra.program.model.listing.Program program: the program against which data types will be resolved
        :param java.lang.String or str signatureText: the signature to parse
        :return: the data type that is created as a result of parsing; null if there was a problem
        :rtype: ghidra.program.model.data.FunctionDefinitionDataType
        
        .. seealso::
        
            | :obj:`.parseSignature(DataTypeManagerService, Program, String)`
        
            | :obj:`.parseSignature(DataTypeManagerService, Program, String, boolean)`
        """

    @staticmethod
    @typing.overload
    def parseSignature(service: ghidra.app.services.DataTypeManagerService, program: ghidra.program.model.listing.Program, signatureText: typing.Union[java.lang.String, str]) -> ghidra.program.model.data.FunctionDefinitionDataType:
        """
        Parse the given function signature text.  Any exceptions will be handled herein
        by showing an error dialog (null is returned in that case).
        
        :param ghidra.app.services.DataTypeManagerService service: the service used to access DataTypeManagers or null to use only the program's
        data type manager.
        :param ghidra.program.model.listing.Program program: the program against which data types will be resolved
        :param java.lang.String or str signatureText: the signature to parse
        :return: the data type that is created as a result of parsing; null if there was a problem
        :rtype: ghidra.program.model.data.FunctionDefinitionDataType
        
        .. seealso::
        
            | :obj:`.parseSignature(DataTypeManagerService, Program, String, boolean)`
        """

    @staticmethod
    @typing.overload
    def parseSignature(service: ghidra.app.services.DataTypeManagerService, program: ghidra.program.model.listing.Program, signatureText: typing.Union[java.lang.String, str], handleExceptions: typing.Union[jpype.JBoolean, bool]) -> ghidra.program.model.data.FunctionDefinitionDataType:
        """
        Parse the given function signature text.  Any exceptions will be handled herein
        by showing an error dialog (null is returned in that case).
        
        :param ghidra.app.services.DataTypeManagerService service: the service used to access DataTypeManagers or null to use only the program's
        data type manager.
        :param ghidra.program.model.listing.Program program: the program against which data types will be resolved
        :param java.lang.String or str signatureText: the signature to parse
        :param jpype.JBoolean or bool handleExceptions: true signals that this method should deal with exceptions, 
                showing error messages as necessary; false signals to throw any encountered
                parsing exceptions.  This allows clients to perform exception handling that
                better matches their workflow.
        :return: the data type that is created as a result of parsing; null if there was a problem
        :rtype: ghidra.program.model.data.FunctionDefinitionDataType
        :raises ParseException: for catastrophic errors in C parsing
        """



__all__ = ["CParserConstants", "CompositeHandler", "Token", "CParser", "Declaration", "SimpleCharStream", "CParserTokenManager", "TokenMgrError", "ParseException", "CParserUtils"]
