from __future__ import annotations
import collections.abc
import datetime
import typing
from warnings import deprecated # type: ignore

import jpype # type: ignore
import jpype.protocol # type: ignore

import help.validator
import help.validator.location
import java.io # type: ignore
import java.lang # type: ignore
import java.nio.file # type: ignore
import java.util # type: ignore


class IMG(java.lang.Comparable[IMG]):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self, help: help.validator.location.HelpModuleLocation, sourceFile: jpype.protocol.SupportsPath, imgSrc: typing.Union[java.lang.String, str], lineNumber: typing.Union[jpype.JInt, int]):
        """
        Constructor
        
        :param help.validator.location.HelpModuleLocation help: the help module containing the file containing this IMG reference
        :param jpype.protocol.SupportsPath sourceFile: the source file containing this IMG reference
        :param java.lang.String or str imgSrc: the IMG SRC attribute pulled from the HTML file
        :param jpype.JInt or int lineNumber: the line number of the IMG tag
        :raises URISyntaxException: if there is an exception resolving the image URI
        """

    def getHelpPath(self) -> java.nio.file.Path:
        ...

    def getImageFile(self) -> java.nio.file.Path:
        ...

    def getLineNumber(self) -> int:
        ...

    def getSourceFile(self) -> java.nio.file.Path:
        ...

    def getSrcAttribute(self) -> str:
        ...

    def isInvalid(self) -> bool:
        ...

    def isRemote(self) -> bool:
        ...

    def isRuntime(self) -> bool:
        ...

    @property
    def imageFile(self) -> java.nio.file.Path:
        ...

    @property
    def invalid(self) -> jpype.JBoolean:
        ...

    @property
    def runtime(self) -> jpype.JBoolean:
        ...

    @property
    def remote(self) -> jpype.JBoolean:
        ...

    @property
    def lineNumber(self) -> jpype.JInt:
        ...

    @property
    def srcAttribute(self) -> java.lang.String:
        ...

    @property
    def sourceFile(self) -> java.nio.file.Path:
        ...

    @property
    def helpPath(self) -> java.nio.file.Path:
        ...


class HelpFile(java.lang.Object):

    class_: typing.ClassVar[java.lang.Class]

    def containsAnchor(self, anchorName: typing.Union[java.lang.String, str]) -> bool:
        ...

    def getAllAnchorDefinitions(self) -> java.util.Collection[AnchorDefinition]:
        ...

    def getAnchorDefinition(self, helpPath: jpype.protocol.SupportsPath) -> AnchorDefinition:
        ...

    def getDuplicateAnchorsByID(self) -> java.util.Map[java.lang.String, java.util.List[AnchorDefinition]]:
        ...

    def getFile(self) -> java.nio.file.Path:
        ...

    def getRelativePath(self) -> java.nio.file.Path:
        ...

    @property
    def file(self) -> java.nio.file.Path:
        ...

    @property
    def duplicateAnchorsByID(self) -> java.util.Map[java.lang.String, java.util.List[AnchorDefinition]]:
        ...

    @property
    def relativePath(self) -> java.nio.file.Path:
        ...

    @property
    def anchorDefinition(self) -> AnchorDefinition:
        ...

    @property
    def allAnchorDefinitions(self) -> java.util.Collection[AnchorDefinition]:
        ...


class TOCItemExternal(TOCItem):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self, parentItem: TOCItem, tocFile: jpype.protocol.SupportsPath, ID: typing.Union[java.lang.String, str], text: typing.Union[java.lang.String, str], target: typing.Union[java.lang.String, str], sortPreference: typing.Union[java.lang.String, str], lineNumber: typing.Union[jpype.JInt, int]):
        ...


class HREF(java.lang.Comparable[HREF]):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self, help: help.validator.location.HelpModuleLocation, sourceFile: jpype.protocol.SupportsPath, href: typing.Union[java.lang.String, str], lineNum: typing.Union[jpype.JInt, int]):
        ...

    def getAnchorName(self) -> str:
        ...

    def getHelpPath(self) -> str:
        ...

    def getLineNumber(self) -> int:
        ...

    def getRefString(self) -> str:
        ...

    def getReferenceFileHelpPath(self) -> java.nio.file.Path:
        """
        The relative help path to the destination of this HREF
        
        :return: the relative help path to the destination of this HREF
        :rtype: java.nio.file.Path
        """

    def getSourceFile(self) -> java.nio.file.Path:
        ...

    def isLocalAnchor(self) -> bool:
        ...

    def isRemote(self) -> bool:
        ...

    def isURL(self) -> bool:
        ...

    @property
    def refString(self) -> java.lang.String:
        ...

    @property
    def referenceFileHelpPath(self) -> java.nio.file.Path:
        ...

    @property
    def localAnchor(self) -> jpype.JBoolean:
        ...

    @property
    def remote(self) -> jpype.JBoolean:
        ...

    @property
    def lineNumber(self) -> jpype.JInt:
        ...

    @property
    def sourceFile(self) -> java.nio.file.Path:
        ...

    @property
    def helpPath(self) -> java.lang.String:
        ...

    @property
    def anchorName(self) -> java.lang.String:
        ...

    @property
    def uRL(self) -> jpype.JBoolean:
        ...


class TOCItem(java.lang.Object):
    """
    A Table of Contents entry, which is represented in the help output as an xml tag.
    """

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self, parentItem: TOCItem, sourceFile: jpype.protocol.SupportsPath, ID: typing.Union[java.lang.String, str], lineNumber: typing.Union[jpype.JInt, int]):
        ...

    def generateEndTag(self, indentLevel: typing.Union[jpype.JInt, int]) -> str:
        ...

    def generateTOCItemTag(self, linkDatabase: help.validator.LinkDatabase, isInlineTag: typing.Union[jpype.JBoolean, bool], indentLevel: typing.Union[jpype.JInt, int]) -> str:
        ...

    def getIDAttribute(self) -> str:
        ...

    def getLineNumber(self) -> int:
        ...

    def getParent(self) -> TOCItem:
        ...

    def getSortPreference(self) -> str:
        ...

    def getSourceFile(self) -> java.nio.file.Path:
        ...

    def getTargetAttribute(self) -> str:
        ...

    def getTextAttribute(self) -> str:
        ...

    def isEquivalent(self, other: TOCItem) -> bool:
        """
        True if the two items are the same, except that they come from a different source file.
        
        :param TOCItem other: the other item
        :return: true if equivalent
        :rtype: bool
        """

    def validate(self, linkDatabase: help.validator.LinkDatabase) -> bool:
        ...

    @typing.overload
    def writeContents(self, linkDatabase: help.validator.LinkDatabase, writer: java.io.PrintWriter, indentLevel: typing.Union[jpype.JInt, int]):
        ...

    @typing.overload
    def writeContents(self, linkDatabase: help.validator.LinkDatabase, writer: java.io.PrintWriter):
        ...

    @property
    def equivalent(self) -> jpype.JBoolean:
        ...

    @property
    def parent(self) -> TOCItem:
        ...

    @property
    def textAttribute(self) -> java.lang.String:
        ...

    @property
    def sortPreference(self) -> java.lang.String:
        ...

    @property
    def targetAttribute(self) -> java.lang.String:
        ...

    @property
    def iDAttribute(self) -> java.lang.String:
        ...

    @property
    def lineNumber(self) -> jpype.JInt:
        ...

    @property
    def sourceFile(self) -> java.nio.file.Path:
        ...


class AnchorDefinition(java.lang.Object):
    """
    A representation of a help location, which can be a file or a file with an anchor inside of
    that file.
     
    
    This class is used to generate target information for TOC files and to generate link information
    for the help map files.
     
    
     
    
     
    
    **Warning: ** The ID generated by this class is specific to the JavaHelp system.  It is of 
    the format:
     
    
    ``TopicName_anchorName``
     
    
    or
     
    
    ``TopicName_Filename``
    """

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self, file: jpype.protocol.SupportsPath, anchorName: typing.Union[java.lang.String, str], lineNum: typing.Union[jpype.JInt, int]):
        ...

    def getAnchorName(self) -> str:
        ...

    def getHelpPath(self) -> str:
        ...

    def getId(self) -> str:
        ...

    def getLineNumber(self) -> int:
        ...

    def getSrcFile(self) -> java.nio.file.Path:
        ...

    @property
    def srcFile(self) -> java.nio.file.Path:
        ...

    @property
    def id(self) -> java.lang.String:
        ...

    @property
    def lineNumber(self) -> jpype.JInt:
        ...

    @property
    def helpPath(self) -> java.lang.String:
        ...

    @property
    def anchorName(self) -> java.lang.String:
        ...


class TOCItemDefinition(TOCItem):
    """
    A representation of the <tocdef> tag, which is a way to define a TOC item entry in 
    a TOC_Source.xml file.
    """

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self, parentItem: TOCItem, sourceTOCFile: jpype.protocol.SupportsPath, ID: typing.Union[java.lang.String, str], text: typing.Union[java.lang.String, str], target: typing.Union[java.lang.String, str], sortPreference: typing.Union[java.lang.String, str], lineNumber: typing.Union[jpype.JInt, int]):
        ...


class HelpTopic(java.lang.Comparable[HelpTopic]):

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self, help: help.validator.location.HelpModuleLocation, topicFile: jpype.protocol.SupportsPath):
        ...

    @staticmethod
    def fromHTMLFile(topicFile: jpype.protocol.SupportsPath) -> HelpTopic:
        ...

    def getAllAnchorDefinitions(self) -> java.util.Collection[AnchorDefinition]:
        ...

    def getAllHREFs(self) -> java.util.Collection[HREF]:
        ...

    def getAllIMGs(self) -> java.util.Collection[IMG]:
        ...

    def getHelpDirectory(self) -> help.validator.location.HelpModuleLocation:
        ...

    def getHelpFiles(self) -> java.util.Collection[HelpFile]:
        ...

    def getName(self) -> str:
        ...

    def getTopicFile(self) -> java.nio.file.Path:
        ...

    @property
    def name(self) -> java.lang.String:
        ...

    @property
    def helpFiles(self) -> java.util.Collection[HelpFile]:
        ...

    @property
    def topicFile(self) -> java.nio.file.Path:
        ...

    @property
    def helpDirectory(self) -> help.validator.location.HelpModuleLocation:
        ...

    @property
    def allHREFs(self) -> java.util.Collection[HREF]:
        ...

    @property
    def allIMGs(self) -> java.util.Collection[IMG]:
        ...

    @property
    def allAnchorDefinitions(self) -> java.util.Collection[AnchorDefinition]:
        ...


class TOCItemReference(TOCItem, java.lang.Comparable[TOCItemReference]):
    """
    A representation of the <tocref> tag, which is a way to reference a TOC item entry in 
    a TOC_Source.xml file other than the one in which the reference lives.
    """

    class_: typing.ClassVar[java.lang.Class]

    def __init__(self, parentItem: TOCItem, sourceTOCFile: jpype.protocol.SupportsPath, ID: typing.Union[java.lang.String, str], lineNumber: typing.Union[jpype.JInt, int]):
        ...

    def generateTOCItemTag(self, linkDatabase: help.validator.LinkDatabase, isInlineTag: typing.Union[jpype.JBoolean, bool], indentLevel: typing.Union[jpype.JInt, int]) -> str:
        """
        Overridden, as if we get called, then something is in an invalid state, so generate special output
        """

    def getTargetAttribute(self) -> str:
        """
        Overridden, as references cannot have targets, only their definitions
        """

    @property
    def targetAttribute(self) -> java.lang.String:
        ...


class GhidraTOCFile(java.lang.Object):

    @typing.type_check_only
    class DummyRootTOCItem(TOCItem):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class_: typing.ClassVar[java.lang.Class]
    TOC_ITEM_REFERENCE: typing.Final = "tocref"
    TOC_ITEM_DEFINITION: typing.Final = "tocdef"

    @staticmethod
    def createGhidraTOCFile(sourceTOCFile: jpype.protocol.SupportsPath) -> GhidraTOCFile:
        ...

    def getAllTOCItems(self) -> java.util.Collection[TOCItem]:
        ...

    def getFile(self) -> java.nio.file.Path:
        ...

    def getTOCDefinitionByIDMapping(self) -> java.util.Map[java.lang.String, TOCItemDefinition]:
        ...

    def getTOCDefinitions(self) -> java.util.Collection[TOCItemDefinition]:
        ...

    @property
    def file(self) -> java.nio.file.Path:
        ...

    @property
    def tOCDefinitionByIDMapping(self) -> java.util.Map[java.lang.String, TOCItemDefinition]:
        ...

    @property
    def allTOCItems(self) -> java.util.Collection[TOCItem]:
        ...

    @property
    def tOCDefinitions(self) -> java.util.Collection[TOCItemDefinition]:
        ...



__all__ = ["IMG", "HelpFile", "TOCItemExternal", "HREF", "TOCItem", "AnchorDefinition", "TOCItemDefinition", "HelpTopic", "TOCItemReference", "GhidraTOCFile"]
