/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.services;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.file.FileException;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileMetadataAccessor;
import org.gradle.internal.file.FileModeAccessor;
import org.gradle.internal.file.FileModeMutator;
import org.gradle.internal.file.StatStatistics;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.Symlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GenericFileSystem
implements FileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericFileSystem.class);
    private Boolean caseSensitive;
    private final boolean canCreateSymbolicLink;
    private final TemporaryFileProvider temporaryFileProvider;
    private final FileModeMutator chmod;
    private final FileModeAccessor stat;
    private final Symlink symlink;
    private final FileMetadataAccessor metadata;
    private final StatStatistics.Collector statisticsCollector;

    public GenericFileSystem(FileModeMutator chmod, FileModeAccessor stat, Symlink symlink, FileMetadataAccessor metadata, StatStatistics.Collector statisticsCollector, TemporaryFileProvider temporaryFileProvider) {
        this.metadata = metadata;
        this.stat = stat;
        this.symlink = symlink;
        this.chmod = chmod;
        this.canCreateSymbolicLink = symlink.isSymlinkCreationSupported();
        this.statisticsCollector = statisticsCollector;
        this.temporaryFileProvider = temporaryFileProvider;
    }

    public boolean isCaseSensitive() {
        this.initializeCaseSensitive();
        return this.caseSensitive;
    }

    public boolean canCreateSymbolicLink() {
        return this.canCreateSymbolicLink;
    }

    public void createSymbolicLink(File link, File target) {
        try {
            this.symlink.symlink(link, target);
        }
        catch (Exception e) {
            throw new FileException(String.format("Could not create symlink from '%s' to '%s'.", link.getPath(), target.getPath()), (Throwable)e);
        }
    }

    public boolean isSymlink(File suspect) {
        return this.symlink.isSymlink(suspect);
    }

    public int getUnixMode(File f) {
        this.statisticsCollector.reportUnixModeQueried();
        try {
            return this.stat.getUnixMode(f);
        }
        catch (Exception e) {
            throw new FileException(String.format("Could not get file mode for '%s'.", f), (Throwable)e);
        }
    }

    public FileMetadata stat(File f) throws FileException {
        this.statisticsCollector.reportFileStated();
        return this.metadata.stat(f);
    }

    public void chmod(File f, int mode) {
        try {
            this.chmod.chmod(f, mode);
        }
        catch (Exception e) {
            throw new FileException(String.format("Could not set file mode %o on '%s'.", mode, f), (Throwable)e);
        }
    }

    private void initializeCaseSensitive() {
        if (this.caseSensitive == null) {
            String content = this.generateUniqueContent();
            File file = null;
            try {
                this.checkJavaIoTmpDirExists();
                file = this.createFile(content);
                this.caseSensitive = this.probeCaseSensitive(file, content);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    FileUtils.deleteQuietly(file);
                    throw throwable;
                }
            }
            FileUtils.deleteQuietly((File)file);
        }
    }

    private String generateUniqueContent() {
        return UUID.randomUUID().toString();
    }

    private File createFile(String content) throws IOException {
        File file = this.temporaryFileProvider.createTemporaryFile("gradle_fs_probing", null, new String[0]);
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)content);
        return file;
    }

    private boolean probeCaseSensitive(File file, String content) {
        try {
            File upperCased = new File(file.getPath().toUpperCase(Locale.ROOT));
            return !this.hasContent(upperCased, content);
        }
        catch (IOException e) {
            boolean result = !new File("foo").equals(new File("FOO"));
            LOGGER.info("Failed to determine if file system is case sensitive. Best guess is '{}'.", (Object)result);
            return result;
        }
    }

    private boolean hasContent(File file, String content) throws IOException {
        return file.exists() && Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8).readFirstLine().equals(content);
    }

    private void checkJavaIoTmpDirExists() throws IOException {
        File dir = new File(SystemProperties.getInstance().getJavaIoTmpDir());
        if (!dir.exists()) {
            throw new IOException("java.io.tmpdir is set to a directory that doesn't exist: " + dir);
        }
    }

    static final class Factory {
        private final FileMetadataAccessor fileMetadataAccessor;
        private final StatStatistics.Collector statisticsCollector;
        private final TemporaryFileProvider temporaryFileProvider;

        @Inject
        Factory(FileMetadataAccessor fileMetadataAccessor, StatStatistics.Collector statisticsCollector, TemporaryFileProvider temporaryFileProvider) {
            this.fileMetadataAccessor = fileMetadataAccessor;
            this.statisticsCollector = statisticsCollector;
            this.temporaryFileProvider = temporaryFileProvider;
        }

        GenericFileSystem create(FileModeMutator chmod, FileModeAccessor stat, Symlink symlink) {
            return new GenericFileSystem(chmod, stat, symlink, this.fileMetadataAccessor, this.statisticsCollector, this.temporaryFileProvider);
        }
    }
}

