/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.specs.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.buildinit.specs.BuildInitGenerator;
import org.gradle.buildinit.specs.BuildInitSpec;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Build.class})
public final class BuildInitSpecRegistry {
    public static final String BUILD_INIT_SPECS_PLUGIN_SUPPLIER = "org.gradle.buildinit.specs";
    private static final Logger LOGGER = Logging.getLogger(BuildInitSpecRegistry.class);
    private final Map<Class<? extends BuildInitGenerator>, List<BuildInitSpec>> specsByGeneratorType = new HashMap<Class<? extends BuildInitGenerator>, List<BuildInitSpec>>();

    public void register(Class<? extends BuildInitGenerator> generatorType, List<BuildInitSpec> specs) {
        List currentSpecsForGenerator = this.specsByGeneratorType.computeIfAbsent(generatorType, k -> new ArrayList());
        specs.forEach(spec -> {
            this.doGetGeneratorForSpec((BuildInitSpec)spec).ifPresent(g -> {
                throw new IllegalStateException(String.format("Spec: '%s' with type: '%s' cannot use same type as another spec already registered!", spec.getDisplayName(), spec.getType()));
            });
            currentSpecsForGenerator.add(spec);
            LOGGER.info("Loaded project spec: '{} ({})', generated via: '{}'", new Object[]{spec.getDisplayName(), spec.getType(), generatorType.getName()});
        });
    }

    public List<BuildInitSpec> getAllSpecs() {
        return this.specsByGeneratorType.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.specsByGeneratorType.isEmpty();
    }

    public BuildInitSpec getSpecByType(String type) {
        List matchingSpecs = this.specsByGeneratorType.values().stream().flatMap(Collection::stream).filter(spec -> Objects.equals(spec.getType(), type)).collect(Collectors.toList());
        switch (matchingSpecs.size()) {
            case 0: {
                throw new IllegalStateException("Build init spec with type: '" + type + "' was not found!" + System.lineSeparator() + "Known types:" + System.lineSeparator() + this.getAllSpecs().stream().map(BuildInitSpec::getType).map(t -> " - " + t).collect(Collectors.joining(System.lineSeparator())));
            }
            case 1: {
                return (BuildInitSpec)matchingSpecs.get(0);
            }
        }
        throw new IllegalStateException("Multiple project specs: " + matchingSpecs.stream().map(BuildInitSpec::getDisplayName).collect(Collectors.joining(", ")) + " with type: '" + type + "' were found!");
    }

    public Class<? extends BuildInitGenerator> getGeneratorForSpec(BuildInitSpec spec) {
        return this.doGetGeneratorForSpec(spec).orElseThrow(() -> new IllegalStateException("Spec: '" + spec.getDisplayName() + "' with type: '" + spec.getType() + "' is not registered!"));
    }

    private Optional<Class<? extends BuildInitGenerator>> doGetGeneratorForSpec(BuildInitSpec spec) {
        return this.specsByGeneratorType.entrySet().stream().filter(entry -> this.isSpecWithTypePresent(spec, (List)entry.getValue())).findFirst().map(Map.Entry::getKey);
    }

    private boolean isSpecWithTypePresent(BuildInitSpec target, List<BuildInitSpec> toSearch) {
        return toSearch.stream().anyMatch(s -> this.isSameType((BuildInitSpec)s, target));
    }

    private boolean isSameType(BuildInitSpec s1, BuildInitSpec s2) {
        return Objects.equals(s1.getType(), s2.getType());
    }
}

