#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cipher-aes
version:              0.2.11
visibility:           public
id:                   cipher-aes-0.2.11-DQRVUFWqo589f3NcmQ8yMW
key:                  cipher-aes-0.2.11-DQRVUFWqo589f3NcmQ8yMW
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           Vincent Hanquez <vincent@snarc.org>
author:               Vincent Hanquez <vincent@snarc.org>
homepage:             https://github.com/vincenthz/hs-cipher-aes
synopsis:
    Fast AES cipher implementation with advanced mode of operations

description:
    Fast AES cipher implementation with advanced mode of operations.

    The modes of operations available are ECB (Electronic code book),
    CBC (Cipher block chaining), CTR (Counter), XTS (XEX with ciphertext stealing),
    GCM (Galois Counter Mode).

    The AES implementation uses AES-NI when available (on x86 and x86-64 architecture),
    but fallback gracefully to a software C implementation.

    The software implementation uses S-Boxes, which might suffer for cache timing issues.
    However do notes that most other known software implementations, including very popular
    one (openssl, gnutls) also uses similar implementation. If it matters for your
    case, you should make sure you have AES-NI available, or you'\''ll need to use a different
    implementation.

category:             Cryptography
abi:                  232132a938eafbc84771141f76e6ea23
exposed:              True
exposed-modules:      Crypto.Cipher.AES
import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/cipher-aes-0.2.11
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/cipher-aes-0.2.11
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/cipher-aes-0.2.11
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cipher-aes
hs-libraries:         HScipher-aes-0.2.11-DQRVUFWqo589f3NcmQ8yMW
depends:
    base-4.18.3.0 byteable-0.1.1-F9hAnSKCYYA7Nk5jFdwRS
    bytestring-0.11.5.4
    crypto-cipher-types-0.0.9-FkxfXm03PGdAYNWXbgYfeE
    securemem-0.1.10-Esl7Zo7Il7xCSor4iaqfn0

haddock-interfaces:   /usr/share/doc/haskell-cipher-aes/html/cipher-aes.haddock
haddock-html:         /usr/share/doc/haskell-cipher-aes/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

