#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 graphviz
version:              2999.20.2.1
visibility:           public
id:                   graphviz-2999.20.2.1-2luQcOMaSrs6htx2yUs6BJ
key:                  graphviz-2999.20.2.1-2luQcOMaSrs6htx2yUs6BJ
license:              BSD-3-Clause
copyright:            Matthew Sackman, Ivan Lazar Miljenovic
maintainer:           Daniel Casanueva (coding `at` danielcasanueva.eu)
author:               Matthew Sackman, Ivan Lazar Miljenovic
synopsis:             Bindings to Graphviz for graph visualisation.
description:
    This library provides bindings for the Dot language used by the
    Graphviz (<http://graphviz.org/>) suite of programs for visualising
    graphs, as well as functions to call those programs.

    Main features of the graphviz library include:

    * Almost complete coverage of all Graphviz attributes and syntax.

    * Support for specifying clusters.

    * The ability to use a custom node type.

    * Functions for running a Graphviz layout tool with all specified
    output types.

    * The ability to not only generate but also parse Dot code with two
    options: strict and liberal (in terms of ordering of statements).

    * Functions to convert FGL graphs and other graph-like data structures
    to Dot code - including support to group them into clusters - with a
    high degree of customisation by specifying which attributes to use
    and limited support for the inverse operation.

    * Round-trip support for passing an FGL graph through Graphviz to
    augment node and edge labels with positional information, etc.

category:             Graphs, Graphics
abi:                  a7daf039e8917bcdeb43e2991256ef35
exposed:              True
exposed-modules:
    Data.GraphViz Data.GraphViz.Algorithms Data.GraphViz.Attributes
    Data.GraphViz.Attributes.Colors
    Data.GraphViz.Attributes.Colors.Brewer
    Data.GraphViz.Attributes.Colors.SVG
    Data.GraphViz.Attributes.Colors.X11
    Data.GraphViz.Attributes.Complete Data.GraphViz.Attributes.HTML
    Data.GraphViz.Attributes.Internal Data.GraphViz.Commands
    Data.GraphViz.Commands.IO Data.GraphViz.Exception
    Data.GraphViz.Internal.State Data.GraphViz.Internal.Util
    Data.GraphViz.Parsing Data.GraphViz.PreProcessing
    Data.GraphViz.Printing Data.GraphViz.Types
    Data.GraphViz.Types.Canonical Data.GraphViz.Types.Generalised
    Data.GraphViz.Types.Graph Data.GraphViz.Types.Internal.Common
    Data.GraphViz.Types.Monadic

hidden-modules:
    Data.GraphViz.Algorithms.Clustering Data.GraphViz.Attributes.Arrows
    Data.GraphViz.Attributes.ColorScheme Data.GraphViz.Attributes.Same
    Data.GraphViz.Attributes.Values Data.GraphViz.Commands.Available
    Data.GraphViz.Types.State

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/graphviz-2999.20.2.1
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/graphviz-2999.20.2.1
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/graphviz-2999.20.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-graphviz
hs-libraries:         HSgraphviz-2999.20.2.1-2luQcOMaSrs6htx2yUs6BJ
depends:
    base-4.18.3.0 bytestring-0.11.5.4
    colour-2.3.6-DoApLSa6gBO3p6mb77xRwR containers-0.6.7
    directory-1.3.8.5 dlist-1.0-INK6ndPYH7QL7JTi9xHVWN
    fgl-5.8.3.0-8jycYMtKpx0E0U1sKmbOix filepath-1.4.301.0 mtl-2.3.1
    polyparse-1.13.1-BCxmYYUJf3MBmBXo6ZXb1j process-1.6.19.0
    temporary-1.3-3RiPejuWpFkF6pn2FQhudK text-2.0.2
    wl-pprint-text-1.2.0.2-KPgDVF0C39oBAiEGVyqxFS

haddock-interfaces:   /usr/share/doc/haskell-graphviz/html/graphviz.haddock
haddock-html:         /usr/share/doc/haskell-graphviz/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

