#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 language-haskell-extract
version:              0.2.4
visibility:           public
id:                   language-haskell-extract-0.2.4-57kFeaIDuVj5810GV2aUSd
key:                  language-haskell-extract-0.2.4-57kFeaIDuVj5810GV2aUSd
license:              BSD-3-Clause
maintainer:           Oscar Finnsson
author:               Oscar Finnsson & Emil Nordling
stability:            stable
homepage:             http://github.com/finnsson/template-helper
synopsis:
    Module to automatically extract functions from the local code.

description:
    @language-haskell-extract@ contains some useful helper functions on top of Template Haskell.

    @functionExtractor@ extracts all functions after a regexp-pattern.

    > foo = "test"
    > boo = "testing"
    > bar = $(functionExtractor "oo$")

    will automagically extract the functions ending with @oo@ such as

    > bar = [("foo",foo), ("boo",boo)]

    This can be useful if you wish to extract all functions beginning with test (for a test-framework)
    or all functions beginning with wc (for a web service).

    @functionExtractorMap@ works like @functionsExtractor@ but applies a function over all function-pairs.

    This functions is useful if the common return type of the functions is a type class.

    Example:

    > secondTypeclassTest =
    >   do let expected = ["45", "88.8", "\"hej\""]
    >          actual = $(functionExtractorMap "^tc" [|\n f -> show f|] )
    >      expected @=? actual
    >
    > tcInt :: Integer
    > tcInt = 45
    >
    > tcDouble :: Double
    > tcDouble = 88.8
    >
    > tcString :: String
    > tcString = "hej"

category:             Template Haskell
abi:                  6f670c34d664a3239f6f88a9434ef60d
exposed:              True
exposed-modules:      Language.Haskell.Extract
import-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/language-haskell-extract-0.2.4

library-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/language-haskell-extract-0.2.4

library-dirs-static:
    /usr/lib/ghc-9.6.7.20250817/site-local/language-haskell-extract-0.2.4

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-language-haskell-extract
hs-libraries:         HSlanguage-haskell-extract-0.2.4-57kFeaIDuVj5810GV2aUSd
depends:
    base-4.18.3.0 regex-posix-0.96.0.2-5io6mw87knoCnGAankEkLx
    template-haskell-2.20.0.0

haddock-interfaces:
    /usr/share/doc/haskell-language-haskell-extract/html/language-haskell-extract.haddock

haddock-html:         /usr/share/doc/haskell-language-haskell-extract/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

