#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 semialign
version:              1.3.1
visibility:           public
id:                   semialign-1.3.1-98hjaFujxCEBspsGczRRix
key:                  semialign-1.3.1-98hjaFujxCEBspsGczRRix
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  f58da2429371c84652441191c9593827
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/semialign-1.3.1
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/semialign-1.3.1
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/semialign-1.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.3.1-98hjaFujxCEBspsGczRRix
depends:
    base-4.18.3.0 containers-0.6.7
    hashable-1.4.7.0-17jkMnZLQLs4o2IKp4JpPo
    indexed-traversable-0.1.4-4WgKtUu7swysftQ0x7OdR
    indexed-traversable-instances-0.1.2-81ld82wfrOf7WG9e59LwBd
    semigroupoids-6.0.1-HDr1Vl4bsU6CmLVz8mRz3I
    tagged-0.8.9-HMh4qZxoofeBZ9IcdInbXO
    these-1.2.1-8yONRQ8fpJ8Up4VI4BEBS transformers-0.6.1.0
    unordered-containers-0.2.20.1-Kme465eYitW9JyEVR89fCg
    vector-0.13.2.0-BINMV7y6ibUKgFTnLXEi1A

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

