from pydantic import BaseModel
from sqlalchemy import Column, Integer, String, Double, ForeignKey
from sqlalchemy.orm import relationship

from ..base import Base


class ProcessUtilisation(Base):
    __tablename__ = 'process_utilisation'
    id = Column(Integer, primary_key=True, index=True)
    process = Column(String)
    utilisation_pct = Column(Double)
    report_id = Column(Integer, ForeignKey('report.id'))
    report = relationship('Report', back_populates='process_utilisation')


class ProcessUtilisationInDB(BaseModel):
    id: int
    process: str
    utilisation_pct: float

    class Config:
        from_attributes = True


class ProcessUtilisationCreate(BaseModel):
    process: str
    utilisation_pct: float
