/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.action;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.opensearch.action.ActionRequest;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class ExtensionActionUtil {
    public static final byte UNIT_SEPARATOR = 31;

    public static byte[] createProxyRequestBytes(ActionRequest request) throws RuntimeException {
        byte[] requestClassBytes = request.getClass().getName().getBytes(StandardCharsets.UTF_8);
        try {
            byte[] requestBytes = ExtensionActionUtil.convertParamsToBytes(request);
            assert (requestBytes != null);
            return ByteBuffer.allocate(requestClassBytes.length + 1 + requestBytes.length).put(requestClassBytes).put((byte)31).put(requestBytes).array();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("RuntimeException occurred while creating proxyRequestBytes");
        }
    }

    public static ActionRequest createActionRequest(byte[] requestBytes) throws ReflectiveOperationException {
        int delimPos = ExtensionActionUtil.delimPos(requestBytes);
        String requestClassName = new String(Arrays.copyOfRange(requestBytes, 0, delimPos + 1), StandardCharsets.UTF_8).stripTrailing();
        try {
            Class<?> clazz = Class.forName(requestClassName);
            Constructor<?> constructor = clazz.getConstructor(StreamInput.class);
            StreamInput requestByteStream = StreamInput.wrap((byte[])Arrays.copyOfRange(requestBytes, delimPos + 1, requestBytes.length));
            return (ActionRequest)constructor.newInstance(requestByteStream);
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectiveOperationException("ReflectiveOperationException occurred while creating extensionAction request from bytes", e);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("NullPointerException occurred while creating extensionAction request from bytes" + e.getMessage());
        }
    }

    public static <T extends Writeable> byte[] convertParamsToBytes(T writeableObject) throws IllegalStateException {
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            writeableObject.writeTo((StreamOutput)out);
            byte[] byArray = BytesReference.toBytes((BytesReference)out.bytes());
            out.close();
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ieo) {
                throw new IllegalStateException("Failure writing bytes", ieo);
            }
        }
    }

    public static int delimPos(byte[] bytes) {
        for (int offset = 0; offset < bytes.length; ++offset) {
            if (bytes[offset] != 31) continue;
            return offset;
        }
        return -1;
    }
}

