/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.auth;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.ContainerCredentialsFetcher;
import net.snowflake.client.jdbc.internal.amazonaws.auth.ContainerCredentialsRetryPolicy;
import net.snowflake.client.jdbc.internal.amazonaws.internal.CredentialsEndpointProvider;
import net.snowflake.client.jdbc.internal.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;

public class ContainerCredentialsProvider
implements AWSCredentialsProvider {
    static final String ECS_CONTAINER_CREDENTIALS_PATH = "AWS_CONTAINER_CREDENTIALS_RELATIVE_URI";
    static final String CONTAINER_CREDENTIALS_FULL_URI = "AWS_CONTAINER_CREDENTIALS_FULL_URI";
    static final String CONTAINER_AUTHORIZATION_TOKEN = "AWS_CONTAINER_AUTHORIZATION_TOKEN";
    private static final String HTTPS = "https";
    private static final String ECS_CREDENTIALS_ENDPOINT = "http://169.254.170.2";
    private final ContainerCredentialsFetcher credentialsFetcher;

    @Deprecated
    public ContainerCredentialsProvider() {
        this(new ECSCredentialsEndpointProvider());
    }

    public ContainerCredentialsProvider(CredentialsEndpointProvider credentialsEndpointProvider) {
        this.credentialsFetcher = new ContainerCredentialsFetcher(credentialsEndpointProvider);
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.credentialsFetcher.getCredentials();
    }

    @Override
    public void refresh() {
        this.credentialsFetcher.refresh();
    }

    public Date getCredentialsExpiration() {
        return this.credentialsFetcher.getCredentialsExpiration();
    }

    static class FullUriCredentialsEndpointProvider
    extends CredentialsEndpointProvider {
        FullUriCredentialsEndpointProvider() {
        }

        @Override
        public URI getCredentialsEndpoint() {
            String fullUri = System.getenv(ContainerCredentialsProvider.CONTAINER_CREDENTIALS_FULL_URI);
            if (fullUri == null || fullUri.length() == 0) {
                throw new SdkClientException("The environment variable AWS_CONTAINER_CREDENTIALS_FULL_URI is empty");
            }
            URI uri = URI.create(fullUri);
            if (!this.isHttps(uri) && !this.isAllowedHost(uri.getHost())) {
                throw new SdkClientException("The full URI (" + uri + ") contained withing environment variable " + ContainerCredentialsProvider.CONTAINER_CREDENTIALS_FULL_URI + " has an invalid host. Host should resolve to a loopback address or have the full URI be HTTPS.");
            }
            return uri;
        }

        @Override
        public Map<String, String> getHeaders() {
            if (System.getenv(ContainerCredentialsProvider.CONTAINER_AUTHORIZATION_TOKEN) != null) {
                return Collections.singletonMap("Authorization", System.getenv(ContainerCredentialsProvider.CONTAINER_AUTHORIZATION_TOKEN));
            }
            return new HashMap<String, String>();
        }

        private boolean isHttps(URI endpoint) {
            return Objects.equals(ContainerCredentialsProvider.HTTPS, endpoint.getScheme());
        }

        private boolean isAllowedHost(String host) {
            try {
                InetAddress[] addresses = InetAddress.getAllByName(host);
                boolean allAllowed = true;
                for (InetAddress address : addresses) {
                    if (this.isLoopbackAddress(address)) continue;
                    allAllowed = false;
                }
                return addresses.length > 0 && allAllowed;
            }
            catch (UnknownHostException e) {
                throw new SdkClientException(String.format("host (%s) could not be resolved to an IP address.", host), e);
            }
        }

        private boolean isLoopbackAddress(InetAddress inetAddress) {
            return inetAddress.isLoopbackAddress();
        }
    }

    static class ECSCredentialsEndpointProvider
    extends CredentialsEndpointProvider {
        ECSCredentialsEndpointProvider() {
        }

        @Override
        public URI getCredentialsEndpoint() {
            String path = System.getenv(ContainerCredentialsProvider.ECS_CONTAINER_CREDENTIALS_PATH);
            if (path == null) {
                throw new SdkClientException("The environment variable AWS_CONTAINER_CREDENTIALS_RELATIVE_URI is empty");
            }
            return URI.create(ContainerCredentialsProvider.ECS_CREDENTIALS_ENDPOINT + path);
        }

        @Override
        public CredentialsEndpointRetryPolicy getRetryPolicy() {
            return ContainerCredentialsRetryPolicy.getInstance();
        }
    }
}

