/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace;

import java.util.Random;
import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanId;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TraceId;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.RandomSupplier;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.IdGenerator;

enum RandomIdGenerator implements IdGenerator
{
    INSTANCE;

    private static final long INVALID_ID = 0L;
    private static final Supplier<Random> randomSupplier;

    @Override
    public String generateSpanId() {
        long id;
        Random random = randomSupplier.get();
        while ((id = random.nextLong()) == 0L) {
        }
        return SpanId.fromLong(id);
    }

    @Override
    public String generateTraceId() {
        long idLo;
        Random random = randomSupplier.get();
        long idHi = random.nextLong();
        while ((idLo = random.nextLong()) == 0L) {
        }
        return TraceId.fromLongs(idHi, idLo);
    }

    public String toString() {
        return "RandomIdGenerator{}";
    }

    static {
        randomSupplier = RandomSupplier.platformDefault();
    }
}

