/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonFileDetector;
import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctionsClinicProviders;
import com.oracle.graal.python.builtins.modules.BuiltinFunctionsFactory;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ast.AstModuleBuiltins;
import com.oracle.graal.python.builtins.modules.io.IOModuleBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.PHashingCollection;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ellipsis.EllipsisBuiltins;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.PDoubleSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntegerSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PLongSequenceIterator;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotUnaryFunc;
import com.oracle.graal.python.compiler.Compiler;
import com.oracle.graal.python.compiler.ParserCallbacksImpl;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyEvalGetGlobals;
import com.oracle.graal.python.lib.PyEvalGetLocals;
import com.oracle.graal.python.lib.PyIterCheckNode;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyMappingCheckNode;
import com.oracle.graal.python.lib.PyNumberAbsoluteNode;
import com.oracle.graal.python.lib.PyNumberAddNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberDivmodNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyNumberPowerNode;
import com.oracle.graal.python.lib.PyObjectAsciiNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectDir;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetAttrO;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttrO;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectSetAttrO;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.lib.PyUnicodeFSDecoderNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.bytecode.GetAIterNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.call.special.SpecialMethodNotFound;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.frame.GetFrameLocalsNode;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.pegparser.AbstractParser;
import com.oracle.graal.python.pegparser.FutureFeature;
import com.oracle.graal.python.pegparser.InputType;
import com.oracle.graal.python.pegparser.Parser;
import com.oracle.graal.python.pegparser.ParserCallbacks;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.BoolSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.CharsetMapping;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;

@CoreFunctions(defineModule="builtins", isEager=true)
public final class BuiltinFunctions
extends PythonBuiltins {
    protected List<NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BuiltinFunctionsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant(BuiltinNames.T___GRAALPYTHON__, (Object)core.lookupBuiltinModule(BuiltinNames.T___GRAALPYTHON__));
        this.addBuiltinConstant(StringLiterals.T_NONE, (Object)PNone.NONE);
        this.addBuiltinConstant(StringLiterals.T_FALSE, (Object)false);
        this.addBuiltinConstant(StringLiterals.T_TRUE, (Object)true);
        this.addBuiltinConstant(BuiltinNames.T_NOT_IMPLEMENTED, (Object)PNotImplemented.NOT_IMPLEMENTED);
        this.addBuiltinConstant(EllipsisBuiltins.T_ELLIPSIS, (Object)PEllipsis.INSTANCE);
        super.initialize(core);
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonModule builtinsModule = core.lookupBuiltinModule(BuiltinNames.T_BUILTINS);
        builtinsModule.setAttribute(BuiltinNames.T___DEBUG__, core.getContext().getOption(PythonOptions.PythonOptimizeFlag) == false);
    }

    @Builtin(name="aiter", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class AIter
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGeneric(VirtualFrame frame, Object arg, @Cached GetAIterNode aiter) {
            return aiter.execute((Frame)frame, arg);
        }
    }

    @Builtin(name="anext", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=2, parameterNames={"aiterator", "default"})
    @GenerateNodeFactory
    public static abstract class ANext
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doGeneric(VirtualFrame frame, Object asyncIter, Object defaultValue, @Bind Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getSlots, @Cached TpSlotUnaryFunc.CallSlotUnaryNode callSlot, @Cached InlinedConditionProfile hasDefault, @Cached PRaiseNode raiseNoANext) {
            TpSlots slots = getSlots.execute(inliningTarget, asyncIter);
            if (slots.am_anext() == null) {
                throw raiseNoANext.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJECT_NOT_ASYNCGEN, asyncIter);
            }
            if (hasDefault.profile(inliningTarget, defaultValue == PNone.NO_VALUE)) {
                return callSlot.execute(frame, inliningTarget, slots.am_anext(), asyncIter);
            }
            return PFactory.createANextAwaitable(PythonLanguage.get(inliningTarget), asyncIter, defaultValue);
        }
    }

    @Builtin(name="__build_class__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class BuildClassNode
    extends PythonVarargsBuiltinNode {
        private static final TruffleString T_METACLASS = PythonUtils.tsLiteral("metaclass");
        public static final TruffleString T_BUILD_JAVA_CLASS = PythonUtils.tsLiteral("build_java_class");

        @CompilerDirectives.TruffleBoundary
        private static Object buildJavaClass(Object namespace, TruffleString name, Object base) {
            PythonModule module = PythonContext.get(null).lookupBuiltinModule(BuiltinNames.T___GRAALPYTHON__);
            Object buildFunction = PyObjectLookupAttr.executeUncached(module, T_BUILD_JAVA_CLASS);
            return CallNode.executeUncached(buildFunction, namespace, name, base);
        }

        @HostCompilerDirectives.InliningCutoff
        private static Object buildJavaClass(VirtualFrame frame, Node inliningTarget, PythonLanguage language, PFunction function, Object[] arguments, CallDispatchers.FunctionCachedInvokeNode invokeBody, TruffleString name) {
            PDict ns = PFactory.createDict(language, new DynamicObjectStorage(language));
            Object[] args = PArguments.create(0);
            PArguments.setSpecialArgument(args, ns);
            invokeBody.execute(frame, inliningTarget, function, args);
            return BuildClassNode.buildJavaClass(ns, name, arguments[1]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doItNonFunction(VirtualFrame frame, Object function, Object[] arguments, final PKeyword[] keywords, final @Bind Node inliningTarget, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached(value="createFor($node)") IndirectCallData indirectCallData, final @Cached CalculateMetaclassNode calculateMetaClass, @Cached(value="create(T___PREPARE__)") GetAttributeNode getPrepare, @Cached PyMappingCheckNode pyMappingCheckNode, @Cached CallNode callPrep, @Cached CallNode callType, @Cached CallDispatchers.FunctionCachedInvokeNode invokeBody, final @Cached UpdateBasesNode update, @Cached PyObjectSetItem setOrigBases, final @Cached GetClassNode getClass, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile noAttributeProfile, @Cached PRaiseNode raiseNode) {
            Object ns;
            class InitializeBuildClass {
                boolean isClass;
                Object meta;
                PKeyword[] mkw;
                PTuple bases;
                final /* synthetic */ BuildClassNode this$0;

                @CompilerDirectives.TruffleBoundary
                InitializeBuildClass(PythonContext ctx) {
                    this.this$0 = this$0;
                    this.bases = updateBasesNode.execute(pTuple, objectArray, objectArray.length);
                    this.mkw = pKeywordArray;
                    for (int i = 0; i < pKeywordArray.length; ++i) {
                        if (!T_METACLASS.equalsUncached((AbstractTruffleString)pKeywordArray[i].getName(), PythonUtils.TS_ENCODING)) continue;
                        this.meta = pKeywordArray[i].getValue();
                        this.mkw = PKeyword.create(pKeywordArray.length - 1);
                        PythonUtils.arraycopy(pKeywordArray, 0, this.mkw, 0, i);
                        PythonUtils.arraycopy(pKeywordArray, i + 1, this.mkw, i, this.mkw.length - i);
                        this.isClass = TypeNodes.IsTypeNode.executeUncached(this.meta);
                        break;
                    }
                    if (this.meta == null) {
                        this.meta = this.bases.getSequenceStorage().length() == 0 ? ctx.lookupType(PythonBuiltinClassType.PythonClass) : getClassNode.execute(node, SequenceStorageNodes.GetItemScalarNode.executeUncached(this.bases.getSequenceStorage(), 0));
                        this.isClass = true;
                    }
                    if (this.isClass) {
                        this.meta = calculateMetaclassNode.execute(this.meta, this.bases);
                    }
                }
            }
            InitializeBuildClass init;
            TruffleString name;
            if (arguments.length < 1) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.BUILD_CLS_NOT_ENOUGH_ARGS);
            }
            if (!PGuards.isFunction(function)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.BUILD_CLS_FUNC_MUST_BE_FUNC);
            }
            try {
                name = castToTruffleStringNode.execute(inliningTarget, arguments[0]);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.BUILD_CLS_NAME_NOT_STRING);
            }
            PythonContext ctx = PythonContext.get(inliningTarget);
            TruffleLanguage.Env env = ctx.getEnv();
            PythonLanguage language = ctx.getLanguage(inliningTarget);
            final Object[] basesArray = Arrays.copyOfRange(arguments, 1, arguments.length);
            final PTuple origBases = PFactory.createTuple(language, basesArray);
            if (arguments.length == 2 && env.isHostObject(arguments[1]) && env.asHostObject(arguments[1]) instanceof Class) {
                return BuildClassNode.buildJavaClass(frame, inliningTarget, language, (PFunction)function, arguments, invokeBody, name);
            }
            Object savedState = ExecutionContext.IndirectCallContext.enter(frame, inliningTarget, indirectCallData);
            try {
                init = new InitializeBuildClass(ctx);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, inliningTarget, indirectCallData, savedState);
            }
            try {
                Object prep = getPrepare.executeObject(frame, init.meta);
                ns = callPrep.execute((Frame)frame, prep, new Object[]{name, init.bases}, init.mkw);
            }
            catch (PException p) {
                p.expectAttributeError(inliningTarget, noAttributeProfile);
                ns = PFactory.createDict(language, new DynamicObjectStorage(language));
            }
            if (!pyMappingCheckNode.execute(inliningTarget, ns)) {
                throw this.raiseNoMapping(init.isClass, init.meta, ns);
            }
            Object[] bodyArguments = PArguments.create(0);
            PArguments.setSpecialArgument(bodyArguments, ns);
            invokeBody.execute(frame, inliningTarget, (PFunction)function, bodyArguments);
            if (init.bases != origBases) {
                setOrigBases.execute((Frame)frame, inliningTarget, ns, SpecialAttributeNames.T___ORIG_BASES__, origBases);
            }
            Object cls = callType.execute((Frame)frame, init.meta, new Object[]{name, init.bases, ns}, init.mkw);
            return cls;
        }

        @HostCompilerDirectives.InliningCutoff
        private PException raiseNoMapping(boolean isClass, Object meta, Object ns) {
            if (isClass) {
                throw PRaiseNode.raiseStatic(this, PythonErrorType.TypeError, ErrorMessages.N_PREPARE_MUST_RETURN_MAPPING, meta, ns);
            }
            throw PRaiseNode.raiseStatic(this, PythonErrorType.TypeError, ErrorMessages.MTCLS_PREPARE_MUST_RETURN_MAPPING, ns);
        }
    }

    @GenerateInline(value=false)
    static abstract class CalculateMetaclassNode
    extends Node {
        CalculateMetaclassNode() {
        }

        abstract Object execute(Object var1, PTuple var2);

        @Specialization
        static Object calculate(Object metatype, PTuple bases, @Bind Node inliningTarget, @Cached GetClassNode getClass, @Cached IsSubtypeNode isSubType, @Cached IsSubtypeNode isSubTypeReverse, @Cached PRaiseNode raiseNode) {
            CompilerAsserts.neverPartOfCompilation();
            SequenceStorage storage = bases.getSequenceStorage();
            int nbases = storage.length();
            Object winner = metatype;
            for (int i = 0; i < nbases; ++i) {
                Object tmp = SequenceStorageNodes.GetItemScalarNode.executeUncached(storage, i);
                Object tmpType = getClass.execute(inliningTarget, tmp);
                if (isSubType.execute(winner, tmpType)) continue;
                if (isSubTypeReverse.execute(tmpType, winner)) {
                    winner = tmpType;
                    continue;
                }
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.METACLASS_CONFLICT);
            }
            return winner;
        }
    }

    @ImportStatic(value={SpecialMethodNames.class})
    @GenerateInline(value=false)
    static abstract class UpdateBasesNode
    extends Node {
        UpdateBasesNode() {
        }

        abstract PTuple execute(PTuple var1, Object[] var2, int var3);

        @Specialization
        static PTuple update(PTuple bases, Object[] arguments, int nargs, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PyObjectLookupAttr getMroEntries, @Cached CallUnaryMethodNode callMroEntries, @Cached PRaiseNode raiseNode) {
            CompilerAsserts.neverPartOfCompilation();
            ArrayList<Object> newBases = null;
            for (int i = 0; i < nargs; ++i) {
                Object base = arguments[i];
                if (TypeNodes.IsTypeNode.executeUncached(base)) {
                    if (newBases == null) continue;
                    newBases.add(base);
                    continue;
                }
                Object meth = getMroEntries.execute(null, inliningTarget, base, SpecialMethodNames.T___MRO_ENTRIES__);
                if (PGuards.isNoValue(meth)) {
                    if (newBases == null) continue;
                    newBases.add(base);
                    continue;
                }
                Object newBase = callMroEntries.executeObject(null, meth, bases);
                if (!PGuards.isPTuple(newBase)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.MRO_ENTRIES_MUST_RETURN_TUPLE);
                }
                PTuple newBaseTuple = (PTuple)newBase;
                if (newBases == null) {
                    newBases = new ArrayList<Object>();
                    for (int j = 0; j < i; ++j) {
                        newBases.add(arguments[j]);
                    }
                }
                SequenceStorage storage = newBaseTuple.getSequenceStorage();
                for (int j = 0; j < storage.length(); ++j) {
                    newBases.add(SequenceStorageNodes.GetItemScalarNode.executeUncached(storage, j));
                }
            }
            if (newBases == null) {
                return bases;
            }
            return PFactory.createTuple(language, newBases.toArray());
        }
    }

    @Builtin(name="open", minNumOfPositionalArgs=1, parameterNames={"file", "mode", "buffering", "encoding", "errors", "newline", "closefd", "opener"})
    @ArgumentsClinic(value={@ArgumentClinic(name="mode", conversionClass=IONodes.CreateIOModeNode.class, args={"true"}), @ArgumentClinic(name="buffering", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="newline", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="closefd", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true", useDefaultForNone=true)})
    @ImportStatic(value={IONodes.IOMode.class})
    @GenerateNodeFactory
    public static abstract class OpenNode
    extends IOModuleBuiltins.IOOpenNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BuiltinFunctionsClinicProviders.OpenNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="vars", maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class VarsNode
    extends PythonUnaryBuiltinNode {
        VarsNode() {
        }

        @Specialization(guards={"isNoValue(none)"})
        static Object vars(VirtualFrame frame, PNone none, @Bind Node inliningTarget, @Cached PyEvalGetLocals getLocals) {
            return getLocals.execute(frame, inliningTarget);
        }

        @Specialization(guards={"!isNoValue(obj)"})
        static Object vars(VirtualFrame frame, Object obj, @Bind Node inliningTarget, @Cached PyObjectLookupAttr lookupAttr, @Cached PRaiseNode raiseNode) {
            Object dict = lookupAttr.execute((Frame)frame, inliningTarget, obj, SpecialAttributeNames.T___DICT__);
            if (dict == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.VARS_ARGUMENT_MUST_HAVE_DICT);
            }
            return dict;
        }
    }

    @Builtin(name="locals", needsFrame=true, alwaysNeedsCallerFrame=true)
    @GenerateNodeFactory
    static abstract class LocalsNode
    extends PythonBuiltinNode {
        LocalsNode() {
        }

        @Specialization
        Object locals(VirtualFrame frame, @Bind Node inliningTarget, @Cached PyEvalGetLocals getLocals) {
            return getLocals.execute(frame, inliningTarget);
        }
    }

    @Builtin(name="globals", needsFrame=true, alwaysNeedsCallerFrame=true)
    @GenerateNodeFactory
    static abstract class GlobalsNode
    extends PythonBuiltinNode {
        private final ConditionProfile condProfile = ConditionProfile.create();

        GlobalsNode() {
        }

        @Specialization
        public Object globals(VirtualFrame frame, @Bind Node inliningTarget, @Cached PyEvalGetGlobals getGlobals, @Cached GetOrCreateDictNode getDict) {
            Object globals = getGlobals.execute(frame, inliningTarget);
            if (this.condProfile.profile(globals instanceof PythonModule)) {
                return getDict.execute(inliningTarget, globals);
            }
            return globals;
        }
    }

    @Builtin(name="sum", minNumOfPositionalArgs=1, parameterNames={"iterable", "start"})
    @GenerateNodeFactory
    public static abstract class SumFunctionNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object sum(VirtualFrame frame, Object iterable, Object start, @Bind Node inliningTarget, @Cached InlinedConditionProfile defaultStart, @Cached PRaiseNode raiseNode, @Cached PyObjectGetIter getIter, @Cached SumIteratorNode sumIteratorNode) {
            if (defaultStart.profile(inliningTarget, start == PNone.NO_VALUE)) {
                start = 0;
            } else {
                if (PGuards.isString(start)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SUM_STRINGS);
                }
                if (start instanceof PBytes) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SUM_BYTES);
                }
                if (start instanceof PByteArray) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SUM_BYTEARRAY);
                }
            }
            Object iterator = getIter.execute((Frame)frame, inliningTarget, iterable);
            return sumIteratorNode.execute(frame, inliningTarget, iterator, start);
        }

        @GenerateInline
        @GenerateCached(value=false)
        @ImportStatic(value={PGuards.class})
        static abstract class SumIteratorNode
        extends Node {
            SumIteratorNode() {
            }

            public abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4);

            @Specialization
            static Object sumIntIterator(VirtualFrame frame, Node inliningTarget, PIntegerSequenceIterator iterator, int start, @Cached.Shared @Cached InlinedLoopConditionProfile loopProfilePrimitive, @Cached.Shared @Cached InlinedLoopConditionProfile loopProfileGeneric, @Cached.Shared @Cached InlinedBranchProfile overflowProfile, @Cached.Shared @Cached PyNumberAddNode addNode, @Cached.Shared @Cached InlinedConditionProfile resultFitsInInt) {
                long longResult = start;
                while (loopProfilePrimitive.profile(inliningTarget, iterator.hasNext())) {
                    long next = iterator.next();
                    try {
                        longResult = PythonUtils.addExact(longResult, next);
                    }
                    catch (OverflowException e) {
                        overflowProfile.enter(inliningTarget);
                        Object objectResult = addNode.execute(frame, longResult, next);
                        while (loopProfileGeneric.profile(inliningTarget, iterator.hasNext())) {
                            objectResult = addNode.execute(frame, objectResult, iterator.next());
                        }
                        return objectResult;
                    }
                }
                return SumIteratorNode.maybeInt(inliningTarget, resultFitsInInt, longResult);
            }

            @Specialization
            static Object sumLongIterator(VirtualFrame frame, Node inliningTarget, PLongSequenceIterator iterator, int start, @Cached.Shared @Cached InlinedLoopConditionProfile loopProfilePrimitive, @Cached.Shared @Cached InlinedLoopConditionProfile loopProfileGeneric, @Cached.Shared @Cached InlinedBranchProfile overflowProfile, @Cached.Shared @Cached PyNumberAddNode addNode, @Cached.Shared @Cached InlinedConditionProfile resultFitsInInt) {
                long longResult = start;
                while (loopProfilePrimitive.profile(inliningTarget, iterator.hasNext())) {
                    long next = iterator.next();
                    try {
                        longResult = PythonUtils.addExact(longResult, next);
                    }
                    catch (OverflowException e) {
                        overflowProfile.enter(inliningTarget);
                        Object objectResult = addNode.execute(frame, longResult, next);
                        while (loopProfileGeneric.profile(inliningTarget, iterator.hasNext())) {
                            objectResult = addNode.execute(frame, objectResult, iterator.next());
                        }
                        return objectResult;
                    }
                }
                return SumIteratorNode.maybeInt(inliningTarget, resultFitsInInt, longResult);
            }

            @Specialization(guards={"isDouble(start) || isInt(start)"})
            static Object sumDoubleIterator(Node inliningTarget, PDoubleSequenceIterator iterator, Object start, @Cached @Cached.Exclusive InlinedConditionProfile startIsDouble, @Cached.Shared @Cached InlinedLoopConditionProfile loopProfilePrimitive) {
                double result;
                if (!iterator.hasNext()) {
                    return start;
                }
                double d = result = startIsDouble.profile(inliningTarget, start instanceof Double) ? (Double)start : (double)((Integer)start).intValue();
                while (loopProfilePrimitive.profile(inliningTarget, iterator.hasNext())) {
                    result += iterator.next();
                }
                return result;
            }

            @Fallback
            static Object sumGeneric(VirtualFrame frame, Node inliningTarget, Object iterator, Object start, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfilePrimitive, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfileGeneric, @Cached PyIterNextNode nextNode, @Cached.Shared @Cached PyNumberAddNode addNode, @Cached.Exclusive @Cached InlinedConditionProfile resultFitsInInt, @Cached.Exclusive @Cached InlinedBranchProfile seenObject, @Cached.Exclusive @Cached InlinedBranchProfile seenInt, @Cached.Exclusive @Cached InlinedBranchProfile seenDouble, @Cached.Exclusive @Cached InlinedBranchProfile genericBranch) {
                Object next;
                try {
                    next = nextNode.execute((Frame)frame, inliningTarget, iterator);
                }
                catch (IteratorExhausted e) {
                    return start;
                }
                Object acc = addNode.execute(frame, start, next);
                if (acc instanceof Integer || acc instanceof Long) {
                    seenInt.enter(inliningTarget);
                    long longAcc = acc instanceof Integer ? (long)((Integer)acc).intValue() : (Long)acc;
                    boolean exitLoop = false;
                    boolean exhausted = false;
                    while (loopProfilePrimitive.profile(inliningTarget, !exitLoop)) {
                        try {
                            next = nextNode.execute((Frame)frame, inliningTarget, iterator);
                            if (next instanceof Integer) {
                                Integer nextInt = (Integer)next;
                                longAcc = PythonUtils.addExact(longAcc, (long)nextInt.intValue());
                                continue;
                            }
                            if (next instanceof Long) {
                                Long nextLong = (Long)next;
                                longAcc = PythonUtils.addExact(longAcc, nextLong);
                                continue;
                            }
                            exitLoop = true;
                        }
                        catch (OverflowException e) {
                            exitLoop = true;
                        }
                        catch (IteratorExhausted e) {
                            exitLoop = true;
                            exhausted = true;
                        }
                    }
                    if (exhausted) {
                        return SumIteratorNode.maybeInt(inliningTarget, resultFitsInInt, longAcc);
                    }
                    genericBranch.enter(inliningTarget);
                    acc = longAcc;
                } else if (acc instanceof Double) {
                    Double doubleAcc = (Double)acc;
                    seenDouble.enter(inliningTarget);
                    boolean exitLoop = false;
                    boolean exhausted = false;
                    while (loopProfilePrimitive.profile(inliningTarget, !exitLoop)) {
                        try {
                            next = nextNode.execute((Frame)frame, inliningTarget, iterator);
                            if (next instanceof Double) {
                                Double nextDouble = (Double)next;
                                doubleAcc = doubleAcc + nextDouble;
                                continue;
                            }
                            exitLoop = true;
                        }
                        catch (IteratorExhausted e) {
                            exitLoop = true;
                            exhausted = true;
                        }
                    }
                    if (exhausted) {
                        return doubleAcc;
                    }
                    genericBranch.enter(inliningTarget);
                    acc = doubleAcc;
                } else {
                    seenObject.enter(inliningTarget);
                    try {
                        next = nextNode.execute((Frame)frame, inliningTarget, iterator);
                    }
                    catch (IteratorExhausted e) {
                        return acc;
                    }
                }
                boolean exhausted = false;
                do {
                    acc = addNode.execute(frame, acc, next);
                    try {
                        next = nextNode.execute((Frame)frame, inliningTarget, iterator);
                    }
                    catch (IteratorExhausted e) {
                        exhausted = true;
                    }
                } while (loopProfileGeneric.profile(inliningTarget, !exhausted));
                return acc;
            }

            private static long maybeInt(Node inliningTarget, InlinedConditionProfile resultFitsInInt, long result) {
                if (resultFitsInInt.profile(inliningTarget, PInt.isIntRange(result))) {
                    return (int)result;
                }
                return result;
            }
        }
    }

    @Builtin(name="pow", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=0, parameterNames={"base", "exp", "mod"})
    @GenerateNodeFactory
    public static abstract class PowNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        Object ternary(VirtualFrame frame, Object x, Object y, Object z, @Cached PyNumberPowerNode power) {
            return power.execute(frame, x, y, z);
        }
    }

    @Builtin(name="breakpoint", takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class BreakPointNode
    extends PythonBuiltinNode {
        @Node.Child
        private ReadAttributeFromObjectNode getBreakpointhookNode;
        @Node.Child
        private CallNode callNode;

        @Specialization
        Object doIt(VirtualFrame frame, Object[] args, PKeyword[] kwargs, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PRaiseNode raiseNode) {
            if (this.getDebuggerSessionCount() > 0) {
                return PNone.NONE;
            }
            if (this.getContext().isInitialized()) {
                PDict sysModules;
                Object sysModule;
                Object breakpointhook;
                if (this.callNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getBreakpointhookNode = (ReadAttributeFromObjectNode)this.insert(ReadAttributeFromObjectNode.create());
                    this.callNode = (CallNode)this.insert(CallNode.create());
                }
                if ((breakpointhook = this.getBreakpointhookNode.execute(sysModule = getItem.execute(inliningTarget, (sysModules = this.getContext().getSysModules()).getDictStorage(), BuiltinNames.T_SYS), BuiltinNames.T_BREAKPOINTHOOK)) == PNone.NO_VALUE) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.LOST_SYSBREAKPOINTHOOK);
                }
                return this.callNode.execute((Frame)frame, breakpointhook, args, kwargs);
            }
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        private int getDebuggerSessionCount() {
            return Debugger.find((TruffleLanguage.Env)this.getContext().getEnv()).getSessionCount();
        }
    }

    @Builtin(name="sorted", minNumOfPositionalArgs=1, parameterNames={"$self"}, keywordOnlyNames={"key", "reverse"})
    @ArgumentClinic(name="reverse", conversion=ArgumentClinic.ClinicConversion.IntToBoolean, defaultValue="false")
    @GenerateNodeFactory
    public static abstract class SortedNode
    extends PythonClinicBuiltinNode {
        public abstract Object executeInternal(VirtualFrame var1, Object var2, Object var3, boolean var4);

        @Specialization
        Object sorted(VirtualFrame frame, Object iterable, Object keyfunc, boolean reverse, @Cached ListNodes.ConstructListNode constructListNode, @Cached ListBuiltins.ListSortNode sortNode) {
            PList list = constructListNode.execute((Frame)frame, iterable);
            sortNode.execute(frame, list, keyfunc, reverse);
            return list;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BuiltinFunctionsClinicProviders.SortedNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="hasattr", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class HasAttrNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        boolean hasAttr(VirtualFrame frame, Object object, Object key, @Bind Node inliningTarget, @Cached PyObjectLookupAttrO pyObjectLookupAttr) {
            return pyObjectLookupAttr.execute((Frame)frame, inliningTarget, object, key) != PNone.NO_VALUE;
        }
    }

    @Builtin(name="setattr", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class SetAttrNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static Object setAttr(VirtualFrame frame, Object object, Object key, Object value, @Bind Node inliningTarget, @Cached PyObjectSetAttrO setAttrNode) {
            setAttrNode.execute((Frame)frame, inliningTarget, object, key, value);
            return PNone.NONE;
        }
    }

    @Builtin(name="round", minNumOfPositionalArgs=1, parameterNames={"number", "ndigits"})
    @GenerateNodeFactory
    public static abstract class RoundNode
    extends PythonBuiltinNode {
        @Specialization
        static Object round(VirtualFrame frame, Object x, PNone n, @Bind Node inliningTarget, @Cached(value="create(T___ROUND__)") LookupAndCallUnaryNode callRound, @Cached.Shared @Cached PRaiseNode raiseNode) {
            Object result = callRound.executeObject(frame, x);
            if (result == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.TYPE_DOESNT_DEFINE_METHOD, x, SpecialMethodNames.T___ROUND__);
            }
            return result;
        }

        @Specialization(guards={"!isPNone(n)"})
        static Object round(VirtualFrame frame, Object x, Object n, @Bind Node inliningTarget, @Cached(value="create(T___ROUND__)") LookupAndCallBinaryNode callRound, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                return callRound.executeObject(frame, x, n);
            }
            catch (SpecialMethodNotFound ignore) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.TYPE_DOESNT_DEFINE_METHOD, x, SpecialMethodNames.T___ROUND__);
            }
        }
    }

    @Builtin(name="ascii", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AsciiNode
    extends PythonUnaryBuiltinNode {
        AsciiNode() {
        }

        @Specialization
        public static TruffleString ascii(VirtualFrame frame, Object obj, @Bind Node inliningTarget, @Cached PyObjectAsciiNode asciiNode) {
            return asciiNode.execute((Frame)frame, inliningTarget, obj);
        }
    }

    @Builtin(name="format", minNumOfPositionalArgs=1, parameterNames={"object", "format_spec"})
    @GenerateNodeFactory
    @OperationProxy.Proxyable
    @ImportStatic(value={PGuards.class})
    public static abstract class FormatNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public static Object format(VirtualFrame frame, Object obj, Object formatSpec, @Bind Node inliningTarget, @Cached(value="create(T___FORMAT__)") LookupAndCallBinaryNode callFormat, @Cached InlinedConditionProfile formatIsNoValueProfile, @Cached PRaiseNode raiseNode) {
            Object format = formatIsNoValueProfile.profile(inliningTarget, PGuards.isNoValue(formatSpec)) ? StringLiterals.T_EMPTY_STRING : formatSpec;
            try {
                Object res = callFormat.executeObject(frame, obj, format);
                if (!PGuards.isString(res)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_MUST_RETURN_S_NOT_P, SpecialMethodNames.T___FORMAT__, "str", res);
                }
                return res;
            }
            catch (SpecialMethodNotFound ignore) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.TYPE_DOESNT_DEFINE_FORMAT, obj);
            }
        }

        @NeverDefault
        public static FormatNode create() {
            return BuiltinFunctionsFactory.FormatNodeFactory.create();
        }
    }

    @Builtin(name="repr", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object repr(VirtualFrame frame, Object obj, @Bind Node inliningTarget, @Cached PyObjectReprAsObjectNode reprNode) {
            return reprNode.execute((Frame)frame, inliningTarget, obj);
        }
    }

    @Builtin(name="print", takesVarArgs=true, keywordOnlyNames={"sep", "end", "file", "flush"}, doc="\nprint(value, ..., sep=' ', end='\\n', file=sys.stdout, flush=False)\n\nPrints the values to a stream, or to sys.stdout by default.\nOptional keyword arguments:\nfile:  a file-like object (stream); defaults to the current sys.stdout.\nsep:   string inserted between values, default a space.\nend:   string appended after the last value, default a newline.\nflush: whether to forcibly flush the stream.")
    @GenerateNodeFactory
    public static abstract class PrintNode
    extends PythonBuiltinNode {
        @Node.Child
        private ReadAttributeFromObjectNode readStdout;
        @CompilerDirectives.CompilationFinal
        private PythonModule cachedSys;

        @Specialization
        PNone printNoKeywords(VirtualFrame frame, Object[] values, PNone sep, PNone end, PNone file, PNone flush, @Bind Node inliningTarget, @Cached.Shared(value="getWriteMethod") @Cached PyObjectGetAttr getWriteMethod, @Cached.Shared(value="callWrite") @Cached CallNode callWrite, @Cached.Shared(value="callFlush") @Cached PyObjectCallMethodObjArgs callFlush, @Cached.Shared(value="strNode") @Cached PyObjectStrAsObjectNode strNode) {
            Object stdout = this.getStdout();
            if (stdout == PNone.NONE) {
                return PNone.NONE;
            }
            return PrintNode.printAllGiven(frame, values, StringLiterals.T_SPACE, StringLiterals.T_NEWLINE, stdout, false, inliningTarget, getWriteMethod, callWrite, callFlush, strNode);
        }

        @Specialization(guards={"!isNone(file)", "!isNoValue(file)"})
        static PNone printAllGiven(VirtualFrame frame, Object[] values, TruffleString sep, TruffleString end, Object file, boolean flush, @Bind Node inliningTarget, @Cached.Shared(value="getWriteMethod") @Cached PyObjectGetAttr getWriteMethod, @Cached.Shared(value="callWrite") @Cached CallNode callWrite, @Cached.Shared(value="callFlush") @Cached PyObjectCallMethodObjArgs callFlush, @Cached.Shared(value="strNode") @Cached PyObjectStrAsObjectNode strNode) {
            int lastValue = values.length - 1;
            Object writeMethod = getWriteMethod.execute((Frame)frame, inliningTarget, file, IONodes.T_WRITE);
            for (int i = 0; i < lastValue; ++i) {
                callWrite.execute((Frame)frame, writeMethod, strNode.execute((Frame)frame, inliningTarget, values[i]));
                callWrite.execute((Frame)frame, writeMethod, sep);
            }
            if (lastValue >= 0) {
                callWrite.execute((Frame)frame, writeMethod, strNode.execute((Frame)frame, inliningTarget, values[lastValue]));
            }
            callWrite.execute((Frame)frame, writeMethod, end);
            if (flush) {
                callFlush.execute((Frame)frame, inliningTarget, file, IONodes.T_FLUSH, new Object[0]);
            }
            return PNone.NONE;
        }

        @Specialization(replaces={"printAllGiven", "printNoKeywords"})
        PNone printGeneric(VirtualFrame frame, Object[] values, Object sepIn, Object endIn, Object fileIn, Object flushIn, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castSep, @Cached CastToTruffleStringNode castEnd, @Cached PyObjectIsTrueNode castFlush, @Cached.Exclusive @Cached PyObjectGetAttr getWriteMethod, @Cached.Exclusive @Cached CallNode callWrite, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callFlush, @Cached.Exclusive @Cached PyObjectStrAsObjectNode strNode, @Cached PRaiseNode raiseNode) {
            Object file;
            TruffleString end;
            TruffleString sep;
            try {
                sep = sepIn instanceof PNone ? StringLiterals.T_SPACE : castSep.execute(inliningTarget, sepIn);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.SEP_MUST_BE_NONE_OR_STRING, sepIn);
            }
            try {
                end = endIn instanceof PNone ? StringLiterals.T_NEWLINE : castEnd.execute(inliningTarget, endIn);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_BE_NONE_OR_STRING, "end", sepIn);
            }
            if (fileIn instanceof PNone) {
                file = this.getStdout();
                if (file == PNone.NONE) {
                    return PNone.NONE;
                }
            } else {
                file = fileIn;
            }
            boolean flush = flushIn instanceof PNone ? false : castFlush.execute((Frame)frame, flushIn);
            return PrintNode.printAllGiven(frame, values, sep, end, file, flush, inliningTarget, getWriteMethod, callWrite, callFlush, strNode);
        }

        private Object getStdout() {
            Object stdout;
            PythonModule sys;
            if (this.getLanguage().isSingleContext()) {
                if (this.cachedSys == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.cachedSys = this.getContext().lookupBuiltinModule(BuiltinNames.T_SYS);
                }
                sys = this.cachedSys;
            } else {
                if (this.cachedSys != null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.cachedSys = null;
                }
                sys = this.getContext().lookupBuiltinModule(BuiltinNames.T_SYS);
            }
            if (this.readStdout == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readStdout = (ReadAttributeFromObjectNode)this.insert(ReadAttributeFromObjectNode.create());
            }
            if ((stdout = this.readStdout.execute(sys, BuiltinNames.T_STDOUT)) == PNone.NO_VALUE) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.RuntimeError, ErrorMessages.LOST_SYSSTDOUT);
            }
            return stdout;
        }
    }

    @Builtin(name="ord", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    public static abstract class OrdNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isString(chrObj)"})
        static int ord(Object chrObj, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            TruffleString chr;
            try {
                chr = castToStringNode.execute(inliningTarget, chrObj);
            }
            catch (CannotCastException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)((Object)e));
            }
            int len = codePointLengthNode.execute((AbstractTruffleString)chr, PythonUtils.TS_ENCODING);
            if (len != 1) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.EXPECTED_CHARACTER_BUT_STRING_FOUND, "ord()", len);
            }
            return codePointAtIndexNode.execute((AbstractTruffleString)chr, 0, PythonUtils.TS_ENCODING);
        }

        @Specialization
        static long ord(PBytesLike chr, @Bind Node inliningTarget, @Cached CastToJavaLongExactNode castNode, @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            int len = chr.getSequenceStorage().length();
            if (len != 1) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.EXPECTED_CHARACTER_BUT_STRING_FOUND, "ord()", len);
            }
            return castNode.execute(inliningTarget, getItemNode.execute(chr.getSequenceStorage(), 0));
        }

        @Specialization(guards={"!isString(obj)", "!isBytes(obj)"})
        static Object ord(Object obj, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_EXPECTED_STRING_OF_LEN_BUT_P, "ord()", "1", "obj");
        }
    }

    @Builtin(name="next", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class NextNode
    extends PythonBinaryBuiltinNode {
        NextNode() {
        }

        @Specialization
        static Object next(VirtualFrame frame, Object iterator, Object defaultObject, @Bind Node inliningTarget, @Cached InlinedConditionProfile defaultIsNoValue, @Cached TpSlots.GetObjectSlotsNode getSlots, @Cached TpSlotIterNext.CallSlotTpIterNextNode callIterNext, @Cached PRaiseNode raiseTypeError, @Cached PRaiseNode raiseStopIteration, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile) {
            TpSlots slots = getSlots.execute(inliningTarget, iterator);
            if (!PyIterCheckNode.checkSlots(slots)) {
                throw raiseTypeError.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_ISNT_ITERATOR, iterator);
            }
            try {
                return callIterNext.execute(frame, inliningTarget, slots.tp_iternext(), iterator);
            }
            catch (IteratorExhausted e) {
                if (defaultIsNoValue.profile(inliningTarget, defaultObject == PNone.NO_VALUE)) {
                    throw raiseStopIteration.raise(inliningTarget, PythonBuiltinClassType.StopIteration);
                }
                return defaultObject;
            }
            catch (PException e) {
                if (defaultIsNoValue.profile(inliningTarget, defaultObject == PNone.NO_VALUE)) {
                    throw e;
                }
                e.expectStopIteration(inliningTarget, stopIterationProfile);
                return defaultObject;
            }
        }
    }

    @Builtin(name="min", minNumOfPositionalArgs=1, takesVarArgs=true, keywordOnlyNames={"key", "default"})
    @GenerateNodeFactory
    public static abstract class MinNode
    extends PythonBuiltinNode {
        @Specialization
        static Object min(VirtualFrame frame, Object arg1, Object[] args, Object keywordArgIn, Object defaultVal, @Bind Node inliningTarget, @Cached MinMaxNode minMaxNode) {
            return minMaxNode.execute(frame, inliningTarget, arg1, args, keywordArgIn, defaultVal, "min", RichCmpOp.Py_LT);
        }
    }

    @Builtin(name="max", minNumOfPositionalArgs=1, takesVarArgs=true, keywordOnlyNames={"key", "default"}, doc="max(iterable, *[, default=obj, key=func]) -> value\nmax(arg1, arg2, *args, *[, key=func]) -> value\n\nWith a single iterable argument, return its biggest item. The\ndefault keyword-only argument specifies an object to return if\nthe provided iterable is empty.\nWith two or more arguments, return the largest argument.")
    @GenerateNodeFactory
    public static abstract class MaxNode
    extends PythonBuiltinNode {
        @Specialization
        static Object max(VirtualFrame frame, Object arg1, Object[] args, Object keywordArgIn, Object defaultVal, @Bind Node inliningTarget, @Cached MinMaxNode minMaxNode) {
            return minMaxNode.execute(frame, inliningTarget, arg1, args, keywordArgIn, defaultVal, "max", RichCmpOp.Py_GT);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class MinMaxNode
    extends Node {
        abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object[] var4, Object var5, Object var6, String var7, RichCmpOp var8);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Specialization(guards={"args.length == 0"})
        static Object minmaxSequenceWithKey(VirtualFrame frame, Node inliningTarget, Object arg1, Object[] args, Object keywordArgIn, Object defaultVal, String name, RichCmpOp op, @Cached.Exclusive @Cached PyObjectRichCompareBool compareNode, @Cached.Exclusive @Cached PyObjectGetIter getIter, @Cached.Exclusive @Cached PyIterNextNode nextNode, @Cached.Exclusive @Cached CallNode.Lazy keyCall, @Cached.Exclusive @Cached InlinedConditionProfile keywordArgIsNone, @Cached.Exclusive @Cached InlinedConditionProfile hasDefaultProfile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object currentValue;
            boolean kwArgsAreNone = keywordArgIsNone.profile(inliningTarget, PGuards.isPNone(keywordArgIn));
            Object keywordArg = kwArgsAreNone ? null : keywordArgIn;
            Object iterator = getIter.execute((Frame)frame, inliningTarget, arg1);
            try {
                currentValue = nextNode.execute((Frame)frame, inliningTarget, iterator);
            }
            catch (IteratorExhausted e) {
                if (hasDefaultProfile.profile(inliningTarget, PGuards.isNoValue(defaultVal))) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.ITERABLE_ARG_IS_EMPTY, name);
                }
                return defaultVal;
            }
            Object currentKey = MinMaxNode.applyKeyFunction(frame, inliningTarget, keywordArg, keyCall, currentValue);
            int loopCount = 0;
            while (true) {
                Object nextValue = nextNode.execute((Frame)frame, inliningTarget, iterator);
                Object nextKey = MinMaxNode.applyKeyFunction(frame, inliningTarget, keywordArg, keyCall, nextValue);
                boolean isTrue = compareNode.execute((Frame)frame, inliningTarget, nextKey, currentKey, op);
                if (isTrue) {
                    currentKey = nextKey;
                    currentValue = nextValue;
                }
                LoopNode.reportLoopCount((Node)inliningTarget, (int)(++loopCount < 0 ? Integer.MAX_VALUE : loopCount));
            }
            catch (IteratorExhausted e) {
                LoopNode.reportLoopCount((Node)inliningTarget, (int)(loopCount < 0 ? Integer.MAX_VALUE : loopCount));
                catch (Throwable throwable) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)(loopCount < 0 ? Integer.MAX_VALUE : loopCount));
                    throw throwable;
                }
            }
            return currentValue;
        }

        @Specialization(guards={"args.length != 0"})
        static Object minmaxBinaryWithKey(VirtualFrame frame, Node inliningTarget, Object arg1, Object[] args, Object keywordArgIn, Object defaultVal, String name, RichCmpOp op, @Cached.Exclusive @Cached PyObjectRichCompareBool compareNode, @Cached.Exclusive @Cached CallNode.Lazy keyCall, @Cached.Exclusive @Cached InlinedConditionProfile keywordArgIsNone, @Cached.Exclusive @Cached InlinedConditionProfile moreThanTwo, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile, @Cached.Exclusive @Cached InlinedConditionProfile hasDefaultProfile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object keywordArg;
            boolean kwArgsAreNone = keywordArgIsNone.profile(inliningTarget, PGuards.isPNone(keywordArgIn));
            Object object = keywordArg = kwArgsAreNone ? null : keywordArgIn;
            if (!hasDefaultProfile.profile(inliningTarget, PGuards.isNoValue(defaultVal))) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_SPECIFY_DEFAULT_FOR_S, name);
            }
            Object currentValue = arg1;
            Object currentKey = MinMaxNode.applyKeyFunction(frame, inliningTarget, keywordArg, keyCall, currentValue);
            Object nextValue = args[0];
            Object nextKey = MinMaxNode.applyKeyFunction(frame, inliningTarget, keywordArg, keyCall, nextValue);
            boolean isTrue = compareNode.execute((Frame)frame, inliningTarget, nextKey, currentKey, op);
            if (isTrue) {
                currentKey = nextKey;
                currentValue = nextValue;
            }
            if (moreThanTwo.profile(inliningTarget, args.length > 1)) {
                loopProfile.profileCounted(inliningTarget, (long)args.length);
                LoopNode.reportLoopCount((Node)inliningTarget, (int)args.length);
                int i = 0;
                while (loopProfile.inject(inliningTarget, i < args.length)) {
                    nextValue = args[i];
                    nextKey = MinMaxNode.applyKeyFunction(frame, inliningTarget, keywordArg, keyCall, nextValue);
                    isTrue = compareNode.execute((Frame)frame, inliningTarget, nextKey, currentKey, op);
                    if (isTrue) {
                        currentKey = nextKey;
                        currentValue = nextValue;
                    }
                    ++i;
                }
            }
            return currentValue;
        }

        private static Object applyKeyFunction(VirtualFrame frame, Node inliningTarget, Object keywordArg, CallNode.Lazy keyCall, Object currentValue) {
            return keywordArg == null ? currentValue : keyCall.get(inliningTarget).execute((Frame)frame, keywordArg, new Object[]{currentValue}, PKeyword.EMPTY_KEYWORDS);
        }
    }

    @Builtin(name="len", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public int len(VirtualFrame frame, Object obj, @Bind Node inliningTarget, @Cached PyObjectSizeNode sizeNode) {
            return sizeNode.execute((Frame)frame, inliningTarget, obj);
        }
    }

    @Builtin(name="iter", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @ReportPolymorphism
    public static abstract class IterNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(sentinel)"})
        static Object iter(VirtualFrame frame, Object object, PNone sentinel, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter) {
            return getIter.execute((Frame)frame, inliningTarget, object);
        }

        @Specialization(guards={"callableCheck.execute(this, callable)", "!isNoValue(sentinel)"}, limit="1")
        static Object iter(Object callable, Object sentinel, @Bind Node inliningTarget, @Cached PyCallableCheckNode callableCheck, @Bind PythonLanguage language) {
            return PFactory.createSentinelIterator(language, callable, sentinel);
        }

        @Fallback
        static Object iterNotCallable(Object callable, Object sentinel, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ITER_V_MUST_BE_CALLABLE);
        }
    }

    @Builtin(name="issubclass", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class IsSubClassNode
    extends RecursiveBinaryCheckBaseNode {
        public abstract boolean executeBoolean(VirtualFrame var1, Object var2, Object var3);

        protected IsSubClassNode(byte depth) {
            super(depth);
        }

        protected IsSubClassNode() {
            this(0);
        }

        @Override
        public IsSubClassNode createRecursive(byte newDepth) {
            return BuiltinFunctionsFactory.IsSubClassNodeFactory.create(newDepth);
        }

        @Specialization(guards={"!isPTuple(cls)"})
        static boolean isSubclass(VirtualFrame frame, Object derived, Object cls, @Bind Node inliningTarget, @Cached GetClassNode getClsClassNode, @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile classProfile, @Cached(value="create(T___SUBCLASSCHECK__)") LookupAndCallBinaryNode subclassCheckNode, @Cached PyObjectIsTrueNode isTrueNode, @Cached TypeNodes.GenericSubclassCheckNode genericSubclassCheckNode, @Cached InlinedBranchProfile noInstanceCheckProfile) {
            if (classProfile.profileClass(inliningTarget, getClsClassNode.execute(inliningTarget, cls), PythonBuiltinClassType.PythonClass)) {
                return genericSubclassCheckNode.execute(frame, inliningTarget, derived, cls);
            }
            try {
                Object result = subclassCheckNode.executeObject(frame, cls, derived);
                return isTrueNode.execute((Frame)frame, result);
            }
            catch (SpecialMethodNotFound ignore) {
                noInstanceCheckProfile.enter(inliningTarget);
                return genericSubclassCheckNode.execute(frame, inliningTarget, derived, cls);
            }
        }

        @NeverDefault
        public static IsSubClassNode create() {
            return BuiltinFunctionsFactory.IsSubClassNodeFactory.create();
        }
    }

    @Builtin(name="isinstance", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class IsInstanceNode
    extends RecursiveBinaryCheckBaseNode {
        protected IsInstanceNode(byte depth) {
            super(depth);
        }

        protected IsInstanceNode() {
            this(0);
        }

        @Override
        public IsInstanceNode createRecursive(byte newDepth) {
            return BuiltinFunctionsFactory.IsInstanceNodeFactory.create(newDepth);
        }

        @Specialization(guards={"!isPTuple(cls)"})
        static boolean isInstance(VirtualFrame frame, Object instance, Object cls, @Bind Node inliningTarget, @Cached GetClassNode getClsClassNode, @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile classProfile, @Cached GetClassNode getInstanceClassNode, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached(value="create(T___INSTANCECHECK__)") LookupAndCallBinaryNode instanceCheckNode, @Cached PyObjectIsTrueNode isTrueNode, @Cached TypeNodes.GenericInstanceCheckNode genericInstanceCheckNode, @Cached InlinedBranchProfile noInstanceCheckProfile) {
            if (isSameTypeNode.execute(inliningTarget, getInstanceClassNode.execute(inliningTarget, instance), cls)) {
                return true;
            }
            if (classProfile.profileClass(inliningTarget, getClsClassNode.execute(inliningTarget, cls), PythonBuiltinClassType.PythonClass)) {
                return genericInstanceCheckNode.execute(frame, inliningTarget, instance, cls);
            }
            try {
                Object result = instanceCheckNode.executeObject(frame, cls, instance);
                return isTrueNode.execute((Frame)frame, result);
            }
            catch (SpecialMethodNotFound ignore) {
                noInstanceCheckProfile.enter(inliningTarget);
                return genericInstanceCheckNode.execute(frame, inliningTarget, instance, cls);
            }
        }
    }

    public static abstract class RecursiveBinaryCheckBaseNode
    extends PythonBinaryBuiltinNode {
        static final int MAX_EXPLODE_LOOP = 16;
        static final byte NON_RECURSIVE = 127;
        protected final byte depth;

        protected RecursiveBinaryCheckBaseNode(byte depth) {
            this.depth = depth;
        }

        public abstract boolean executeWith(VirtualFrame var1, Object var2, Object var3);

        @NeverDefault
        protected final RecursiveBinaryCheckBaseNode createRecursive() {
            return this.createRecursive((byte)(this.depth + 1));
        }

        @NeverDefault
        protected final RecursiveBinaryCheckBaseNode createNonRecursive() {
            return this.createRecursive((byte)127);
        }

        protected RecursiveBinaryCheckBaseNode createRecursive(byte newDepth) {
            throw new AbstractMethodError();
        }

        @Idempotent
        protected int getMaxExplodeLoop() {
            return 16 >> this.depth;
        }

        @Specialization(guards={"depth < getNodeRecursionLimit()", "getLength(clsTuple) == cachedLen", "cachedLen < getMaxExplodeLoop()"}, limit="getVariableArgumentInlineCacheLimit()")
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
        static boolean doTupleConstantLen(VirtualFrame frame, Object instance, PTuple clsTuple, @Bind Node inliningTarget, @Cached(value="getLength(clsTuple)") int cachedLen, @Cached.Shared @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Shared @Cached(value="createRecursive()") RecursiveBinaryCheckBaseNode recursiveNode) {
            Object[] array = getObjectArrayNode.execute(inliningTarget, clsTuple);
            for (int i = 0; i < cachedLen; ++i) {
                Object cls = array[i];
                if (!recursiveNode.executeWith(frame, instance, cls)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"depth < getNodeRecursionLimit()"}, replaces={"doTupleConstantLen"})
        static boolean doRecursiveWithNode(VirtualFrame frame, Object instance, PTuple clsTuple, @Bind Node inliningTarget, @Cached.Shared @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Shared @Cached(value="createRecursive()") RecursiveBinaryCheckBaseNode recursiveNode) {
            for (Object cls : getObjectArrayNode.execute(inliningTarget, clsTuple)) {
                if (!recursiveNode.executeWith(frame, instance, cls)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"depth != NON_RECURSIVE", "depth >= getNodeRecursionLimit()"})
        static boolean doRecursiveWithLoop(VirtualFrame frame, Object instance, PTuple clsTuple, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached.Shared @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached(value="createNonRecursive()") RecursiveBinaryCheckBaseNode node) {
            PythonContext context = PythonContext.get(inliningTarget);
            PythonLanguage language = context.getLanguage(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                boolean bl = RecursiveBinaryCheckBaseNode.callRecursiveWithNodeTruffleBoundary(inliningTarget, instance, clsTuple, getObjectArrayNode, node);
                return bl;
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
        }

        @Specialization(guards={"depth == NON_RECURSIVE"})
        boolean doRecursiveWithLoopReuseThis(VirtualFrame frame, Object instance, PTuple clsTuple, @Bind Node inliningTarget, @Cached.Shared @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode) {
            assert (frame == null);
            return RecursiveBinaryCheckBaseNode.callRecursiveWithNodeTruffleBoundary(inliningTarget, instance, clsTuple, getObjectArrayNode, this);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean callRecursiveWithNodeTruffleBoundary(Node inliningTarget, Object instance, PTuple clsTuple, SequenceNodes.GetObjectArrayNode getObjectArrayNode, RecursiveBinaryCheckBaseNode node) {
            return RecursiveBinaryCheckBaseNode.doRecursiveWithNode(null, instance, clsTuple, inliningTarget, getObjectArrayNode, node);
        }

        protected static int getLength(PTuple t) {
            return t.getSequenceStorage().length();
        }
    }

    @Builtin(name="id", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IdNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object doObject(Object value, @Cached ObjectNodes.GetIdNode getIdNode) {
            return getIdNode.execute(value);
        }
    }

    @Builtin(name="getattr", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class GetAttrNode
    extends PythonTernaryBuiltinNode {
        GetAttrNode() {
        }

        @Specialization(guards={"isNoValue(defaultValue)"})
        static Object getAttrNoDefault(VirtualFrame frame, Object primary, Object name, Object defaultValue, @Bind Node inliningTarget, @Cached PyObjectGetAttrO getAttr) {
            return getAttr.execute((Frame)frame, inliningTarget, primary, name);
        }

        @Specialization(guards={"!isNoValue(defaultValue)"})
        static Object getAttrWithDefault(VirtualFrame frame, Object primary, Object name, Object defaultValue, @Bind Node inliningTarget, @Cached InlinedConditionProfile noValueProfile, @Cached PyObjectLookupAttrO lookupAttr) {
            Object result = lookupAttr.execute((Frame)frame, inliningTarget, primary, name);
            if (noValueProfile.profile(inliningTarget, result == PNone.NO_VALUE)) {
                return defaultValue;
            }
            return result;
        }
    }

    @Builtin(name="delattr", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class DelAttrNode
    extends PythonBinaryBuiltinNode {
        DelAttrNode() {
        }

        @Specialization
        Object delattr(VirtualFrame frame, Object object, Object name, @Bind Node inliningTarget, @Cached PyObjectSetAttrO setAttr) {
            setAttr.execute((Frame)frame, inliningTarget, object, name, PNone.NO_VALUE);
            return PNone.NONE;
        }
    }

    @Builtin(name="compile", minNumOfPositionalArgs=3, parameterNames={"source", "filename", "mode", "flags", "dont_inherit", "optimize"}, keywordOnlyNames={"_feature_version"})
    @ArgumentsClinic(value={@ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0"), @ArgumentClinic(name="dont_inherit", conversion=ArgumentClinic.ClinicConversion.IntToBoolean, defaultValue="false"), @ArgumentClinic(name="optimize", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1"), @ArgumentClinic(name="_feature_version", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1")})
    @GenerateNodeFactory
    public static abstract class CompileNode
    extends PythonClinicBuiltinNode {
        private static final int CO_NESTED = 16;
        private static final int CO_FUTURE_DIVISION = 131072;
        private static final int CO_FUTURE_ABSOLUTE_IMPORT = 262144;
        private static final int CO_FUTURE_WITH_STATEMENT = 524288;
        private static final int CO_FUTURE_PRINT_FUNCTION = 0x100000;
        private static final int CO_FUTURE_UNICODE_LITERALS = 0x200000;
        private static final int CO_FUTURE_BARRY_AS_BDFL = FutureFeature.BARRY_AS_BDFL.flagValue;
        private static final int CO_FUTURE_GENERATOR_STOP = 0x800000;
        private static final int CO_FUTURE_ANNOTATIONS = FutureFeature.ANNOTATIONS.flagValue;
        private static final int PyCF_MASK = 0x3E0000 | CO_FUTURE_BARRY_AS_BDFL | 0x800000 | CO_FUTURE_ANNOTATIONS;
        private static final int PyCF_MASK_OBSOLETE = 16;
        private static final int PyCF_DONT_IMPLY_DEDENT = 512;
        public static final int PyCF_ONLY_AST = 1024;
        public static final int PyCF_TYPE_COMMENTS = 4096;
        public static final int PyCF_ALLOW_TOP_LEVEL_AWAIT = 8192;
        private static final int PyCF_ALLOW_INCOMPLETE_INPUT = 16384;
        private static final int PyCF_COMPILE_MASK = 30208;
        private final boolean mayBeFromFile;
        private final boolean lstrip;

        public CompileNode(boolean mayBeFromFile, boolean lstrip) {
            this.mayBeFromFile = mayBeFromFile;
            this.lstrip = lstrip;
        }

        public CompileNode() {
            this.mayBeFromFile = true;
            this.lstrip = false;
        }

        public final PCode compile(VirtualFrame frame, Object source, TruffleString filename, TruffleString mode, int optimize, int featureVersion) {
            return (PCode)this.executeInternal(frame, source, filename, mode, 0, false, optimize, featureVersion);
        }

        protected abstract Object executeInternal(VirtualFrame var1, Object var2, TruffleString var3, TruffleString var4, int var5, boolean var6, int var7, int var8);

        private int inheritFlags(VirtualFrame frame, int flags, ReadCallerFrameNode readCallerFrame) {
            PFrame fr = readCallerFrame.executeWith(frame, 0);
            if (fr != null) {
                PCode code = PFactory.createCode(PythonLanguage.get(this), fr.getTarget());
                flags |= code.getFlags() & PyCF_MASK;
            }
            return flags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object doCompile(VirtualFrame frame, TruffleString expression, TruffleString filename, TruffleString mode, int flags, boolean dontInherit, int optimize, int featureVersion, @Cached.Shared @Cached ReadCallerFrameNode readCallerFrame) {
            if (!dontInherit) {
                flags = this.inheritFlags(frame, flags, readCallerFrame);
            }
            EncapsulatingNodeReference encapsulating = EncapsulatingNodeReference.getCurrent();
            Node encapsulatingNode = encapsulating.set((Node)this);
            try {
                Object object = this.compile(expression, filename, mode, flags, dontInherit, optimize, featureVersion);
                return object;
            }
            finally {
                encapsulating.set(encapsulatingNode);
            }
        }

        @CompilerDirectives.TruffleBoundary
        Object compile(TruffleString expression, TruffleString filename, TruffleString mode, int flags, boolean dontInherit, int optimize, int featureVersion) {
            int c;
            this.checkFlags(flags);
            this.checkOptimize(optimize, optimize);
            this.checkSource(expression);
            TruffleString code = expression;
            PythonContext context = this.getContext();
            InputType type = this.getParserInputType(mode, flags);
            if (type == InputType.FUNCTION_TYPE && (flags & 0x400) == 0) {
                throw PRaiseNode.raiseStatic((Node)this, PythonErrorType.ValueError, ErrorMessages.COMPILE_MODE_FUNC_TYPE_REQUIED_FLAG_ONLY_AST);
            }
            if (this.lstrip && !code.isEmpty() && ((c = code.codePointAtIndexUncached(0, PythonUtils.TS_ENCODING)) == 32 || c == 9)) {
                code = code.substringUncached(1, code.codePointLengthUncached(PythonUtils.TS_ENCODING) - 1, PythonUtils.TS_ENCODING, true);
            }
            if ((flags & 0x400) != 0) {
                Source source = PythonLanguage.newSource(context, code, filename, this.mayBeFromFile, "text/x-python");
                ParserCallbacksImpl parserCb = new ParserCallbacksImpl(source, PythonOptions.isPExceptionWithJavaStacktrace(this.getLanguage()));
                EnumSet<AbstractParser.Flags> compilerFlags = EnumSet.noneOf(AbstractParser.Flags.class);
                if ((flags & 0x1000) != 0) {
                    compilerFlags.add(AbstractParser.Flags.TYPE_COMMENTS);
                }
                if (featureVersion < 0) {
                    featureVersion = 12;
                }
                if (featureVersion < 7) {
                    compilerFlags.add(AbstractParser.Flags.ASYNC_HACKS);
                }
                if (((Boolean)context.getEnv().getOptions().get(PythonOptions.ParserLogFiles)).booleanValue()) {
                    PythonLanguage.LOGGER.log(Level.FINE, () -> "parse '" + source.getName() + "'");
                }
                Parser parser = Compiler.createParser(code.toJavaStringUncached(), (ParserCallbacks)parserCb, type, compilerFlags, featureVersion);
                ModTy mod = (ModTy)parser.parse();
                parserCb.triggerDeprecationWarnings();
                return AstModuleBuiltins.sst2Obj(this.getContext(), mod);
            }
            TruffleString finalCode = code;
            Supplier createCode = () -> {
                if (type == InputType.FILE) {
                    Source source = PythonLanguage.newSource(context, finalCode, filename, this.mayBeFromFile, PythonLanguage.getCompileMimeType(optimize, flags));
                    return context.getEnv().parsePublic(source, new String[0]);
                }
                if (type == InputType.EVAL) {
                    Source source = PythonLanguage.newSource(context, finalCode, filename, this.mayBeFromFile, PythonLanguage.getEvalMimeType(optimize, flags));
                    return context.getEnv().parsePublic(source, new String[0]);
                }
                Source source = PythonLanguage.newSource(context, finalCode, filename, this.mayBeFromFile, "text/x-python");
                boolean allowIncomplete = (flags & 0x4000) != 0;
                return context.getLanguage().parse(context, source, InputType.SINGLE, false, optimize, false, allowIncomplete, null, FutureFeature.fromFlags(flags));
            };
            CallTarget ct = this.getContext().isCoreInitialized() ? (CallTarget)createCode.get() : this.getContext().getLanguage().cacheCode(filename, createCode);
            return CompileNode.wrapRootCallTarget((RootCallTarget)ct);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        Object generic(VirtualFrame frame, Object wSource, Object wFilename, TruffleString mode, int flags, boolean dontInherit, int optimize, int featureVersion, @CachedLibrary(limit="3") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Bind PythonContext context, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached CodecsModuleBuiltins.HandleDecodingErrorNode handleDecodingErrorNode, @Cached PyObjectStrAsTruffleStringNode asStrNode, @CachedLibrary(value="wSource") InteropLibrary interopLib, @Cached PyUnicodeFSDecoderNode asPath, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached ReadCallerFrameNode readCallerFrame, @Cached PRaiseNode raiseNode) {
            if (wSource instanceof PCode) {
                return wSource;
            }
            TruffleString filename = asPath.execute((Frame)frame, wFilename);
            if (!dontInherit) {
                flags = this.inheritFlags(frame, flags, readCallerFrame);
            }
            EncapsulatingNodeReference encapsulating = EncapsulatingNodeReference.getCurrent();
            Node encapsulatingNode = encapsulating.set((Node)this);
            try {
                if (AstModuleBuiltins.isAst(context, wSource)) {
                    ModTy mod = AstModuleBuiltins.obj2sst(inliningTarget, context, wSource, this.getParserInputType(mode, flags));
                    Source source = PythonUtils.createFakeSource(filename);
                    RootCallTarget rootCallTarget = context.getLanguage(inliningTarget).compileModule(context, mod, source, false, optimize, null, null, flags);
                    PCode pCode = CompileNode.wrapRootCallTarget(rootCallTarget);
                    return pCode;
                }
                TruffleString source = this.sourceAsString(frame, inliningTarget, wSource, filename, interopLib, acquireLib, bufferLib, handleDecodingErrorNode, asStrNode, switchEncodingNode, raiseNode, indirectCallData);
                this.checkSource(source);
                Object object = this.compile(source, filename, mode, flags, dontInherit, optimize, featureVersion);
                return object;
            }
            finally {
                encapsulating.set(encapsulatingNode);
            }
        }

        private static PCode wrapRootCallTarget(RootCallTarget rootCallTarget) {
            RootNode rootNode = rootCallTarget.getRootNode();
            if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
                if (rootNode instanceof PBytecodeDSLRootNode) {
                    PBytecodeDSLRootNode bytecodeDSLRootNode = (PBytecodeDSLRootNode)rootNode;
                    bytecodeDSLRootNode.triggerDeferredDeprecationWarnings();
                }
            } else if (rootNode instanceof PBytecodeRootNode) {
                PBytecodeRootNode bytecodeRootNode = (PBytecodeRootNode)rootNode;
                bytecodeRootNode.triggerDeferredDeprecationWarnings();
            }
            return PFactory.createCode(PythonLanguage.get(null), rootCallTarget);
        }

        @CompilerDirectives.TruffleBoundary
        private void checkSource(TruffleString source) throws PException {
            if (source.indexOfCodePointUncached(0, 0, source.codePointLengthUncached(PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) > -1) {
                throw PConstructAndRaiseNode.getUncached().executeWithArgsOnly(null, PythonBuiltinClassType.SyntaxError, new Object[]{ErrorMessages.SRC_CODE_CANNOT_CONTAIN_NULL_BYTES});
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void checkOptimize(int optimize, Object kwOptimize) throws PException {
            if (optimize < -1 || optimize > 2) {
                throw PRaiseNode.raiseStatic(this, PythonErrorType.TypeError, ErrorMessages.INVALID_OPTIMIZE_VALUE, kwOptimize);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void checkFlags(int flags) {
            if ((flags & ~(PyCF_MASK | 0x10 | 0x7600)) != 0) {
                throw PRaiseNode.raiseStatic(this, PythonErrorType.ValueError, null, PNone.NO_VALUE, ErrorMessages.UNRECOGNIZED_FLAGS, PythonUtils.EMPTY_OBJECT_ARRAY);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private InputType getParserInputType(TruffleString mode, int flags) {
            if (mode.equalsUncached((AbstractTruffleString)BuiltinNames.T_EXEC, PythonUtils.TS_ENCODING)) {
                return InputType.FILE;
            }
            if (mode.equalsUncached((AbstractTruffleString)BuiltinNames.T_EVAL, PythonUtils.TS_ENCODING)) {
                return InputType.EVAL;
            }
            if (mode.equalsUncached((AbstractTruffleString)StringLiterals.T_SINGLE, PythonUtils.TS_ENCODING)) {
                return InputType.SINGLE;
            }
            if (mode.equalsUncached((AbstractTruffleString)StringLiterals.T_FUNC_TYPE, PythonUtils.TS_ENCODING)) {
                return InputType.FUNCTION_TYPE;
            }
            if ((flags & 0x400) != 0) {
                throw PRaiseNode.raiseStatic((Node)this, PythonErrorType.ValueError, ErrorMessages.COMPILE_MODE_MUST_BE_AST_ONLY);
            }
            throw PRaiseNode.raiseStatic((Node)this, PythonErrorType.ValueError, ErrorMessages.COMPILE_MODE_MUST_BE);
        }

        TruffleString sourceAsString(VirtualFrame frame, Node inliningTarget, Object source, TruffleString filename, InteropLibrary interopLib, PythonBufferAcquireLibrary acquireLib, PythonBufferAccessLibrary bufferLib, CodecsModuleBuiltins.HandleDecodingErrorNode handleDecodingErrorNode, PyObjectStrAsTruffleStringNode asStrNode, TruffleString.SwitchEncodingNode switchEncodingNode, PRaiseNode raiseNode, IndirectCallData indirectCallData) {
            Object buffer;
            if (interopLib.isString(source)) {
                try {
                    return switchEncodingNode.execute((AbstractTruffleString)interopLib.asTruffleString(source), PythonUtils.TS_ENCODING);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            try {
                buffer = acquireLib.acquireReadonly(source, frame, indirectCallData);
            }
            catch (PException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ARG_D_MUST_BE_S, "compile()", 1, "string, bytes or AST object");
            }
            try {
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(source);
                int bytesLen = bufferLib.getBufferLength(source);
                Charset charset = PythonFileDetector.findEncodingStrict(bytes, bytesLen);
                TruffleString pythonEncodingNameFromJavaName = CharsetMapping.getPythonEncodingNameFromJavaName(charset.name());
                CodecsModuleBuiltins.TruffleDecoder decoder = new CodecsModuleBuiltins.TruffleDecoder(pythonEncodingNameFromJavaName, charset, bytes, bytesLen, CodingErrorAction.REPORT);
                if (!decoder.decodingStep(true)) {
                    try {
                        handleDecodingErrorNode.execute(frame, decoder, StringLiterals.T_STRICT, PFactory.createBytes(PythonLanguage.get(inliningTarget), bytes, bytesLen));
                        throw CompilerDirectives.shouldNotReachHere();
                    }
                    catch (PException e) {
                        throw this.raiseInvalidSyntax(filename, "(unicode error) %s", asStrNode.execute((Frame)frame, inliningTarget, e.getEscapedException()));
                    }
                }
                TruffleString truffleString = decoder.getString();
                return truffleString;
            }
            catch (PythonFileDetector.InvalidEncodingException e) {
                throw this.raiseInvalidSyntax(filename, "(unicode error) %s", e.getEncodingName());
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private RuntimeException raiseInvalidSyntax(TruffleString filename, String format, Object ... args) {
            PythonContext context = this.getContext();
            Source source = PythonLanguage.newSource(context, StringLiterals.T_SPACE, filename, this.mayBeFromFile, null);
            SourceRange sourceRange = new SourceRange(1, 0, 1, 0);
            TruffleString message = PythonUtils.toTruffleStringUncached(String.format(format, args));
            throw ParserCallbacksImpl.raiseSyntaxError(ParserCallbacks.ErrorType.Syntax, sourceRange, message, source, PythonOptions.isPExceptionWithJavaStacktrace(context.getLanguage()));
        }

        @NeverDefault
        public static CompileNode create(boolean mapFilenameToUri) {
            return BuiltinFunctionsFactory.CompileNodeFactory.create(mapFilenameToUri, false, new ReadArgumentNode[0]);
        }

        @NeverDefault
        public static CompileNode create(boolean mapFilenameToUri, boolean lstrip) {
            return BuiltinFunctionsFactory.CompileNodeFactory.create(mapFilenameToUri, lstrip, new ReadArgumentNode[0]);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BuiltinFunctionsClinicProviders.CompileNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="exec", minNumOfPositionalArgs=1, parameterNames={"source", "globals", "locals"})
    @GenerateNodeFactory
    public static abstract class ExecNode
    extends PythonBuiltinNode {
        @Specialization
        static Object exec(VirtualFrame frame, Object source, Object globals, Object locals, @Bind Node inliningTarget, @Cached EvalExecNode evalNode) {
            evalNode.execute(frame, inliningTarget, source, globals, locals, BuiltinNames.T_EXEC, false);
            return PNone.NONE;
        }
    }

    @Builtin(name="eval", minNumOfPositionalArgs=1, parameterNames={"expression", "globals", "locals"})
    @GenerateNodeFactory
    public static abstract class EvalNode
    extends PythonBuiltinNode {
        @Specialization
        static Object eval(VirtualFrame frame, Object source, Object globals, Object locals, @Bind Node inliningTarget, @Cached EvalExecNode evalNode) {
            return evalNode.execute(frame, inliningTarget, source, globals, locals, BuiltinNames.T_EVAL, true);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class EvalExecNode
    extends Node {
        EvalExecNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4, Object var5, TruffleString var6, boolean var7);

        @Specialization
        static Object eval(VirtualFrame frame, Node inliningTarget, Object source, Object globals, Object locals, TruffleString mode, boolean shouldStripLeadingWhitespace, @Cached(value="create(false, shouldStripLeadingWhitespace)") CompileNode compileNode, @Cached CreateEvalExecArgumentsNode createArguments, @Cached CodeNodes.GetCodeCallTargetNode getCallTarget, @Cached CallDispatchers.CallTargetCachedInvokeNode invoke, @Cached PRaiseNode raiseNode) {
            PCode code = compileNode.compile(frame, source, StringLiterals.T_STRING_SOURCE, mode, -1, -1);
            if (code.getFreeVars().length > 0) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CODE_OBJ_NO_FREE_VARIABLES, mode);
            }
            Object[] args = createArguments.execute(frame, inliningTarget, globals, locals, mode);
            RootCallTarget callTarget = getCallTarget.execute(inliningTarget, code);
            return invoke.execute(frame, inliningTarget, callTarget, args);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CreateEvalExecArgumentsNode
    extends Node {
        CreateEvalExecArgumentsNode() {
        }

        public abstract Object[] execute(VirtualFrame var1, Node var2, Object var3, Object var4, TruffleString var5);

        @Specialization
        static Object[] inheritGlobals(VirtualFrame frame, Node inliningTarget, PNone globals, Object locals, TruffleString mode, @Cached.Exclusive @Cached ReadCallerFrameNode readCallerFrameNode, @Cached.Exclusive @Cached GetOrCreateDictNode getOrCreateDictNode, @Cached.Exclusive @Cached InlinedConditionProfile haveCallerFrameProfile, @Cached.Exclusive @Cached InlinedConditionProfile haveLocals, @Cached.Exclusive @Cached PyMappingCheckNode mappingCheckNode, @Cached.Exclusive @Cached GetFrameLocalsNode getFrameLocalsNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            PFrame callerFrame = readCallerFrameNode.executeWith(frame, 0);
            Object[] args = PArguments.create();
            boolean haveCallerFrame = haveCallerFrameProfile.profile(inliningTarget, callerFrame != null);
            if (haveCallerFrame) {
                PArguments.setGlobals(args, callerFrame.getGlobals());
            } else {
                PArguments.setGlobals(args, getOrCreateDictNode.execute(inliningTarget, PythonContext.get(inliningTarget).getMainModule()));
            }
            if (haveLocals.profile(inliningTarget, locals instanceof PNone)) {
                if (haveCallerFrame) {
                    Object callerLocals = getFrameLocalsNode.execute(inliningTarget, callerFrame);
                    CreateEvalExecArgumentsNode.setCustomLocals(args, callerLocals);
                } else {
                    CreateEvalExecArgumentsNode.setCustomLocals(args, PArguments.getGlobals(args));
                }
            } else {
                if (!mappingCheckNode.execute(inliningTarget, locals)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.LOCALS_MUST_BE_MAPPING, mode, locals);
                }
                CreateEvalExecArgumentsNode.setCustomLocals(args, locals);
            }
            return args;
        }

        @Specialization
        static Object[] customGlobals(VirtualFrame frame, Node inliningTarget, PDict globals, Object locals, TruffleString mode, @Bind PythonContext context, @Cached.Exclusive @Cached InlinedConditionProfile haveLocals, @Cached.Exclusive @Cached PyMappingCheckNode mappingCheckNode, @Cached.Exclusive @Cached GetOrCreateDictNode getOrCreateDictNode, @Cached.Exclusive @Cached HashingCollectionNodes.SetItemNode setBuiltins, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object[] args = PArguments.create();
            PythonModule builtins = context.getBuiltins();
            if (builtins != null) {
                PDict builtinsDict = getOrCreateDictNode.execute(inliningTarget, builtins);
                setBuiltins.execute((Frame)frame, inliningTarget, globals, BuiltinNames.T___BUILTINS__, builtinsDict);
            }
            PArguments.setGlobals(args, globals);
            if (haveLocals.profile(inliningTarget, locals instanceof PNone)) {
                CreateEvalExecArgumentsNode.setCustomLocals(args, globals);
            } else {
                if (!mappingCheckNode.execute(inliningTarget, locals)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.LOCALS_MUST_BE_MAPPING, mode, locals);
                }
                CreateEvalExecArgumentsNode.setCustomLocals(args, locals);
            }
            return args;
        }

        @Fallback
        static Object[] badGlobals(Node inliningTarget, Object globals, Object locals, TruffleString mode) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.GLOBALS_MUST_BE_DICT, mode, globals);
        }

        private static void setCustomLocals(Object[] args, Object locals) {
            PArguments.setSpecialArgument(args, locals);
        }
    }

    @Builtin(name="divmod", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DivModNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doObject(VirtualFrame frame, Object a, Object b, @Bind Node inliningTarget, @Cached PyNumberDivmodNode divmodNode) {
            return divmodNode.execute(frame, inliningTarget, a, b);
        }
    }

    @Builtin(name="dir", minNumOfPositionalArgs=0, maxNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1)
    @GenerateNodeFactory
    public static abstract class DirNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(object)"})
        Object locals(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached PyEvalGetLocals getLocals, @Cached(value="create(T_KEYS)") LookupAndCallUnaryNode callKeysNode, @Cached ListBuiltins.ListSortNode sortNode, @Cached ListNodes.ConstructListNode constructListNode) {
            Object localsDict = getLocals.execute(frame, inliningTarget);
            Object keysObj = callKeysNode.executeObject(frame, localsDict);
            PList list = constructListNode.execute((Frame)frame, keysObj);
            sortNode.execute(frame, list);
            return list;
        }

        @Specialization(guards={"!isNoValue(object)"})
        static Object dir(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached PyObjectDir dir) {
            return dir.execute(frame, inliningTarget, object);
        }
    }

    @Builtin(name="hash", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        long hash(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached PyObjectHashNode hashNode) {
            return hashNode.execute((Frame)frame, inliningTarget, object);
        }
    }

    @Builtin(name="chr", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"i"})
    @GenerateNodeFactory
    @ArgumentClinic(name="i", conversion=ArgumentClinic.ClinicConversion.Int)
    public static abstract class ChrNode
    extends PythonUnaryClinicBuiltinNode {
        @Specialization
        static TruffleString charFromInt(int arg, @Bind Node inliningTarget, @Cached TruffleString.FromCodePointNode fromCodePointNode, @Cached PRaiseNode raiseNode) {
            if (arg >= 0 && arg <= 0x10FFFF) {
                return fromCodePointNode.execute(arg, PythonUtils.TS_ENCODING, true);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.ARG_NOT_IN_RANGE, "chr()", "0x110000");
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BuiltinFunctionsClinicProviders.ChrNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="callable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CallableNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isCallable(callable)"})
        static boolean doCallable(Object callable) {
            return true;
        }

        @Specialization
        static boolean doGeneric(Object object, @Bind Node inliningTarget, @Cached PyCallableCheckNode callableCheck) {
            return callableCheck.execute(inliningTarget, object);
        }
    }

    @Builtin(name="hex", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HexNode
    extends PythonUnaryBuiltinNode {
        static final TruffleString T_HEX_PREFIX = PythonUtils.tsLiteral("0x");

        @Specialization
        static TruffleString doIt(VirtualFrame frame, Object x, @Bind Node inliningTarget, @Cached BinOctHexHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, x, T_HEX_PREFIX, 16, HexNode::longToString);
        }

        @CompilerDirectives.TruffleBoundary
        private static String longToString(long x) {
            return Long.toHexString(x);
        }
    }

    @Builtin(name="oct", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class OctNode
    extends PythonUnaryBuiltinNode {
        static final TruffleString T_OCT_PREFIX = PythonUtils.tsLiteral("0o");

        @Specialization
        static TruffleString doIt(VirtualFrame frame, Object x, @Bind Node inliningTarget, @Cached BinOctHexHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, x, T_OCT_PREFIX, 8, OctNode::longToString);
        }

        @CompilerDirectives.TruffleBoundary
        private static String longToString(long x) {
            return Long.toOctalString(x);
        }
    }

    @Builtin(name="bin", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class BinNode
    extends PythonUnaryBuiltinNode {
        static final TruffleString T_BIN_PREFIX = PythonUtils.tsLiteral("0b");

        @Specialization
        static TruffleString doIt(VirtualFrame frame, Object x, @Bind Node inliningTarget, @Cached BinOctHexHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, x, T_BIN_PREFIX, 2, BinNode::longToString);
        }

        @CompilerDirectives.TruffleBoundary
        private static String longToString(long x) {
            return Long.toBinaryString(x);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @TypeSystemReference(value=PythonIntegerTypes.class)
    static abstract class BinOctHexHelperNode
    extends Node {
        BinOctHexHelperNode() {
        }

        abstract TruffleString execute(VirtualFrame var1, Node var2, Object var3, TruffleString var4, int var5, LongToString var6);

        @CompilerDirectives.TruffleBoundary
        private static TruffleString buildString(boolean isNegative, TruffleString prefix, TruffleString number) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)(PythonUtils.tsbCapacity(3) + number.byteLength(PythonUtils.TS_ENCODING)));
            if (isNegative) {
                sb.appendStringUncached(StringLiterals.T_MINUS);
            }
            sb.appendStringUncached(prefix);
            sb.appendStringUncached(number);
            return sb.toStringUncached();
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger longMaxPlusOne() {
            return BigInteger.valueOf(Long.MIN_VALUE).abs();
        }

        @CompilerDirectives.TruffleBoundary
        private static String bigToString(int radix, BigInteger x) {
            return x.toString(radix);
        }

        @Specialization
        static TruffleString doL(Node inliningTarget, long x, TruffleString prefix, int radix, LongToString longToString, @Cached.Exclusive @Cached InlinedConditionProfile isMinLong, @Cached.Shared @Cached(inline=false) TruffleString.FromJavaStringNode fromJavaStringNode) {
            if (isMinLong.profile(inliningTarget, x == Long.MIN_VALUE)) {
                return BinOctHexHelperNode.buildString(true, prefix, fromJavaStringNode.execute(BinOctHexHelperNode.bigToString(radix, BinOctHexHelperNode.longMaxPlusOne()), PythonUtils.TS_ENCODING));
            }
            return BinOctHexHelperNode.buildString(x < 0L, prefix, fromJavaStringNode.execute(longToString.convert(Math.abs(x)), PythonUtils.TS_ENCODING));
        }

        @Specialization
        static TruffleString doPI(PInt x, TruffleString prefix, int radix, LongToString longToString, @Cached.Shared @Cached(inline=false) TruffleString.FromJavaStringNode fromJavaStringNode) {
            BigInteger value = x.getValue();
            return BinOctHexHelperNode.buildString(value.signum() < 0, prefix, fromJavaStringNode.execute(BinOctHexHelperNode.bigToString(radix, PInt.abs(value)), PythonUtils.TS_ENCODING));
        }

        @Specialization(replaces={"doL", "doPI"})
        static TruffleString doO(VirtualFrame frame, Node inliningTarget, Object x, TruffleString prefix, int radix, LongToString longToString, @Cached.Exclusive @Cached InlinedConditionProfile isMinLong, @Cached PyNumberIndexNode indexNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached InlinedBranchProfile isInt, @Cached InlinedBranchProfile isLong, @Cached InlinedBranchProfile isPInt, @Cached.Shared @Cached(inline=false) TruffleString.FromJavaStringNode fromJavaStringNode) {
            Object index = indexNode.execute((Frame)frame, inliningTarget, x);
            if (index instanceof Boolean || index instanceof Integer) {
                isInt.enter(inliningTarget);
                return BinOctHexHelperNode.doL(inliningTarget, asSizeNode.executeExact((Frame)frame, inliningTarget, index), prefix, radix, longToString, isMinLong, fromJavaStringNode);
            }
            if (index instanceof Long) {
                isLong.enter(inliningTarget);
                return BinOctHexHelperNode.doL(inliningTarget, (Long)index, prefix, radix, longToString, isMinLong, fromJavaStringNode);
            }
            if (index instanceof PInt) {
                isPInt.enter(inliningTarget);
                return BinOctHexHelperNode.doPI((PInt)index, prefix, radix, longToString, fromJavaStringNode);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("bin/oct/hex with native integer subclasses"));
        }

        @FunctionalInterface
        static interface LongToString {
            public String convert(long var1);
        }
    }

    @Builtin(name="any", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class AnyNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isBuiltinList(object)"})
        static boolean doList(VirtualFrame frame, PList object, @Bind Node inliningTarget, @Cached.Shared(value="allOrAnySeqNode") @Cached AllOrAnySequenceStorageNode allOrAnyNode) {
            return allOrAnyNode.execute(frame, inliningTarget, object.getSequenceStorage(), AnyOrAllNodeType.ANY);
        }

        @Specialization(guards={"isBuiltinTuple(object)"})
        static boolean doTuple(VirtualFrame frame, PTuple object, @Bind Node inliningTarget, @Cached.Shared(value="allOrAnySeqNode") @Cached AllOrAnySequenceStorageNode allOrAnyNode) {
            return allOrAnyNode.execute(frame, inliningTarget, object.getSequenceStorage(), AnyOrAllNodeType.ANY);
        }

        @Specialization(guards={"isBuiltinHashingCollection(object)"})
        static boolean doHashColl(VirtualFrame frame, PHashingCollection object, @Cached AllOrAnyHashingStorageNode allOrAnyNode) {
            return allOrAnyNode.execute((Frame)frame, object.getDictStorage(), AnyOrAllNodeType.ANY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static boolean doObject(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode, @Cached PyObjectIsTrueNode isTrueNode) {
            Object iterator = getIter.execute((Frame)frame, inliningTarget, object);
            int nbrIter = 0;
            while (true) {
                try {
                    Object next = nextNode.execute((Frame)frame, inliningTarget, iterator);
                    ++nbrIter;
                    if (!isTrueNode.execute((Frame)frame, next)) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (IteratorExhausted e) {
                }
                finally {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)nbrIter);
                    continue;
                }
                break;
            }
            return false;
        }
    }

    @Builtin(name="all", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class AllNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isBuiltinList(object)"})
        static boolean doList(VirtualFrame frame, PList object, @Bind Node inliningTarget, @Cached.Shared(value="allOrAnySeqNode") @Cached AllOrAnySequenceStorageNode allOrAnyNode) {
            return allOrAnyNode.execute(frame, inliningTarget, object.getSequenceStorage(), AnyOrAllNodeType.ALL);
        }

        @Specialization(guards={"isBuiltinTuple(object)"})
        static boolean doTuple(VirtualFrame frame, PTuple object, @Bind Node inliningTarget, @Cached.Shared(value="allOrAnySeqNode") @Cached AllOrAnySequenceStorageNode allOrAnyNode) {
            return allOrAnyNode.execute(frame, inliningTarget, object.getSequenceStorage(), AnyOrAllNodeType.ALL);
        }

        @Specialization(guards={"isBuiltinHashingCollection(object)"})
        static boolean doHashColl(VirtualFrame frame, PHashingCollection object, @Cached AllOrAnyHashingStorageNode allOrAnyNode) {
            return allOrAnyNode.execute((Frame)frame, object.getDictStorage(), AnyOrAllNodeType.ALL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static boolean doObject(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode, @Cached PyObjectIsTrueNode isTrueNode) {
            Object iterator = getIter.execute((Frame)frame, inliningTarget, object);
            int nbrIter = 0;
            while (true) {
                try {
                    Object next = nextNode.execute((Frame)frame, inliningTarget, iterator);
                    ++nbrIter;
                    if (isTrueNode.execute((Frame)frame, next)) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (IteratorExhausted e) {
                }
                finally {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)nbrIter);
                    continue;
                }
                break;
            }
            return true;
        }
    }

    @GenerateInline(value=false)
    static abstract class AllOrAnyHashingStorageNode
    extends PNodeWithContext {
        AllOrAnyHashingStorageNode() {
        }

        abstract boolean execute(Frame var1, HashingStorage var2, AnyOrAllNodeType var3);

        @Specialization
        protected boolean doHashStorage(VirtualFrame frame, HashingStorage hashingStorage, AnyOrAllNodeType nodeType, @Bind Node inliningTarget, @Cached PyObjectIsTrueNode isTrueNode, @Cached InlinedLoopConditionProfile loopConditionProfile, @Cached HashingStorageNodes.HashingStorageGetIterator getIter, @Cached HashingStorageNodes.HashingStorageIteratorNext getIterNext, @Cached HashingStorageNodes.HashingStorageIteratorKey getIterKey) {
            HashingStorageNodes.HashingStorageIterator it = getIter.execute(inliningTarget, hashingStorage);
            while (loopConditionProfile.profile(inliningTarget, getIterNext.execute(inliningTarget, hashingStorage, it))) {
                Object key = getIterKey.execute(inliningTarget, hashingStorage, it);
                if (nodeType == AnyOrAllNodeType.ALL) {
                    if (isTrueNode.execute((Frame)frame, key)) continue;
                    return false;
                }
                if (nodeType != AnyOrAllNodeType.ANY || !isTrueNode.execute((Frame)frame, key)) continue;
                return true;
            }
            return nodeType == AnyOrAllNodeType.ALL;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class AllOrAnySequenceStorageNode
    extends PNodeWithContext {
        AllOrAnySequenceStorageNode() {
        }

        abstract boolean execute(VirtualFrame var1, Node var2, SequenceStorage var3, AnyOrAllNodeType var4);

        @Specialization
        static boolean doBoolSequence(Node inliningTarget, BoolSequenceStorage sequenceStorage, AnyOrAllNodeType nodeType, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopConditionProfile, @Cached.Exclusive @Cached InlinedCountingConditionProfile earlyExitProfile) {
            boolean[] internalArray = sequenceStorage.getInternalBoolArray();
            int seqLength = sequenceStorage.length();
            int i = 0;
            while (loopConditionProfile.profile(inliningTarget, i < seqLength)) {
                if (nodeType == AnyOrAllNodeType.ALL && earlyExitProfile.profile(inliningTarget, !internalArray[i])) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                    return false;
                }
                if (nodeType == AnyOrAllNodeType.ANY && earlyExitProfile.profile(inliningTarget, internalArray[i])) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                    return true;
                }
                ++i;
            }
            LoopNode.reportLoopCount((Node)inliningTarget, (int)seqLength);
            return nodeType == AnyOrAllNodeType.ALL;
        }

        @Specialization
        static boolean doIntSequence(Node inliningTarget, IntSequenceStorage sequenceStorage, AnyOrAllNodeType nodeType, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopConditionProfile, @Cached.Exclusive @Cached InlinedCountingConditionProfile earlyExitProfile) {
            int[] internalArray = sequenceStorage.getInternalIntArray();
            int seqLength = sequenceStorage.length();
            int i = 0;
            while (loopConditionProfile.profile(inliningTarget, i < seqLength)) {
                if (nodeType == AnyOrAllNodeType.ALL && earlyExitProfile.profile(inliningTarget, internalArray[i] == 0)) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                    return false;
                }
                if (nodeType == AnyOrAllNodeType.ANY && earlyExitProfile.profile(inliningTarget, internalArray[i] != 0)) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                    return true;
                }
                ++i;
            }
            LoopNode.reportLoopCount((Node)inliningTarget, (int)seqLength);
            return nodeType == AnyOrAllNodeType.ALL;
        }

        @Specialization
        static boolean doGenericSequence(VirtualFrame frame, Node inliningTarget, SequenceStorage sequenceStorage, AnyOrAllNodeType nodeType, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopConditionProfile, @Cached.Exclusive @Cached InlinedCountingConditionProfile earlyExitProfile, @Cached PyObjectIsTrueNode isTrueNode, @Cached SequenceStorageNodes.GetItemScalarNode getItem) {
            int seqLength = sequenceStorage.length();
            int i = 0;
            while (loopConditionProfile.profile(inliningTarget, i < seqLength)) {
                if (nodeType == AnyOrAllNodeType.ALL && earlyExitProfile.profile(inliningTarget, !isTrueNode.execute((Frame)frame, getItem.execute(inliningTarget, sequenceStorage, i)))) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                    return false;
                }
                if (nodeType == AnyOrAllNodeType.ANY && earlyExitProfile.profile(inliningTarget, isTrueNode.execute((Frame)frame, getItem.execute(inliningTarget, sequenceStorage, i)))) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                    return true;
                }
                ++i;
            }
            LoopNode.reportLoopCount((Node)inliningTarget, (int)seqLength);
            return nodeType == AnyOrAllNodeType.ALL;
        }
    }

    static enum AnyOrAllNodeType {
        ALL,
        ANY;

    }

    @Builtin(name="abs", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"x"})
    @GenerateNodeFactory
    public static abstract class AbsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object absObject(VirtualFrame frame, Object object, @Cached PyNumberAbsoluteNode absoluteNode) {
            return absoluteNode.execute(frame, object);
        }
    }
}

