/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar;

import java.util.List;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.Clock;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.FixedSizeExemplarReservoir;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCell;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCellSelector;

class HistogramExemplarReservoir
extends FixedSizeExemplarReservoir<DoubleExemplarData> {
    HistogramExemplarReservoir(Clock clock, List<Double> boundaries) {
        super(clock, boundaries.size() + 1, new HistogramCellSelector(boundaries), ReservoirCell::getAndResetDouble);
    }

    @Override
    public void offerLongMeasurement(long value, Attributes attributes, Context context) {
        super.offerDoubleMeasurement(value, attributes, context);
    }

    static class HistogramCellSelector
    implements ReservoirCellSelector {
        private final double[] boundaries;

        private HistogramCellSelector(List<Double> boundaries) {
            this.boundaries = ExplicitBucketHistogramUtils.createBoundaryArray(boundaries);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, long value, Attributes attributes, Context context) {
            return this.reservoirCellIndexFor(cells, (double)value, attributes, context);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, double value, Attributes attributes, Context context) {
            return ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, value);
        }

        @Override
        public void reset() {
        }
    }
}

