/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.data;

import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.data.ImmutableEventData;

@Immutable
public interface EventData {
    public static EventData create(long epochNanos, String name, Attributes attributes) {
        return ImmutableEventData.create(epochNanos, name, attributes);
    }

    public static EventData create(long epochNanos, String name, Attributes attributes, int totalAttributeCount) {
        return ImmutableEventData.create(epochNanos, name, attributes, totalAttributeCount);
    }

    public String getName();

    public Attributes getAttributes();

    public long getEpochNanos();

    public int getTotalAttributeCount();

    default public int getDroppedAttributesCount() {
        return this.getTotalAttributeCount() - this.getAttributes().size();
    }
}

